/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisFactory;
import redis.clients.jedis.JedisSocketFactory;
import redis.clients.jedis.util.Pool;

public class JedisPool
extends Pool<Jedis> {
    private static final Logger log = LoggerFactory.getLogger(JedisPool.class);

    public JedisPool() {
        this("127.0.0.1", 6379);
    }

    public JedisPool(String url2) {
        this(URI.create(url2));
    }

    public JedisPool(String url2, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(new GenericObjectPoolConfig<Jedis>(), new JedisFactory(URI.create(url2), 2000, 2000, null, sslSocketFactory, sslParameters, hostnameVerifier));
    }

    public JedisPool(String host2, int port2) {
        this(new HostAndPort(host2, port2), DefaultJedisClientConfig.builder().build());
    }

    public JedisPool(String host2, int port2, boolean ssl) {
        this(new HostAndPort(host2, port2), DefaultJedisClientConfig.builder().ssl(ssl).build());
    }

    public JedisPool(String host2, int port2, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(new HostAndPort(host2, port2), DefaultJedisClientConfig.builder().ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public JedisPool(String host2, int port2, String user, String password) {
        this(new HostAndPort(host2, port2), DefaultJedisClientConfig.builder().user(user).password(password).build());
    }

    public JedisPool(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(new JedisFactory(hostAndPort, clientConfig));
    }

    public JedisPool(PooledObjectFactory<Jedis> factory2) {
        super(factory2);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig) {
        this(poolConfig, "127.0.0.1", 6379);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String url2) {
        this(poolConfig, URI.create(url2));
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2) {
        this(poolConfig, host2, port2, 2000);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, boolean ssl) {
        this(poolConfig, host2, port2, 2000, ssl);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host2, port2, 2000, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, String user, String password) {
        this(poolConfig, host2, port2, 2000, user, password, 0);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2) {
        this(poolConfig, host2, port2, timeout2, null);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2, boolean ssl) {
        this(poolConfig, host2, port2, timeout2, null, ssl);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host2, port2, timeout2, null, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2, String password) {
        this(poolConfig, host2, port2, timeout2, password, 0);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2, String password, boolean ssl) {
        this(poolConfig, host2, port2, timeout2, password, 0, ssl);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2, String password, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host2, port2, timeout2, password, 0, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2, String user, String password) {
        this(poolConfig, host2, port2, timeout2, user, password, 0);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2, String user, String password, boolean ssl) {
        this(poolConfig, host2, port2, timeout2, user, password, 0, ssl);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2, String password, int database) {
        this(poolConfig, host2, port2, timeout2, password, database, null);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2, String password, int database, boolean ssl) {
        this(poolConfig, host2, port2, timeout2, password, database, null, ssl);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2, String password, int database, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host2, port2, timeout2, password, database, null, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2, String user, String password, int database) {
        this(poolConfig, host2, port2, timeout2, user, password, database, null);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2, String user, String password, int database, boolean ssl) {
        this(poolConfig, host2, port2, timeout2, user, password, database, null, ssl);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2, String password, int database, String clientName) {
        this(poolConfig, host2, port2, timeout2, timeout2, password, database, clientName);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2, String password, int database, String clientName, boolean ssl) {
        this(poolConfig, host2, port2, timeout2, timeout2, password, database, clientName, ssl);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host2, port2, timeout2, timeout2, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2, String user, String password, int database, String clientName) {
        this(poolConfig, host2, port2, timeout2, timeout2, user, password, database, clientName);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int timeout2, String user, String password, int database, String clientName, boolean ssl) {
        this(poolConfig, host2, port2, timeout2, timeout2, user, password, database, clientName, ssl);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, String password, int database, String clientName) {
        this(poolConfig, new JedisFactory(host2, port2, connectionTimeout, soTimeout, password, database, clientName));
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, String password, int database, String clientName, boolean ssl) {
        this(poolConfig, host2, port2, connectionTimeout, soTimeout, password, database, clientName, ssl, null, null, null);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, new JedisFactory(host2, port2, connectionTimeout, soTimeout, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier));
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, String user, String password, int database, String clientName) {
        this(poolConfig, new JedisFactory(host2, port2, connectionTimeout, soTimeout, user, password, database, clientName));
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, String user, String password, int database, String clientName, boolean ssl) {
        this(poolConfig, host2, port2, connectionTimeout, soTimeout, user, password, database, clientName, ssl, null, null, null);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, String user, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host2, port2, connectionTimeout, soTimeout, 0, user, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host2, port2, connectionTimeout, soTimeout, infiniteSoTimeout, null, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, int database, String clientName) {
        this(poolConfig, new JedisFactory(host2, port2, connectionTimeout, soTimeout, infiniteSoTimeout, user, password, database, clientName));
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, new JedisFactory(host2, port2, connectionTimeout, soTimeout, infiniteSoTimeout, user, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier));
    }

    public JedisPool(URI uri2) {
        this(new GenericObjectPoolConfig<Jedis>(), uri2);
    }

    public JedisPool(URI uri2, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(new GenericObjectPoolConfig<Jedis>(), uri2, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPool(URI uri2, int timeout2) {
        this(new GenericObjectPoolConfig<Jedis>(), uri2, timeout2);
    }

    public JedisPool(URI uri2, int timeout2, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(new GenericObjectPoolConfig<Jedis>(), uri2, timeout2, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, URI uri2) {
        this(poolConfig, uri2, 2000);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, URI uri2, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, uri2, 2000, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, URI uri2, int timeout2) {
        this(poolConfig, uri2, timeout2, timeout2);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, URI uri2, int timeout2, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, uri2, timeout2, timeout2, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, URI uri2, int connectionTimeout, int soTimeout) {
        this(poolConfig, uri2, connectionTimeout, soTimeout, null, null, null);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, URI uri2, int connectionTimeout, int soTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, new JedisFactory(uri2, connectionTimeout, soTimeout, null, sslSocketFactory, sslParameters, hostnameVerifier));
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, URI uri2, int connectionTimeout, int soTimeout, int infiniteSoTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, new JedisFactory(uri2, connectionTimeout, soTimeout, infiniteSoTimeout, null, sslSocketFactory, sslParameters, hostnameVerifier));
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(poolConfig, new JedisFactory(hostAndPort, clientConfig));
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, JedisSocketFactory jedisSocketFactory, JedisClientConfig clientConfig) {
        this(poolConfig, new JedisFactory(jedisSocketFactory, clientConfig));
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, PooledObjectFactory<Jedis> factory2) {
        super(poolConfig, factory2);
    }

    @Override
    public Jedis getResource() {
        Jedis jedis = (Jedis)super.getResource();
        jedis.setDataSource(this);
        return jedis;
    }

    @Override
    public void returnResource(Jedis resource2) {
        if (resource2 != null) {
            try {
                resource2.resetState();
                super.returnResource(resource2);
            }
            catch (RuntimeException e2) {
                super.returnBrokenResource(resource2);
                log.warn("Resource is returned to the pool as broken", e2);
            }
        }
    }
}

