/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionFactory;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisSocketFactory;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.csc.Cache;
import redis.clients.jedis.csc.CacheConfig;
import redis.clients.jedis.csc.CacheFactory;
import redis.clients.jedis.providers.ConnectionProvider;
import redis.clients.jedis.providers.PooledConnectionProvider;
import redis.clients.jedis.util.JedisURIHelper;
import redis.clients.jedis.util.Pool;

public class JedisPooled
extends UnifiedJedis {
    public JedisPooled() {
        this("127.0.0.1", 6379);
    }

    public JedisPooled(String url2) {
        super(url2);
    }

    public JedisPooled(String url2, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(URI.create(url2), sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(String host2, int port2) {
        this(new HostAndPort(host2, port2));
    }

    public JedisPooled(HostAndPort hostAndPort) {
        super(hostAndPort);
    }

    public JedisPooled(String host2, int port2, boolean ssl) {
        this(new HostAndPort(host2, port2), (JedisClientConfig)DefaultJedisClientConfig.builder().ssl(ssl).build());
    }

    public JedisPooled(String host2, int port2, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(new HostAndPort(host2, port2), (JedisClientConfig)DefaultJedisClientConfig.builder().ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public JedisPooled(String host2, int port2, String user, String password) {
        this(new HostAndPort(host2, port2), (JedisClientConfig)DefaultJedisClientConfig.builder().user(user).password(password).build());
    }

    public JedisPooled(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        super(hostAndPort, clientConfig);
    }

    @Experimental
    public JedisPooled(HostAndPort hostAndPort, JedisClientConfig clientConfig, CacheConfig cacheConfig) {
        this(hostAndPort, clientConfig, CacheFactory.getCache(cacheConfig));
    }

    @Experimental
    public JedisPooled(HostAndPort hostAndPort, JedisClientConfig clientConfig, Cache clientSideCache) {
        super(hostAndPort, clientConfig, clientSideCache);
    }

    public JedisPooled(PooledObjectFactory<Connection> factory2) {
        this(new PooledConnectionProvider(factory2));
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig) {
        this(poolConfig, "127.0.0.1", 6379);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String url2) {
        this(poolConfig, URI.create(url2));
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2) {
        this(poolConfig, host2, port2, 2000);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, boolean ssl) {
        this(poolConfig, host2, port2, 2000, ssl);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host2, port2, 2000, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, String user, String password) {
        this(poolConfig, host2, port2, 2000, user, password, 0);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2) {
        this(poolConfig, host2, port2, timeout2, null);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2, boolean ssl) {
        this(poolConfig, host2, port2, timeout2, null, ssl);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host2, port2, timeout2, null, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2, String password) {
        this(poolConfig, host2, port2, timeout2, password, 0);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2, String password, boolean ssl) {
        this(poolConfig, host2, port2, timeout2, password, 0, ssl);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2, String password, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host2, port2, timeout2, password, 0, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2, String user, String password) {
        this(poolConfig, host2, port2, timeout2, user, password, 0);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2, String user, String password, boolean ssl) {
        this(poolConfig, host2, port2, timeout2, user, password, 0, ssl);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2, String password, int database) {
        this(poolConfig, host2, port2, timeout2, password, database, null);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2, String password, int database, boolean ssl) {
        this(poolConfig, host2, port2, timeout2, password, database, null, ssl);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2, String password, int database, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host2, port2, timeout2, password, database, null, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2, String user, String password, int database) {
        this(poolConfig, host2, port2, timeout2, user, password, database, null);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2, String user, String password, int database, boolean ssl) {
        this(poolConfig, host2, port2, timeout2, user, password, database, null, ssl);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2, String password, int database, String clientName) {
        this(poolConfig, host2, port2, timeout2, timeout2, password, database, clientName);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2, String password, int database, String clientName, boolean ssl) {
        this(poolConfig, host2, port2, timeout2, timeout2, password, database, clientName, ssl);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host2, port2, timeout2, timeout2, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2, String user, String password, int database, String clientName) {
        this(poolConfig, host2, port2, timeout2, timeout2, user, password, database, clientName);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int timeout2, String user, String password, int database, String clientName, boolean ssl) {
        this(poolConfig, host2, port2, timeout2, timeout2, user, password, database, clientName, ssl);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, String password, int database, String clientName) {
        this(poolConfig, host2, port2, connectionTimeout, soTimeout, null, password, database, clientName);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, String password, int database, String clientName, boolean ssl) {
        this(poolConfig, host2, port2, connectionTimeout, soTimeout, password, database, clientName, ssl, null, null, null);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host2, port2, connectionTimeout, soTimeout, null, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, String user, String password, int database, String clientName) {
        this(poolConfig, host2, port2, connectionTimeout, soTimeout, 0, user, password, database, clientName);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, String user, String password, int database, String clientName, boolean ssl) {
        this(poolConfig, host2, port2, connectionTimeout, soTimeout, user, password, database, clientName, ssl, null, null, null);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, String user, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host2, port2, connectionTimeout, soTimeout, 0, user, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host2, port2, connectionTimeout, soTimeout, infiniteSoTimeout, null, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, int database, String clientName) {
        this(new HostAndPort(host2, port2), (JedisClientConfig)DefaultJedisClientConfig.create(connectionTimeout, soTimeout, infiniteSoTimeout, user, password, database, clientName, false, null, null, null, null), poolConfig);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, String host2, int port2, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(new HostAndPort(host2, port2), (JedisClientConfig)DefaultJedisClientConfig.create(connectionTimeout, soTimeout, infiniteSoTimeout, user, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier, null), poolConfig);
    }

    public JedisPooled(URI uri2) {
        super(uri2);
    }

    public JedisPooled(URI uri2, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(new GenericObjectPoolConfig<Connection>(), uri2, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(URI uri2, int timeout2) {
        this(new GenericObjectPoolConfig<Connection>(), uri2, timeout2);
    }

    public JedisPooled(URI uri2, int timeout2, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(new GenericObjectPoolConfig<Connection>(), uri2, timeout2, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, URI uri2) {
        this(poolConfig, uri2, 2000);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, URI uri2, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, uri2, 2000, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, URI uri2, int timeout2) {
        this(poolConfig, uri2, timeout2, timeout2);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, URI uri2, int timeout2, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, uri2, timeout2, timeout2, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, URI uri2, int connectionTimeout, int soTimeout) {
        this(poolConfig, uri2, connectionTimeout, soTimeout, null, null, null);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, URI uri2, int connectionTimeout, int soTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, uri2, connectionTimeout, soTimeout, 0, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, URI uri2, int connectionTimeout, int soTimeout, int infiniteSoTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(new HostAndPort(uri2.getHost(), uri2.getPort()), (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).blockingSocketTimeoutMillis(infiniteSoTimeout).user(JedisURIHelper.getUser(uri2)).password(JedisURIHelper.getPassword(uri2)).database(JedisURIHelper.getDBIndex(uri2)).protocol(JedisURIHelper.getRedisProtocol(uri2)).ssl(JedisURIHelper.isRedisSSLScheme(uri2)).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build(), poolConfig);
    }

    public JedisPooled(HostAndPort hostAndPort, GenericObjectPoolConfig<Connection> poolConfig) {
        this(hostAndPort, (JedisClientConfig)DefaultJedisClientConfig.builder().build(), poolConfig);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(hostAndPort, clientConfig, poolConfig);
    }

    public JedisPooled(HostAndPort hostAndPort, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig) {
        super(new PooledConnectionProvider(hostAndPort, clientConfig, poolConfig), clientConfig.getRedisProtocol());
    }

    @Experimental
    public JedisPooled(HostAndPort hostAndPort, JedisClientConfig clientConfig, CacheConfig cacheConfig, GenericObjectPoolConfig<Connection> poolConfig) {
        this(hostAndPort, clientConfig, CacheFactory.getCache(cacheConfig), poolConfig);
    }

    @Experimental
    public JedisPooled(HostAndPort hostAndPort, JedisClientConfig clientConfig, Cache clientSideCache, GenericObjectPoolConfig<Connection> poolConfig) {
        super((ConnectionProvider)new PooledConnectionProvider(hostAndPort, clientConfig, clientSideCache, poolConfig), clientConfig.getRedisProtocol(), clientSideCache);
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, JedisSocketFactory jedisSocketFactory, JedisClientConfig clientConfig) {
        super(new PooledConnectionProvider(new ConnectionFactory(jedisSocketFactory, clientConfig), poolConfig), clientConfig.getRedisProtocol());
    }

    public JedisPooled(GenericObjectPoolConfig<Connection> poolConfig, PooledObjectFactory<Connection> factory2) {
        this(factory2, poolConfig);
    }

    public JedisPooled(PooledObjectFactory<Connection> factory2, GenericObjectPoolConfig<Connection> poolConfig) {
        this(new PooledConnectionProvider(factory2, poolConfig));
    }

    public JedisPooled(PooledConnectionProvider provider2) {
        super(provider2);
    }

    public final Pool<Connection> getPool() {
        return ((PooledConnectionProvider)this.provider).getPool();
    }

    @Override
    public Pipeline pipelined() {
        return (Pipeline)super.pipelined();
    }
}

