/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Arrays;
import java.util.List;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.util.SafeEncoder;

public abstract class JedisPubSubBase<T> {
    private int subscribedChannels = 0;
    private volatile Connection client;

    public void onMessage(T channel2, T message) {
    }

    public void onPMessage(T pattern2, T channel2, T message) {
    }

    public void onSubscribe(T channel2, int subscribedChannels) {
    }

    public void onUnsubscribe(T channel2, int subscribedChannels) {
    }

    public void onPUnsubscribe(T pattern2, int subscribedChannels) {
    }

    public void onPSubscribe(T pattern2, int subscribedChannels) {
    }

    public void onPong(T pattern2) {
    }

    private void sendAndFlushCommand(Protocol.Command command2, T ... args2) {
        if (this.client == null) {
            throw new JedisException(this.getClass() + " is not connected to a Connection.");
        }
        CommandArguments cargs = new CommandArguments(command2).addObjects(args2);
        this.client.sendCommand(cargs);
        this.client.flush();
    }

    public final void unsubscribe() {
        this.sendAndFlushCommand(Protocol.Command.UNSUBSCRIBE, new Object[0]);
    }

    public final void unsubscribe(T ... channels) {
        this.sendAndFlushCommand(Protocol.Command.UNSUBSCRIBE, channels);
    }

    public final void subscribe(T ... channels) {
        this.sendAndFlushCommand(Protocol.Command.SUBSCRIBE, channels);
    }

    public final void psubscribe(T ... patterns2) {
        this.sendAndFlushCommand(Protocol.Command.PSUBSCRIBE, patterns2);
    }

    public final void punsubscribe() {
        this.sendAndFlushCommand(Protocol.Command.PUNSUBSCRIBE, new Object[0]);
    }

    public final void punsubscribe(T ... patterns2) {
        this.sendAndFlushCommand(Protocol.Command.PUNSUBSCRIBE, patterns2);
    }

    public final void ping() {
        this.sendAndFlushCommand(Protocol.Command.PING, new Object[0]);
    }

    public final void ping(T argument) {
        this.sendAndFlushCommand(Protocol.Command.PING, argument);
    }

    public final boolean isSubscribed() {
        return this.subscribedChannels > 0;
    }

    public final int getSubscribedChannels() {
        return this.subscribedChannels;
    }

    public final void proceed(Connection client2, T ... channels) {
        this.client = client2;
        this.client.setTimeoutInfinite();
        try {
            this.subscribe(channels);
            this.process();
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    public final void proceedWithPatterns(Connection client2, T ... patterns2) {
        this.client = client2;
        this.client.setTimeoutInfinite();
        try {
            this.psubscribe(patterns2);
            this.process();
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    protected abstract T encode(byte[] var1);

    private void process() {
        do {
            Object reply;
            if ((reply = this.client.getUnflushedObject()) instanceof List) {
                T enpattern;
                byte[] bpattern;
                T enchannel;
                byte[] bchannel;
                List listReply = (List)reply;
                Object firstObj = listReply.get(0);
                if (!(firstObj instanceof byte[])) {
                    throw new JedisException("Unknown message type: " + firstObj);
                }
                byte[] resp = (byte[])firstObj;
                if (Arrays.equals(Protocol.ResponseKeyword.SUBSCRIBE.getRaw(), resp)) {
                    this.subscribedChannels = ((Long)listReply.get(2)).intValue();
                    bchannel = (byte[])listReply.get(1);
                    enchannel = bchannel == null ? null : (T)this.encode(bchannel);
                    this.onSubscribe(enchannel, this.subscribedChannels);
                    continue;
                }
                if (Arrays.equals(Protocol.ResponseKeyword.UNSUBSCRIBE.getRaw(), resp)) {
                    this.subscribedChannels = ((Long)listReply.get(2)).intValue();
                    bchannel = (byte[])listReply.get(1);
                    enchannel = bchannel == null ? null : (T)this.encode(bchannel);
                    this.onUnsubscribe(enchannel, this.subscribedChannels);
                    continue;
                }
                if (Arrays.equals(Protocol.ResponseKeyword.MESSAGE.getRaw(), resp)) {
                    T enchannel2;
                    bchannel = (byte[])listReply.get(1);
                    Object mesg = listReply.get(2);
                    T t2 = enchannel2 = bchannel == null ? null : (T)this.encode(bchannel);
                    if (mesg instanceof List) {
                        ((List)mesg).forEach(bmesg -> this.onMessage(enchannel2, this.encode((byte[])bmesg)));
                        continue;
                    }
                    this.onMessage(enchannel2, mesg == null ? null : (T)this.encode((byte[])mesg));
                    continue;
                }
                if (Arrays.equals(Protocol.ResponseKeyword.PMESSAGE.getRaw(), resp)) {
                    bpattern = (byte[])listReply.get(1);
                    byte[] bchannel2 = (byte[])listReply.get(2);
                    byte[] bmesg2 = (byte[])listReply.get(3);
                    T enpattern2 = bpattern == null ? null : (T)this.encode(bpattern);
                    T enchannel3 = bchannel2 == null ? null : (T)this.encode(bchannel2);
                    T enmesg = bmesg2 == null ? null : (T)this.encode(bmesg2);
                    this.onPMessage(enpattern2, enchannel3, enmesg);
                    continue;
                }
                if (Arrays.equals(Protocol.ResponseKeyword.PSUBSCRIBE.getRaw(), resp)) {
                    this.subscribedChannels = ((Long)listReply.get(2)).intValue();
                    bpattern = (byte[])listReply.get(1);
                    enpattern = bpattern == null ? null : (T)this.encode(bpattern);
                    this.onPSubscribe(enpattern, this.subscribedChannels);
                    continue;
                }
                if (Arrays.equals(Protocol.ResponseKeyword.PUNSUBSCRIBE.getRaw(), resp)) {
                    this.subscribedChannels = ((Long)listReply.get(2)).intValue();
                    bpattern = (byte[])listReply.get(1);
                    enpattern = bpattern == null ? null : (T)this.encode(bpattern);
                    this.onPUnsubscribe(enpattern, this.subscribedChannels);
                    continue;
                }
                if (Arrays.equals(Protocol.ResponseKeyword.PONG.getRaw(), resp)) {
                    bpattern = (byte[])listReply.get(1);
                    enpattern = bpattern == null ? null : (T)this.encode(bpattern);
                    this.onPong(enpattern);
                    continue;
                }
                throw new JedisException("Unknown message type: " + firstObj);
            }
            if (reply instanceof byte[]) {
                byte[] resp = (byte[])reply;
                if ("PONG".equals(SafeEncoder.encode(resp))) {
                    this.onPong(null);
                    continue;
                }
                this.onPong(this.encode(resp));
                continue;
            }
            throw new JedisException("Unknown message type: " + reply);
        } while (!Thread.currentThread().isInterrupted() && this.isSubscribed());
    }
}

