/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.CommandObjects;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.Response;
import redis.clients.jedis.commands.DatabasePipelineCommands;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.graph.GraphCommandObjects;
import redis.clients.jedis.params.MigrateParams;
import redis.clients.jedis.util.IOUtils;
import redis.clients.jedis.util.KeyValue;

public class Pipeline
extends PipelineBase
implements DatabasePipelineCommands,
Closeable {
    private final Queue<Response<?>> pipelinedResponses = new LinkedList();
    protected final Connection connection;
    private final boolean closeConnection;

    public Pipeline(Jedis jedis) {
        this(jedis.getConnection(), false);
    }

    public Pipeline(Connection connection) {
        this(connection, false);
    }

    public Pipeline(Connection connection, boolean closeConnection) {
        this(connection, closeConnection, Pipeline.createCommandObjects(connection));
    }

    private static CommandObjects createCommandObjects(Connection connection) {
        CommandObjects commandObjects = new CommandObjects();
        RedisProtocol proto = connection.getRedisProtocol();
        if (proto != null) {
            commandObjects.setProtocol(proto);
        }
        return commandObjects;
    }

    Pipeline(Connection connection, boolean closeConnection, CommandObjects commandObjects) {
        super(commandObjects);
        this.connection = connection;
        this.closeConnection = closeConnection;
        GraphCommandObjects graphCommandObjects = new GraphCommandObjects(this.connection);
        graphCommandObjects.setBaseCommandArgumentsCreator(protocolCommand -> commandObjects.commandArguments((ProtocolCommand)protocolCommand));
        this.setGraphCommands(graphCommandObjects);
    }

    @Override
    public final <T> Response<T> appendCommand(CommandObject<T> commandObject) {
        this.connection.sendCommand(commandObject.getArguments());
        Response<T> response2 = new Response<T>(commandObject.getBuilder());
        this.pipelinedResponses.add(response2);
        return response2;
    }

    @Override
    public void close() {
        try {
            this.sync();
        }
        finally {
            if (this.closeConnection) {
                IOUtils.closeQuietly(this.connection);
            }
        }
    }

    @Override
    public void sync() {
        if (!this.hasPipelinedResponse()) {
            return;
        }
        List<Object> unformatted = this.connection.getMany(this.pipelinedResponses.size());
        for (Object rawReply : unformatted) {
            this.pipelinedResponses.poll().set(rawReply);
        }
    }

    public List<Object> syncAndReturnAll() {
        if (this.hasPipelinedResponse()) {
            List<Object> unformatted = this.connection.getMany(this.pipelinedResponses.size());
            ArrayList<Object> formatted = new ArrayList<Object>();
            for (Object rawReply : unformatted) {
                try {
                    Response<?> response2 = this.pipelinedResponses.poll();
                    response2.set(rawReply);
                    formatted.add(response2.get());
                }
                catch (JedisDataException e2) {
                    formatted.add(e2);
                }
            }
            return formatted;
        }
        return Collections.emptyList();
    }

    public final boolean hasPipelinedResponse() {
        return this.pipelinedResponses.size() > 0;
    }

    public Response<Long> waitReplicas(int replicas, long timeout2) {
        return this.appendCommand(this.commandObjects.waitReplicas(replicas, timeout2));
    }

    public Response<KeyValue<Long, Long>> waitAOF(long numLocal, long numReplicas, long timeout2) {
        return this.appendCommand(this.commandObjects.waitAOF(numLocal, numReplicas, timeout2));
    }

    public Response<List<String>> time() {
        return this.appendCommand(new CommandObject<List<String>>(this.commandObjects.commandArguments(Protocol.Command.TIME), BuilderFactory.STRING_LIST));
    }

    @Override
    public Response<String> select(int index) {
        return this.appendCommand(new CommandObject<String>(this.commandObjects.commandArguments(Protocol.Command.SELECT).add(index), BuilderFactory.STRING));
    }

    @Override
    public Response<Long> dbSize() {
        return this.appendCommand(new CommandObject<Long>(this.commandObjects.commandArguments(Protocol.Command.DBSIZE), BuilderFactory.LONG));
    }

    @Override
    public Response<String> swapDB(int index1, int index2) {
        return this.appendCommand(new CommandObject<String>(this.commandObjects.commandArguments(Protocol.Command.SWAPDB).add(index1).add(index2), BuilderFactory.STRING));
    }

    @Override
    public Response<Long> move(String key2, int dbIndex) {
        return this.appendCommand(new CommandObject<Long>(this.commandObjects.commandArguments(Protocol.Command.MOVE).key(key2).add(dbIndex), BuilderFactory.LONG));
    }

    @Override
    public Response<Long> move(byte[] key2, int dbIndex) {
        return this.appendCommand(new CommandObject<Long>(this.commandObjects.commandArguments(Protocol.Command.MOVE).key(key2).add(dbIndex), BuilderFactory.LONG));
    }

    @Override
    public Response<Boolean> copy(String srcKey, String dstKey, int db, boolean replace) {
        return this.appendCommand(this.commandObjects.copy(srcKey, dstKey, db, replace));
    }

    @Override
    public Response<Boolean> copy(byte[] srcKey, byte[] dstKey, int db, boolean replace) {
        return this.appendCommand(this.commandObjects.copy(srcKey, dstKey, db, replace));
    }

    @Override
    public Response<String> migrate(String host2, int port2, byte[] key2, int destinationDB, int timeout2) {
        return this.appendCommand(this.commandObjects.migrate(host2, port2, key2, destinationDB, timeout2));
    }

    @Override
    public Response<String> migrate(String host2, int port2, String key2, int destinationDB, int timeout2) {
        return this.appendCommand(this.commandObjects.migrate(host2, port2, key2, destinationDB, timeout2));
    }

    @Override
    public Response<String> migrate(String host2, int port2, int destinationDB, int timeout2, MigrateParams params, byte[] ... keys2) {
        return this.appendCommand(this.commandObjects.migrate(host2, port2, destinationDB, timeout2, params, keys2));
    }

    @Override
    public Response<String> migrate(String host2, int port2, int destinationDB, int timeout2, MigrateParams params, String ... keys2) {
        return this.appendCommand(this.commandObjects.migrate(host2, port2, destinationDB, timeout2, params, keys2));
    }
}

