/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.CommandObjects;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.Response;
import redis.clients.jedis.TransactionBase;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.graph.GraphCommandObjects;

public class ReliableTransaction
extends TransactionBase {
    private static final String QUEUED_STR = "QUEUED";
    private final Queue<Response<?>> pipelinedResponses = new LinkedList();
    protected final Connection connection;
    private final boolean closeConnection;
    private boolean broken = false;
    private boolean inWatch = false;
    private boolean inMulti = false;

    public ReliableTransaction(Connection connection) {
        this(connection, true);
    }

    public ReliableTransaction(Connection connection, boolean doMulti) {
        this(connection, doMulti, false);
    }

    public ReliableTransaction(Connection connection, boolean doMulti, boolean closeConnection) {
        this(connection, doMulti, closeConnection, ReliableTransaction.createCommandObjects(connection));
    }

    ReliableTransaction(Connection connection, boolean doMulti, boolean closeConnection, CommandObjects commandObjects) {
        super(commandObjects);
        this.connection = connection;
        this.closeConnection = closeConnection;
        GraphCommandObjects graphCommandObjects = new GraphCommandObjects(this.connection);
        graphCommandObjects.setBaseCommandArgumentsCreator(protocolCommand -> commandObjects.commandArguments((ProtocolCommand)protocolCommand));
        this.setGraphCommands(graphCommandObjects);
        if (doMulti) {
            this.multi();
        }
    }

    private static CommandObjects createCommandObjects(Connection connection) {
        CommandObjects commandObjects = new CommandObjects();
        RedisProtocol proto = connection.getRedisProtocol();
        if (proto != null) {
            commandObjects.setProtocol(proto);
        }
        return commandObjects;
    }

    @Override
    public final void multi() {
        this.connection.sendCommand(Protocol.Command.MULTI);
        String status2 = this.connection.getStatusCodeReply();
        if (!"OK".equals(status2)) {
            throw new JedisException("MULTI command failed. Received response: " + status2);
        }
        this.inMulti = true;
    }

    @Override
    public String watch(String ... keys2) {
        String status2 = this.connection.executeCommand(this.commandObjects.watch(keys2));
        this.inWatch = true;
        return status2;
    }

    @Override
    public String watch(byte[] ... keys2) {
        String status2 = this.connection.executeCommand(this.commandObjects.watch(keys2));
        this.inWatch = true;
        return status2;
    }

    @Override
    public String unwatch() {
        this.connection.sendCommand(Protocol.Command.UNWATCH);
        String status2 = this.connection.getStatusCodeReply();
        this.inWatch = false;
        return status2;
    }

    @Override
    protected final <T> Response<T> appendCommand(CommandObject<T> commandObject) {
        this.connection.sendCommand(commandObject.getArguments());
        String status2 = this.connection.getStatusCodeReply();
        if (!QUEUED_STR.equals(status2)) {
            throw new JedisException(status2);
        }
        Response<T> response2 = new Response<T>(commandObject.getBuilder());
        this.pipelinedResponses.add(response2);
        return response2;
    }

    @Override
    public final void close() {
        try {
            this.clear();
        }
        finally {
            if (this.closeConnection) {
                this.connection.close();
            }
        }
    }

    @Deprecated
    public final void clear() {
        if (this.broken) {
            return;
        }
        if (this.inMulti) {
            this.discard();
        } else if (this.inWatch) {
            this.unwatch();
        }
    }

    @Override
    public List<Object> exec() {
        if (!this.inMulti) {
            throw new IllegalStateException("EXEC without MULTI");
        }
        try {
            this.connection.sendCommand(Protocol.Command.EXEC);
            List<Object> unformatted = this.connection.getObjectMultiBulkReply();
            if (unformatted == null) {
                this.pipelinedResponses.clear();
                List<Object> list = null;
                return list;
            }
            ArrayList<Object> formatted = new ArrayList<Object>(unformatted.size());
            for (Object o : unformatted) {
                try {
                    Response<?> response2 = this.pipelinedResponses.poll();
                    response2.set(o);
                    formatted.add(response2.get());
                }
                catch (JedisDataException e2) {
                    formatted.add(e2);
                }
            }
            ArrayList<Object> arrayList = formatted;
            return arrayList;
        }
        catch (JedisConnectionException jce) {
            this.broken = true;
            throw jce;
        }
        finally {
            this.inMulti = false;
            this.inWatch = false;
            this.pipelinedResponses.clear();
        }
    }

    @Override
    public String discard() {
        if (!this.inMulti) {
            throw new IllegalStateException("DISCARD without MULTI");
        }
        try {
            this.connection.sendCommand(Protocol.Command.DISCARD);
            String status2 = this.connection.getStatusCodeReply();
            if (!"OK".equals(status2)) {
                throw new JedisException("DISCARD command failed. Received response: " + status2);
            }
            String string = status2;
            return string;
        }
        catch (JedisConnectionException jce) {
            this.broken = true;
            throw jce;
        }
        finally {
            this.inMulti = false;
            this.inWatch = false;
            this.pipelinedResponses.clear();
        }
    }
}

