/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.function.Supplier;
import redis.clients.jedis.Builder;
import redis.clients.jedis.exceptions.JedisDataException;

public class Response<T>
implements Supplier<T> {
    protected T response = null;
    protected JedisDataException exception = null;
    private boolean building = false;
    private boolean built = false;
    private boolean set = false;
    private Builder<T> builder;
    private Object data;
    private Response<?> dependency = null;

    public Response(Builder<T> b2) {
        this.builder = b2;
    }

    public void set(Object data2) {
        this.data = data2;
        this.set = true;
    }

    @Override
    public T get() {
        if (this.dependency != null && this.dependency.set && !this.dependency.built) {
            super.build();
        }
        if (!this.set) {
            throw new IllegalStateException("Please close pipeline or multi block before calling this method.");
        }
        if (!this.built) {
            this.build();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.response;
    }

    public void setDependency(Response<?> dependency) {
        this.dependency = dependency;
    }

    private void build() {
        if (this.building) {
            return;
        }
        this.building = true;
        try {
            if (this.data != null) {
                if (this.data instanceof JedisDataException) {
                    this.exception = (JedisDataException)this.data;
                } else {
                    this.response = this.builder.build(this.data);
                }
            }
            this.data = null;
        }
        finally {
            this.building = false;
            this.built = true;
        }
    }

    public String toString() {
        return "Response " + this.builder.toString();
    }
}

