/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Collection;
import java.util.function.Function;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.providers.ConnectionProvider;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.util.JedisCommandIterationBase;

public class ScanIteration
extends JedisCommandIterationBase<ScanResult<String>, String> {
    private final int count;
    private final Function<String, CommandArguments> args;

    public ScanIteration(ConnectionProvider connectionProvider, int batchCount, String match2) {
        super(connectionProvider, BuilderFactory.SCAN_RESPONSE);
        this.count = batchCount;
        this.args = cursor -> new CommandArguments(Protocol.Command.SCAN).add((String)cursor).add(Protocol.Keyword.MATCH).add(match2).add(Protocol.Keyword.COUNT).add(this.count);
    }

    public ScanIteration(ConnectionProvider connectionProvider, int batchCount, String match2, String type2) {
        super(connectionProvider, BuilderFactory.SCAN_RESPONSE);
        this.count = batchCount;
        this.args = cursor -> new CommandArguments(Protocol.Command.SCAN).add((String)cursor).add(Protocol.Keyword.MATCH).add(match2).add(Protocol.Keyword.COUNT).add(this.count).add(Protocol.Keyword.TYPE).add(type2);
    }

    @Override
    protected boolean isNodeCompleted(ScanResult<String> reply) {
        return reply.isCompleteIteration();
    }

    @Override
    protected CommandArguments initCommandArguments() {
        return this.args.apply(ScanParams.SCAN_POINTER_START);
    }

    @Override
    protected CommandArguments nextCommandArguments(ScanResult<String> lastReply) {
        return this.args.apply(lastReply.getCursor());
    }

    @Override
    protected Collection<String> convertBatchToData(ScanResult<String> batch) {
        return batch.getResult();
    }
}

