/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.json.JSONArray;
import redis.clients.jedis.AbstractTransaction;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.ClusterCommandObjects;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandKeyArgumentPreProcessor;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.CommandObjects;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisBroadcastAndRoundRobinConfig;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisSocketFactory;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.ScanIteration;
import redis.clients.jedis.ShardedCommandObjects;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.annots.VisibleForTesting;
import redis.clients.jedis.args.BitCountOption;
import redis.clients.jedis.args.BitOP;
import redis.clients.jedis.args.ExpiryOption;
import redis.clients.jedis.args.FlushMode;
import redis.clients.jedis.args.FunctionRestorePolicy;
import redis.clients.jedis.args.GeoUnit;
import redis.clients.jedis.args.ListDirection;
import redis.clients.jedis.args.ListPosition;
import redis.clients.jedis.args.SortedSetOption;
import redis.clients.jedis.bloom.BFInsertParams;
import redis.clients.jedis.bloom.BFReserveParams;
import redis.clients.jedis.bloom.CFInsertParams;
import redis.clients.jedis.bloom.CFReserveParams;
import redis.clients.jedis.bloom.TDigestMergeParams;
import redis.clients.jedis.commands.JedisBinaryCommands;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.commands.RedisModuleCommands;
import redis.clients.jedis.commands.SampleBinaryKeyedCommands;
import redis.clients.jedis.commands.SampleKeyedCommands;
import redis.clients.jedis.csc.Cache;
import redis.clients.jedis.csc.CacheConfig;
import redis.clients.jedis.csc.CacheConnection;
import redis.clients.jedis.csc.CacheFactory;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.executors.ClusterCommandExecutor;
import redis.clients.jedis.executors.CommandExecutor;
import redis.clients.jedis.executors.DefaultCommandExecutor;
import redis.clients.jedis.executors.RetryableCommandExecutor;
import redis.clients.jedis.executors.SimpleCommandExecutor;
import redis.clients.jedis.gears.TFunctionListParams;
import redis.clients.jedis.gears.TFunctionLoadParams;
import redis.clients.jedis.gears.resps.GearsLibraryInfo;
import redis.clients.jedis.graph.GraphCommandObjects;
import redis.clients.jedis.graph.ResultSet;
import redis.clients.jedis.json.JsonObjectMapper;
import redis.clients.jedis.json.JsonSetParams;
import redis.clients.jedis.json.Path;
import redis.clients.jedis.json.Path2;
import redis.clients.jedis.mcf.CircuitBreakerCommandExecutor;
import redis.clients.jedis.mcf.MultiClusterPipeline;
import redis.clients.jedis.mcf.MultiClusterTransaction;
import redis.clients.jedis.params.BitPosParams;
import redis.clients.jedis.params.GeoAddParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.GeoRadiusStoreParam;
import redis.clients.jedis.params.GeoSearchParam;
import redis.clients.jedis.params.GetExParams;
import redis.clients.jedis.params.LCSParams;
import redis.clients.jedis.params.LPosParams;
import redis.clients.jedis.params.MigrateParams;
import redis.clients.jedis.params.RestoreParams;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.SortingParams;
import redis.clients.jedis.params.XAddParams;
import redis.clients.jedis.params.XAutoClaimParams;
import redis.clients.jedis.params.XClaimParams;
import redis.clients.jedis.params.XPendingParams;
import redis.clients.jedis.params.XReadGroupParams;
import redis.clients.jedis.params.XReadParams;
import redis.clients.jedis.params.XTrimParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.params.ZParams;
import redis.clients.jedis.params.ZRangeParams;
import redis.clients.jedis.providers.ClusterConnectionProvider;
import redis.clients.jedis.providers.ConnectionProvider;
import redis.clients.jedis.providers.MultiClusterPooledConnectionProvider;
import redis.clients.jedis.providers.PooledConnectionProvider;
import redis.clients.jedis.providers.ShardedConnectionProvider;
import redis.clients.jedis.resps.FunctionStats;
import redis.clients.jedis.resps.GeoRadiusResponse;
import redis.clients.jedis.resps.LCSMatchResult;
import redis.clients.jedis.resps.LibraryInfo;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.resps.StreamConsumerInfo;
import redis.clients.jedis.resps.StreamConsumersInfo;
import redis.clients.jedis.resps.StreamEntry;
import redis.clients.jedis.resps.StreamFullInfo;
import redis.clients.jedis.resps.StreamGroupInfo;
import redis.clients.jedis.resps.StreamInfo;
import redis.clients.jedis.resps.StreamPendingEntry;
import redis.clients.jedis.resps.StreamPendingSummary;
import redis.clients.jedis.resps.Tuple;
import redis.clients.jedis.search.FTCreateParams;
import redis.clients.jedis.search.FTProfileParams;
import redis.clients.jedis.search.FTSearchParams;
import redis.clients.jedis.search.FTSpellCheckParams;
import redis.clients.jedis.search.FtSearchIteration;
import redis.clients.jedis.search.IndexOptions;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.Schema;
import redis.clients.jedis.search.SearchProtocol;
import redis.clients.jedis.search.SearchResult;
import redis.clients.jedis.search.aggr.AggregationBuilder;
import redis.clients.jedis.search.aggr.AggregationResult;
import redis.clients.jedis.search.aggr.FtAggregateIteration;
import redis.clients.jedis.search.schemafields.SchemaField;
import redis.clients.jedis.timeseries.AggregationType;
import redis.clients.jedis.timeseries.TSAddParams;
import redis.clients.jedis.timeseries.TSAlterParams;
import redis.clients.jedis.timeseries.TSCreateParams;
import redis.clients.jedis.timeseries.TSDecrByParams;
import redis.clients.jedis.timeseries.TSElement;
import redis.clients.jedis.timeseries.TSGetParams;
import redis.clients.jedis.timeseries.TSIncrByParams;
import redis.clients.jedis.timeseries.TSInfo;
import redis.clients.jedis.timeseries.TSMGetElement;
import redis.clients.jedis.timeseries.TSMGetParams;
import redis.clients.jedis.timeseries.TSMRangeElements;
import redis.clients.jedis.timeseries.TSMRangeParams;
import redis.clients.jedis.timeseries.TSRangeParams;
import redis.clients.jedis.util.IOUtils;
import redis.clients.jedis.util.JedisURIHelper;
import redis.clients.jedis.util.KeyValue;

public class UnifiedJedis
implements JedisCommands,
JedisBinaryCommands,
SampleKeyedCommands,
SampleBinaryKeyedCommands,
RedisModuleCommands,
AutoCloseable {
    @Deprecated
    protected RedisProtocol protocol = null;
    protected final ConnectionProvider provider;
    protected final CommandExecutor executor;
    protected final CommandObjects commandObjects;
    private final GraphCommandObjects graphCommandObjects;
    private JedisBroadcastAndRoundRobinConfig broadcastAndRoundRobinConfig = null;
    private final Cache cache;

    public UnifiedJedis() {
        this(new HostAndPort("127.0.0.1", 6379));
    }

    public UnifiedJedis(HostAndPort hostAndPort) {
        this(new PooledConnectionProvider(hostAndPort), (RedisProtocol)null);
    }

    public UnifiedJedis(String url2) {
        this(URI.create(url2));
    }

    public UnifiedJedis(URI uri2) {
        this(JedisURIHelper.getHostAndPort(uri2), (JedisClientConfig)DefaultJedisClientConfig.builder().user(JedisURIHelper.getUser(uri2)).password(JedisURIHelper.getPassword(uri2)).database(JedisURIHelper.getDBIndex(uri2)).protocol(JedisURIHelper.getRedisProtocol(uri2)).ssl(JedisURIHelper.isRedisSSLScheme(uri2)).build());
    }

    public UnifiedJedis(URI uri2, JedisClientConfig config2) {
        this(JedisURIHelper.getHostAndPort(uri2), (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(config2.getConnectionTimeoutMillis()).socketTimeoutMillis(config2.getSocketTimeoutMillis()).blockingSocketTimeoutMillis(config2.getBlockingSocketTimeoutMillis()).user(JedisURIHelper.getUser(uri2)).password(JedisURIHelper.getPassword(uri2)).database(JedisURIHelper.getDBIndex(uri2)).clientName(config2.getClientName()).protocol(JedisURIHelper.getRedisProtocol(uri2)).ssl(JedisURIHelper.isRedisSSLScheme(uri2)).sslSocketFactory(config2.getSslSocketFactory()).sslParameters(config2.getSslParameters()).hostnameVerifier(config2.getHostnameVerifier()).build());
    }

    public UnifiedJedis(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(new PooledConnectionProvider(hostAndPort, clientConfig), clientConfig.getRedisProtocol());
    }

    @Experimental
    public UnifiedJedis(HostAndPort hostAndPort, JedisClientConfig clientConfig, CacheConfig cacheConfig) {
        this(hostAndPort, clientConfig, CacheFactory.getCache(cacheConfig));
    }

    @Experimental
    public UnifiedJedis(HostAndPort hostAndPort, JedisClientConfig clientConfig, Cache cache2) {
        this((ConnectionProvider)new PooledConnectionProvider(hostAndPort, clientConfig, cache2), clientConfig.getRedisProtocol(), cache2);
    }

    public UnifiedJedis(ConnectionProvider provider2) {
        this(new DefaultCommandExecutor(provider2), provider2);
    }

    protected UnifiedJedis(ConnectionProvider provider2, RedisProtocol protocol) {
        this(new DefaultCommandExecutor(provider2), provider2, new CommandObjects(), protocol);
    }

    @Experimental
    protected UnifiedJedis(ConnectionProvider provider2, RedisProtocol protocol, Cache cache2) {
        this(new DefaultCommandExecutor(provider2), provider2, new CommandObjects(), protocol, cache2);
    }

    public UnifiedJedis(JedisSocketFactory socketFactory) {
        this(new Connection(socketFactory));
    }

    public UnifiedJedis(JedisSocketFactory socketFactory, JedisClientConfig clientConfig) {
        this(new Connection(socketFactory, clientConfig));
    }

    public UnifiedJedis(Connection connection) {
        this.provider = null;
        this.executor = new SimpleCommandExecutor(connection);
        this.commandObjects = new CommandObjects();
        RedisProtocol proto = connection.getRedisProtocol();
        if (proto != null) {
            this.commandObjects.setProtocol(proto);
        }
        this.graphCommandObjects = new GraphCommandObjects(this);
        this.cache = connection instanceof CacheConnection ? ((CacheConnection)connection).getCache() : null;
    }

    @Deprecated
    public UnifiedJedis(Set<HostAndPort> jedisClusterNodes, JedisClientConfig clientConfig, int maxAttempts) {
        this(jedisClusterNodes, clientConfig, maxAttempts, Duration.ofMillis(maxAttempts * clientConfig.getSocketTimeoutMillis()));
    }

    @Deprecated
    public UnifiedJedis(Set<HostAndPort> jedisClusterNodes, JedisClientConfig clientConfig, int maxAttempts, Duration maxTotalRetriesDuration) {
        this(new ClusterConnectionProvider(jedisClusterNodes, clientConfig), maxAttempts, maxTotalRetriesDuration, clientConfig.getRedisProtocol());
    }

    @Deprecated
    public UnifiedJedis(Set<HostAndPort> jedisClusterNodes, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig, int maxAttempts, Duration maxTotalRetriesDuration) {
        this(new ClusterConnectionProvider(jedisClusterNodes, clientConfig, poolConfig), maxAttempts, maxTotalRetriesDuration, clientConfig.getRedisProtocol());
    }

    public UnifiedJedis(ClusterConnectionProvider provider2, int maxAttempts, Duration maxTotalRetriesDuration) {
        this(new ClusterCommandExecutor(provider2, maxAttempts, maxTotalRetriesDuration), provider2, new ClusterCommandObjects());
    }

    protected UnifiedJedis(ClusterConnectionProvider provider2, int maxAttempts, Duration maxTotalRetriesDuration, RedisProtocol protocol) {
        this(new ClusterCommandExecutor(provider2, maxAttempts, maxTotalRetriesDuration), provider2, new ClusterCommandObjects(), protocol);
    }

    @Experimental
    protected UnifiedJedis(ClusterConnectionProvider provider2, int maxAttempts, Duration maxTotalRetriesDuration, RedisProtocol protocol, Cache cache2) {
        this(new ClusterCommandExecutor(provider2, maxAttempts, maxTotalRetriesDuration), provider2, new ClusterCommandObjects(), protocol, cache2);
    }

    @Deprecated
    public UnifiedJedis(ShardedConnectionProvider provider2) {
        this(new DefaultCommandExecutor(provider2), provider2, new ShardedCommandObjects(provider2.getHashingAlgo()));
    }

    @Deprecated
    public UnifiedJedis(ShardedConnectionProvider provider2, Pattern tagPattern) {
        this(new DefaultCommandExecutor(provider2), provider2, new ShardedCommandObjects(provider2.getHashingAlgo(), tagPattern));
    }

    public UnifiedJedis(ConnectionProvider provider2, int maxAttempts, Duration maxTotalRetriesDuration) {
        this(new RetryableCommandExecutor(provider2, maxAttempts, maxTotalRetriesDuration), provider2);
    }

    @Experimental
    public UnifiedJedis(MultiClusterPooledConnectionProvider provider2) {
        this(new CircuitBreakerCommandExecutor(provider2), provider2);
    }

    public UnifiedJedis(CommandExecutor executor) {
        this(executor, (ConnectionProvider)null);
    }

    private UnifiedJedis(CommandExecutor executor, ConnectionProvider provider2) {
        this(executor, provider2, new CommandObjects());
    }

    @VisibleForTesting
    public UnifiedJedis(CommandExecutor executor, ConnectionProvider provider2, CommandObjects commandObjects) {
        this(executor, provider2, commandObjects, null, null);
        if (this.provider != null) {
            try (Connection conn = this.provider.getConnection();){
                RedisProtocol proto;
                if (conn != null && (proto = conn.getRedisProtocol()) != null) {
                    this.commandObjects.setProtocol(proto);
                }
            }
            catch (JedisException jedisException) {
                // empty catch block
            }
        }
    }

    @Experimental
    private UnifiedJedis(CommandExecutor executor, ConnectionProvider provider2, CommandObjects commandObjects, RedisProtocol protocol) {
        this(executor, provider2, commandObjects, protocol, (Cache)null);
    }

    @Experimental
    private UnifiedJedis(CommandExecutor executor, ConnectionProvider provider2, CommandObjects commandObjects, RedisProtocol protocol, Cache cache2) {
        if (cache2 != null && protocol != RedisProtocol.RESP3) {
            throw new IllegalArgumentException("Client-side caching is only supported with RESP3.");
        }
        this.provider = provider2;
        this.executor = executor;
        this.commandObjects = commandObjects;
        if (protocol != null) {
            this.commandObjects.setProtocol(protocol);
        }
        this.graphCommandObjects = new GraphCommandObjects(this);
        this.graphCommandObjects.setBaseCommandArgumentsCreator(comm -> this.commandObjects.commandArguments((ProtocolCommand)comm));
        this.cache = cache2;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.executor);
    }

    @Deprecated
    protected final void setProtocol(RedisProtocol protocol) {
        this.protocol = protocol;
        this.commandObjects.setProtocol(this.protocol);
    }

    public final <T> T executeCommand(CommandObject<T> commandObject) {
        return this.executor.executeCommand(commandObject);
    }

    public final <T> T broadcastCommand(CommandObject<T> commandObject) {
        return this.executor.broadcastCommand(commandObject);
    }

    private <T> T checkAndBroadcastCommand(CommandObject<T> commandObject) {
        boolean broadcast2 = true;
        if (this.broadcastAndRoundRobinConfig != null && commandObject.getArguments().getCommand() instanceof SearchProtocol.SearchCommand && this.broadcastAndRoundRobinConfig.getRediSearchModeInCluster() == JedisBroadcastAndRoundRobinConfig.RediSearchMode.LIGHT) {
            broadcast2 = false;
        }
        return broadcast2 ? this.broadcastCommand(commandObject) : this.executeCommand(commandObject);
    }

    public void setBroadcastAndRoundRobinConfig(JedisBroadcastAndRoundRobinConfig config2) {
        this.broadcastAndRoundRobinConfig = config2;
        this.commandObjects.setBroadcastAndRoundRobinConfig(this.broadcastAndRoundRobinConfig);
    }

    public Cache getCache() {
        return this.cache;
    }

    public String ping() {
        return this.checkAndBroadcastCommand(this.commandObjects.ping());
    }

    public String flushDB() {
        return this.checkAndBroadcastCommand(this.commandObjects.flushDB());
    }

    public String flushAll() {
        return this.checkAndBroadcastCommand(this.commandObjects.flushAll());
    }

    public String configSet(String parameter, String value2) {
        return this.checkAndBroadcastCommand(this.commandObjects.configSet(parameter, value2));
    }

    @Override
    public boolean exists(String key2) {
        return this.executeCommand(this.commandObjects.exists(key2));
    }

    @Override
    public long exists(String ... keys2) {
        return this.executeCommand(this.commandObjects.exists(keys2));
    }

    @Override
    public long persist(String key2) {
        return this.executeCommand(this.commandObjects.persist(key2));
    }

    @Override
    public String type(String key2) {
        return this.executeCommand(this.commandObjects.type(key2));
    }

    @Override
    public boolean exists(byte[] key2) {
        return this.executeCommand(this.commandObjects.exists(key2));
    }

    @Override
    public long exists(byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.exists(keys2));
    }

    @Override
    public long persist(byte[] key2) {
        return this.executeCommand(this.commandObjects.persist(key2));
    }

    @Override
    public String type(byte[] key2) {
        return this.executeCommand(this.commandObjects.type(key2));
    }

    @Override
    public byte[] dump(String key2) {
        return this.executeCommand(this.commandObjects.dump(key2));
    }

    @Override
    public String restore(String key2, long ttl, byte[] serializedValue) {
        return this.executeCommand(this.commandObjects.restore(key2, ttl, serializedValue));
    }

    @Override
    public String restore(String key2, long ttl, byte[] serializedValue, RestoreParams params) {
        return this.executeCommand(this.commandObjects.restore(key2, ttl, serializedValue, params));
    }

    @Override
    public byte[] dump(byte[] key2) {
        return this.executeCommand(this.commandObjects.dump(key2));
    }

    @Override
    public String restore(byte[] key2, long ttl, byte[] serializedValue) {
        return this.executeCommand(this.commandObjects.restore(key2, ttl, serializedValue));
    }

    @Override
    public String restore(byte[] key2, long ttl, byte[] serializedValue, RestoreParams params) {
        return this.executeCommand(this.commandObjects.restore(key2, ttl, serializedValue, params));
    }

    @Override
    public long expire(String key2, long seconds) {
        return this.executeCommand(this.commandObjects.expire(key2, seconds));
    }

    @Override
    public long expire(String key2, long seconds, ExpiryOption expiryOption) {
        return this.executeCommand(this.commandObjects.expire(key2, seconds, expiryOption));
    }

    @Override
    public long pexpire(String key2, long milliseconds) {
        return this.executeCommand(this.commandObjects.pexpire(key2, milliseconds));
    }

    @Override
    public long pexpire(String key2, long milliseconds, ExpiryOption expiryOption) {
        return this.executeCommand(this.commandObjects.pexpire(key2, milliseconds, expiryOption));
    }

    @Override
    public long expireTime(String key2) {
        return this.executeCommand(this.commandObjects.expireTime(key2));
    }

    @Override
    public long pexpireTime(String key2) {
        return this.executeCommand(this.commandObjects.pexpireTime(key2));
    }

    @Override
    public long expireAt(String key2, long unixTime) {
        return this.executeCommand(this.commandObjects.expireAt(key2, unixTime));
    }

    @Override
    public long expireAt(String key2, long unixTime, ExpiryOption expiryOption) {
        return this.executeCommand(this.commandObjects.expireAt(key2, unixTime, expiryOption));
    }

    @Override
    public long pexpireAt(String key2, long millisecondsTimestamp) {
        return this.executeCommand(this.commandObjects.pexpireAt(key2, millisecondsTimestamp));
    }

    @Override
    public long pexpireAt(String key2, long millisecondsTimestamp, ExpiryOption expiryOption) {
        return this.executeCommand(this.commandObjects.pexpireAt(key2, millisecondsTimestamp, expiryOption));
    }

    @Override
    public long expire(byte[] key2, long seconds) {
        return this.executeCommand(this.commandObjects.expire(key2, seconds));
    }

    @Override
    public long expire(byte[] key2, long seconds, ExpiryOption expiryOption) {
        return this.executeCommand(this.commandObjects.expire(key2, seconds, expiryOption));
    }

    @Override
    public long pexpire(byte[] key2, long milliseconds) {
        return this.executeCommand(this.commandObjects.pexpire(key2, milliseconds));
    }

    @Override
    public long pexpire(byte[] key2, long milliseconds, ExpiryOption expiryOption) {
        return this.executeCommand(this.commandObjects.pexpire(key2, milliseconds, expiryOption));
    }

    @Override
    public long expireTime(byte[] key2) {
        return this.executeCommand(this.commandObjects.expireTime(key2));
    }

    @Override
    public long pexpireTime(byte[] key2) {
        return this.executeCommand(this.commandObjects.pexpireTime(key2));
    }

    @Override
    public long expireAt(byte[] key2, long unixTime) {
        return this.executeCommand(this.commandObjects.expireAt(key2, unixTime));
    }

    @Override
    public long expireAt(byte[] key2, long unixTime, ExpiryOption expiryOption) {
        return this.executeCommand(this.commandObjects.expireAt(key2, unixTime, expiryOption));
    }

    @Override
    public long pexpireAt(byte[] key2, long millisecondsTimestamp) {
        return this.executeCommand(this.commandObjects.pexpireAt(key2, millisecondsTimestamp));
    }

    @Override
    public long pexpireAt(byte[] key2, long millisecondsTimestamp, ExpiryOption expiryOption) {
        return this.executeCommand(this.commandObjects.pexpireAt(key2, millisecondsTimestamp, expiryOption));
    }

    @Override
    public long ttl(String key2) {
        return this.executeCommand(this.commandObjects.ttl(key2));
    }

    @Override
    public long pttl(String key2) {
        return this.executeCommand(this.commandObjects.pttl(key2));
    }

    @Override
    public long touch(String key2) {
        return this.executeCommand(this.commandObjects.touch(key2));
    }

    @Override
    public long touch(String ... keys2) {
        return this.executeCommand(this.commandObjects.touch(keys2));
    }

    @Override
    public long ttl(byte[] key2) {
        return this.executeCommand(this.commandObjects.ttl(key2));
    }

    @Override
    public long pttl(byte[] key2) {
        return this.executeCommand(this.commandObjects.pttl(key2));
    }

    @Override
    public long touch(byte[] key2) {
        return this.executeCommand(this.commandObjects.touch(key2));
    }

    @Override
    public long touch(byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.touch(keys2));
    }

    @Override
    public List<String> sort(String key2) {
        return this.executeCommand(this.commandObjects.sort(key2));
    }

    @Override
    public List<String> sort(String key2, SortingParams sortingParams) {
        return this.executeCommand(this.commandObjects.sort(key2, sortingParams));
    }

    @Override
    public long sort(String key2, String dstkey) {
        return this.executeCommand(this.commandObjects.sort(key2, dstkey));
    }

    @Override
    public long sort(String key2, SortingParams sortingParams, String dstkey) {
        return this.executeCommand(this.commandObjects.sort(key2, sortingParams, dstkey));
    }

    @Override
    public List<String> sortReadonly(String key2, SortingParams sortingParams) {
        return this.executeCommand(this.commandObjects.sortReadonly(key2, sortingParams));
    }

    @Override
    public List<byte[]> sort(byte[] key2) {
        return this.executeCommand(this.commandObjects.sort(key2));
    }

    @Override
    public List<byte[]> sort(byte[] key2, SortingParams sortingParams) {
        return this.executeCommand(this.commandObjects.sort(key2, sortingParams));
    }

    @Override
    public long sort(byte[] key2, byte[] dstkey) {
        return this.executeCommand(this.commandObjects.sort(key2, dstkey));
    }

    @Override
    public List<byte[]> sortReadonly(byte[] key2, SortingParams sortingParams) {
        return this.executeCommand(this.commandObjects.sortReadonly(key2, sortingParams));
    }

    @Override
    public long sort(byte[] key2, SortingParams sortingParams, byte[] dstkey) {
        return this.executeCommand(this.commandObjects.sort(key2, sortingParams, dstkey));
    }

    @Override
    public long del(String key2) {
        return this.executeCommand(this.commandObjects.del(key2));
    }

    @Override
    public long del(String ... keys2) {
        return this.executeCommand(this.commandObjects.del(keys2));
    }

    @Override
    public long unlink(String key2) {
        return this.executeCommand(this.commandObjects.unlink(key2));
    }

    @Override
    public long unlink(String ... keys2) {
        return this.executeCommand(this.commandObjects.unlink(keys2));
    }

    @Override
    public long del(byte[] key2) {
        return this.executeCommand(this.commandObjects.del(key2));
    }

    @Override
    public long del(byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.del(keys2));
    }

    @Override
    public long unlink(byte[] key2) {
        return this.executeCommand(this.commandObjects.unlink(key2));
    }

    @Override
    public long unlink(byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.unlink(keys2));
    }

    @Override
    public Long memoryUsage(String key2) {
        return this.executeCommand(this.commandObjects.memoryUsage(key2));
    }

    @Override
    public Long memoryUsage(String key2, int samples) {
        return this.executeCommand(this.commandObjects.memoryUsage(key2, samples));
    }

    @Override
    public Long memoryUsage(byte[] key2) {
        return this.executeCommand(this.commandObjects.memoryUsage(key2));
    }

    @Override
    public Long memoryUsage(byte[] key2, int samples) {
        return this.executeCommand(this.commandObjects.memoryUsage(key2, samples));
    }

    @Override
    public boolean copy(String srcKey, String dstKey, boolean replace) {
        return this.executeCommand(this.commandObjects.copy(srcKey, dstKey, replace));
    }

    @Override
    public String rename(String oldkey, String newkey) {
        return this.executeCommand(this.commandObjects.rename(oldkey, newkey));
    }

    @Override
    public long renamenx(String oldkey, String newkey) {
        return this.executeCommand(this.commandObjects.renamenx(oldkey, newkey));
    }

    @Override
    public boolean copy(byte[] srcKey, byte[] dstKey, boolean replace) {
        return this.executeCommand(this.commandObjects.copy(srcKey, dstKey, replace));
    }

    @Override
    public String rename(byte[] oldkey, byte[] newkey) {
        return this.executeCommand(this.commandObjects.rename(oldkey, newkey));
    }

    @Override
    public long renamenx(byte[] oldkey, byte[] newkey) {
        return this.executeCommand(this.commandObjects.renamenx(oldkey, newkey));
    }

    public long dbSize() {
        return this.executeCommand(this.commandObjects.dbSize());
    }

    @Override
    public Set<String> keys(String pattern2) {
        return this.executeCommand(this.commandObjects.keys(pattern2));
    }

    @Override
    public ScanResult<String> scan(String cursor) {
        return this.executeCommand(this.commandObjects.scan(cursor));
    }

    @Override
    public ScanResult<String> scan(String cursor, ScanParams params) {
        return this.executeCommand(this.commandObjects.scan(cursor, params));
    }

    @Override
    public ScanResult<String> scan(String cursor, ScanParams params, String type2) {
        return this.executeCommand(this.commandObjects.scan(cursor, params, type2));
    }

    public ScanIteration scanIteration(int batchCount, String match2) {
        return new ScanIteration(this.provider, batchCount, match2);
    }

    public ScanIteration scanIteration(int batchCount, String match2, String type2) {
        return new ScanIteration(this.provider, batchCount, match2, type2);
    }

    @Override
    public Set<byte[]> keys(byte[] pattern2) {
        return this.executeCommand(this.commandObjects.keys(pattern2));
    }

    @Override
    public ScanResult<byte[]> scan(byte[] cursor) {
        return this.executeCommand(this.commandObjects.scan(cursor));
    }

    @Override
    public ScanResult<byte[]> scan(byte[] cursor, ScanParams params) {
        return this.executeCommand(this.commandObjects.scan(cursor, params));
    }

    @Override
    public ScanResult<byte[]> scan(byte[] cursor, ScanParams params, byte[] type2) {
        return this.executeCommand(this.commandObjects.scan(cursor, params, type2));
    }

    @Override
    public String randomKey() {
        return this.executeCommand(this.commandObjects.randomKey());
    }

    @Override
    public byte[] randomBinaryKey() {
        return this.executeCommand(this.commandObjects.randomBinaryKey());
    }

    @Override
    public String set(String key2, String value2) {
        return this.executeCommand(this.commandObjects.set(key2, value2));
    }

    @Override
    public String set(String key2, String value2, SetParams params) {
        return this.executeCommand(this.commandObjects.set(key2, value2, params));
    }

    @Override
    public String get(String key2) {
        return this.executeCommand(this.commandObjects.get(key2));
    }

    @Override
    public String setGet(String key2, String value2) {
        return this.executeCommand(this.commandObjects.setGet(key2, value2));
    }

    @Override
    public String setGet(String key2, String value2, SetParams params) {
        return this.executeCommand(this.commandObjects.setGet(key2, value2, params));
    }

    @Override
    public String getDel(String key2) {
        return this.executeCommand(this.commandObjects.getDel(key2));
    }

    @Override
    public String getEx(String key2, GetExParams params) {
        return this.executeCommand(this.commandObjects.getEx(key2, params));
    }

    @Override
    public String set(byte[] key2, byte[] value2) {
        return this.executeCommand(this.commandObjects.set(key2, value2));
    }

    @Override
    public String set(byte[] key2, byte[] value2, SetParams params) {
        return this.executeCommand(this.commandObjects.set(key2, value2, params));
    }

    @Override
    public byte[] get(byte[] key2) {
        return this.executeCommand(this.commandObjects.get(key2));
    }

    @Override
    public byte[] setGet(byte[] key2, byte[] value2) {
        return this.executeCommand(this.commandObjects.setGet(key2, value2));
    }

    @Override
    public byte[] setGet(byte[] key2, byte[] value2, SetParams params) {
        return this.executeCommand(this.commandObjects.setGet(key2, value2, params));
    }

    @Override
    public byte[] getDel(byte[] key2) {
        return this.executeCommand(this.commandObjects.getDel(key2));
    }

    @Override
    public byte[] getEx(byte[] key2, GetExParams params) {
        return this.executeCommand(this.commandObjects.getEx(key2, params));
    }

    @Override
    public boolean setbit(String key2, long offset, boolean value2) {
        return this.executeCommand(this.commandObjects.setbit(key2, offset, value2));
    }

    @Override
    public boolean getbit(String key2, long offset) {
        return this.executeCommand(this.commandObjects.getbit(key2, offset));
    }

    @Override
    public long setrange(String key2, long offset, String value2) {
        return this.executeCommand(this.commandObjects.setrange(key2, offset, value2));
    }

    @Override
    public String getrange(String key2, long startOffset, long endOffset) {
        return this.executeCommand(this.commandObjects.getrange(key2, startOffset, endOffset));
    }

    @Override
    public boolean setbit(byte[] key2, long offset, boolean value2) {
        return this.executeCommand(this.commandObjects.setbit(key2, offset, value2));
    }

    @Override
    public boolean getbit(byte[] key2, long offset) {
        return this.executeCommand(this.commandObjects.getbit(key2, offset));
    }

    @Override
    public long setrange(byte[] key2, long offset, byte[] value2) {
        return this.executeCommand(this.commandObjects.setrange(key2, offset, value2));
    }

    @Override
    public byte[] getrange(byte[] key2, long startOffset, long endOffset) {
        return this.executeCommand(this.commandObjects.getrange(key2, startOffset, endOffset));
    }

    @Override
    @Deprecated
    public String getSet(String key2, String value2) {
        return this.executeCommand(this.commandObjects.getSet(key2, value2));
    }

    @Override
    public long setnx(String key2, String value2) {
        return this.executeCommand(this.commandObjects.setnx(key2, value2));
    }

    @Override
    public String setex(String key2, long seconds, String value2) {
        return this.executeCommand(this.commandObjects.setex(key2, seconds, value2));
    }

    @Override
    public String psetex(String key2, long milliseconds, String value2) {
        return this.executeCommand(this.commandObjects.psetex(key2, milliseconds, value2));
    }

    @Override
    @Deprecated
    public byte[] getSet(byte[] key2, byte[] value2) {
        return this.executeCommand(this.commandObjects.getSet(key2, value2));
    }

    @Override
    public long setnx(byte[] key2, byte[] value2) {
        return this.executeCommand(this.commandObjects.setnx(key2, value2));
    }

    @Override
    public String setex(byte[] key2, long seconds, byte[] value2) {
        return this.executeCommand(this.commandObjects.setex(key2, seconds, value2));
    }

    @Override
    public String psetex(byte[] key2, long milliseconds, byte[] value2) {
        return this.executeCommand(this.commandObjects.psetex(key2, milliseconds, value2));
    }

    @Override
    public long incr(String key2) {
        return this.executeCommand(this.commandObjects.incr(key2));
    }

    @Override
    public long incrBy(String key2, long increment) {
        return this.executeCommand(this.commandObjects.incrBy(key2, increment));
    }

    @Override
    public double incrByFloat(String key2, double increment) {
        return this.executeCommand(this.commandObjects.incrByFloat(key2, increment));
    }

    @Override
    public long decr(String key2) {
        return this.executeCommand(this.commandObjects.decr(key2));
    }

    @Override
    public long decrBy(String key2, long decrement) {
        return this.executeCommand(this.commandObjects.decrBy(key2, decrement));
    }

    @Override
    public long incr(byte[] key2) {
        return this.executeCommand(this.commandObjects.incr(key2));
    }

    @Override
    public long incrBy(byte[] key2, long increment) {
        return this.executeCommand(this.commandObjects.incrBy(key2, increment));
    }

    @Override
    public double incrByFloat(byte[] key2, double increment) {
        return this.executeCommand(this.commandObjects.incrByFloat(key2, increment));
    }

    @Override
    public long decr(byte[] key2) {
        return this.executeCommand(this.commandObjects.decr(key2));
    }

    @Override
    public long decrBy(byte[] key2, long decrement) {
        return this.executeCommand(this.commandObjects.decrBy(key2, decrement));
    }

    @Override
    public List<String> mget(String ... keys2) {
        return this.executeCommand(this.commandObjects.mget(keys2));
    }

    @Override
    public String mset(String ... keysvalues) {
        return this.executeCommand(this.commandObjects.mset(keysvalues));
    }

    @Override
    public long msetnx(String ... keysvalues) {
        return this.executeCommand(this.commandObjects.msetnx(keysvalues));
    }

    @Override
    public List<byte[]> mget(byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.mget(keys2));
    }

    @Override
    public String mset(byte[] ... keysvalues) {
        return this.executeCommand(this.commandObjects.mset(keysvalues));
    }

    @Override
    public long msetnx(byte[] ... keysvalues) {
        return this.executeCommand(this.commandObjects.msetnx(keysvalues));
    }

    @Override
    public long append(String key2, String value2) {
        return this.executeCommand(this.commandObjects.append(key2, value2));
    }

    @Override
    public String substr(String key2, int start2, int end2) {
        return this.executeCommand(this.commandObjects.substr(key2, start2, end2));
    }

    @Override
    public long strlen(String key2) {
        return this.executeCommand(this.commandObjects.strlen(key2));
    }

    @Override
    public long append(byte[] key2, byte[] value2) {
        return this.executeCommand(this.commandObjects.append(key2, value2));
    }

    @Override
    public byte[] substr(byte[] key2, int start2, int end2) {
        return this.executeCommand(this.commandObjects.substr(key2, start2, end2));
    }

    @Override
    public long strlen(byte[] key2) {
        return this.executeCommand(this.commandObjects.strlen(key2));
    }

    @Override
    public long bitcount(String key2) {
        return this.executeCommand(this.commandObjects.bitcount(key2));
    }

    @Override
    public long bitcount(String key2, long start2, long end2) {
        return this.executeCommand(this.commandObjects.bitcount(key2, start2, end2));
    }

    @Override
    public long bitcount(String key2, long start2, long end2, BitCountOption option) {
        return this.executeCommand(this.commandObjects.bitcount(key2, start2, end2, option));
    }

    @Override
    public long bitpos(String key2, boolean value2) {
        return this.executeCommand(this.commandObjects.bitpos(key2, value2));
    }

    @Override
    public long bitpos(String key2, boolean value2, BitPosParams params) {
        return this.executeCommand(this.commandObjects.bitpos(key2, value2, params));
    }

    @Override
    public long bitcount(byte[] key2) {
        return this.executeCommand(this.commandObjects.bitcount(key2));
    }

    @Override
    public long bitcount(byte[] key2, long start2, long end2) {
        return this.executeCommand(this.commandObjects.bitcount(key2, start2, end2));
    }

    @Override
    public long bitcount(byte[] key2, long start2, long end2, BitCountOption option) {
        return this.executeCommand(this.commandObjects.bitcount(key2, start2, end2, option));
    }

    @Override
    public long bitpos(byte[] key2, boolean value2) {
        return this.executeCommand(this.commandObjects.bitpos(key2, value2));
    }

    @Override
    public long bitpos(byte[] key2, boolean value2, BitPosParams params) {
        return this.executeCommand(this.commandObjects.bitpos(key2, value2, params));
    }

    @Override
    public List<Long> bitfield(String key2, String ... arguments) {
        return this.executeCommand(this.commandObjects.bitfield(key2, arguments));
    }

    @Override
    public List<Long> bitfieldReadonly(String key2, String ... arguments) {
        return this.executeCommand(this.commandObjects.bitfieldReadonly(key2, arguments));
    }

    @Override
    public List<Long> bitfield(byte[] key2, byte[] ... arguments) {
        return this.executeCommand(this.commandObjects.bitfield(key2, arguments));
    }

    @Override
    public List<Long> bitfieldReadonly(byte[] key2, byte[] ... arguments) {
        return this.executeCommand(this.commandObjects.bitfieldReadonly(key2, arguments));
    }

    @Override
    public long bitop(BitOP op, String destKey, String ... srcKeys) {
        return this.executeCommand(this.commandObjects.bitop(op, destKey, srcKeys));
    }

    @Override
    public long bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        return this.executeCommand(this.commandObjects.bitop(op, destKey, srcKeys));
    }

    @Override
    public LCSMatchResult lcs(String keyA, String keyB, LCSParams params) {
        return this.executeCommand(this.commandObjects.lcs(keyA, keyB, params));
    }

    @Override
    public LCSMatchResult lcs(byte[] keyA, byte[] keyB, LCSParams params) {
        return this.executeCommand(this.commandObjects.lcs(keyA, keyB, params));
    }

    @Override
    public long rpush(String key2, String ... string) {
        return this.executeCommand(this.commandObjects.rpush(key2, string));
    }

    @Override
    public long lpush(String key2, String ... string) {
        return this.executeCommand(this.commandObjects.lpush(key2, string));
    }

    @Override
    public long llen(String key2) {
        return this.executeCommand(this.commandObjects.llen(key2));
    }

    @Override
    public List<String> lrange(String key2, long start2, long stop) {
        return this.executeCommand(this.commandObjects.lrange(key2, start2, stop));
    }

    @Override
    public String ltrim(String key2, long start2, long stop) {
        return this.executeCommand(this.commandObjects.ltrim(key2, start2, stop));
    }

    @Override
    public String lindex(String key2, long index) {
        return this.executeCommand(this.commandObjects.lindex(key2, index));
    }

    @Override
    public long rpush(byte[] key2, byte[] ... args2) {
        return this.executeCommand(this.commandObjects.rpush(key2, args2));
    }

    @Override
    public long lpush(byte[] key2, byte[] ... args2) {
        return this.executeCommand(this.commandObjects.lpush(key2, args2));
    }

    @Override
    public long llen(byte[] key2) {
        return this.executeCommand(this.commandObjects.llen(key2));
    }

    @Override
    public List<byte[]> lrange(byte[] key2, long start2, long stop) {
        return this.executeCommand(this.commandObjects.lrange(key2, start2, stop));
    }

    @Override
    public String ltrim(byte[] key2, long start2, long stop) {
        return this.executeCommand(this.commandObjects.ltrim(key2, start2, stop));
    }

    @Override
    public byte[] lindex(byte[] key2, long index) {
        return this.executeCommand(this.commandObjects.lindex(key2, index));
    }

    @Override
    public String lset(String key2, long index, String value2) {
        return this.executeCommand(this.commandObjects.lset(key2, index, value2));
    }

    @Override
    public long lrem(String key2, long count2, String value2) {
        return this.executeCommand(this.commandObjects.lrem(key2, count2, value2));
    }

    @Override
    public String lpop(String key2) {
        return this.executeCommand(this.commandObjects.lpop(key2));
    }

    @Override
    public List<String> lpop(String key2, int count2) {
        return this.executeCommand(this.commandObjects.lpop(key2, count2));
    }

    @Override
    public String lset(byte[] key2, long index, byte[] value2) {
        return this.executeCommand(this.commandObjects.lset(key2, index, value2));
    }

    @Override
    public long lrem(byte[] key2, long count2, byte[] value2) {
        return this.executeCommand(this.commandObjects.lrem(key2, count2, value2));
    }

    @Override
    public byte[] lpop(byte[] key2) {
        return this.executeCommand(this.commandObjects.lpop(key2));
    }

    @Override
    public List<byte[]> lpop(byte[] key2, int count2) {
        return this.executeCommand(this.commandObjects.lpop(key2, count2));
    }

    @Override
    public Long lpos(String key2, String element) {
        return this.executeCommand(this.commandObjects.lpos(key2, element));
    }

    @Override
    public Long lpos(String key2, String element, LPosParams params) {
        return this.executeCommand(this.commandObjects.lpos(key2, element, params));
    }

    @Override
    public List<Long> lpos(String key2, String element, LPosParams params, long count2) {
        return this.executeCommand(this.commandObjects.lpos(key2, element, params, count2));
    }

    @Override
    public Long lpos(byte[] key2, byte[] element) {
        return this.executeCommand(this.commandObjects.lpos(key2, element));
    }

    @Override
    public Long lpos(byte[] key2, byte[] element, LPosParams params) {
        return this.executeCommand(this.commandObjects.lpos(key2, element, params));
    }

    @Override
    public List<Long> lpos(byte[] key2, byte[] element, LPosParams params, long count2) {
        return this.executeCommand(this.commandObjects.lpos(key2, element, params, count2));
    }

    @Override
    public String rpop(String key2) {
        return this.executeCommand(this.commandObjects.rpop(key2));
    }

    @Override
    public List<String> rpop(String key2, int count2) {
        return this.executeCommand(this.commandObjects.rpop(key2, count2));
    }

    @Override
    public byte[] rpop(byte[] key2) {
        return this.executeCommand(this.commandObjects.rpop(key2));
    }

    @Override
    public List<byte[]> rpop(byte[] key2, int count2) {
        return this.executeCommand(this.commandObjects.rpop(key2, count2));
    }

    @Override
    public long linsert(String key2, ListPosition where, String pivot, String value2) {
        return this.executeCommand(this.commandObjects.linsert(key2, where, pivot, value2));
    }

    @Override
    public long lpushx(String key2, String ... strings) {
        return this.executeCommand(this.commandObjects.lpushx(key2, strings));
    }

    @Override
    public long rpushx(String key2, String ... strings) {
        return this.executeCommand(this.commandObjects.rpushx(key2, strings));
    }

    @Override
    public long linsert(byte[] key2, ListPosition where, byte[] pivot, byte[] value2) {
        return this.executeCommand(this.commandObjects.linsert(key2, where, pivot, value2));
    }

    @Override
    public long lpushx(byte[] key2, byte[] ... args2) {
        return this.executeCommand(this.commandObjects.lpushx(key2, args2));
    }

    @Override
    public long rpushx(byte[] key2, byte[] ... args2) {
        return this.executeCommand(this.commandObjects.rpushx(key2, args2));
    }

    @Override
    public List<String> blpop(int timeout2, String key2) {
        return this.executeCommand(this.commandObjects.blpop(timeout2, key2));
    }

    @Override
    public KeyValue<String, String> blpop(double timeout2, String key2) {
        return this.executeCommand(this.commandObjects.blpop(timeout2, key2));
    }

    @Override
    public List<String> brpop(int timeout2, String key2) {
        return this.executeCommand(this.commandObjects.brpop(timeout2, key2));
    }

    @Override
    public KeyValue<String, String> brpop(double timeout2, String key2) {
        return this.executeCommand(this.commandObjects.brpop(timeout2, key2));
    }

    @Override
    public List<String> blpop(int timeout2, String ... keys2) {
        return this.executeCommand(this.commandObjects.blpop(timeout2, keys2));
    }

    @Override
    public KeyValue<String, String> blpop(double timeout2, String ... keys2) {
        return this.executeCommand(this.commandObjects.blpop(timeout2, keys2));
    }

    @Override
    public List<String> brpop(int timeout2, String ... keys2) {
        return this.executeCommand(this.commandObjects.brpop(timeout2, keys2));
    }

    @Override
    public KeyValue<String, String> brpop(double timeout2, String ... keys2) {
        return this.executeCommand(this.commandObjects.brpop(timeout2, keys2));
    }

    @Override
    public List<byte[]> blpop(int timeout2, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.blpop(timeout2, keys2));
    }

    @Override
    public KeyValue<byte[], byte[]> blpop(double timeout2, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.blpop(timeout2, keys2));
    }

    @Override
    public List<byte[]> brpop(int timeout2, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.brpop(timeout2, keys2));
    }

    @Override
    public KeyValue<byte[], byte[]> brpop(double timeout2, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.brpop(timeout2, keys2));
    }

    @Override
    public String rpoplpush(String srckey, String dstkey) {
        return this.executeCommand(this.commandObjects.rpoplpush(srckey, dstkey));
    }

    @Override
    public String brpoplpush(String source2, String destination, int timeout2) {
        return this.executeCommand(this.commandObjects.brpoplpush(source2, destination, timeout2));
    }

    @Override
    public byte[] rpoplpush(byte[] srckey, byte[] dstkey) {
        return this.executeCommand(this.commandObjects.rpoplpush(srckey, dstkey));
    }

    @Override
    public byte[] brpoplpush(byte[] source2, byte[] destination, int timeout2) {
        return this.executeCommand(this.commandObjects.brpoplpush(source2, destination, timeout2));
    }

    @Override
    public String lmove(String srcKey, String dstKey, ListDirection from2, ListDirection to) {
        return this.executeCommand(this.commandObjects.lmove(srcKey, dstKey, from2, to));
    }

    @Override
    public String blmove(String srcKey, String dstKey, ListDirection from2, ListDirection to, double timeout2) {
        return this.executeCommand(this.commandObjects.blmove(srcKey, dstKey, from2, to, timeout2));
    }

    @Override
    public byte[] lmove(byte[] srcKey, byte[] dstKey, ListDirection from2, ListDirection to) {
        return this.executeCommand(this.commandObjects.lmove(srcKey, dstKey, from2, to));
    }

    @Override
    public byte[] blmove(byte[] srcKey, byte[] dstKey, ListDirection from2, ListDirection to, double timeout2) {
        return this.executeCommand(this.commandObjects.blmove(srcKey, dstKey, from2, to, timeout2));
    }

    @Override
    public KeyValue<String, List<String>> lmpop(ListDirection direction, String ... keys2) {
        return this.executeCommand(this.commandObjects.lmpop(direction, keys2));
    }

    @Override
    public KeyValue<String, List<String>> lmpop(ListDirection direction, int count2, String ... keys2) {
        return this.executeCommand(this.commandObjects.lmpop(direction, count2, keys2));
    }

    @Override
    public KeyValue<String, List<String>> blmpop(double timeout2, ListDirection direction, String ... keys2) {
        return this.executeCommand(this.commandObjects.blmpop(timeout2, direction, keys2));
    }

    @Override
    public KeyValue<String, List<String>> blmpop(double timeout2, ListDirection direction, int count2, String ... keys2) {
        return this.executeCommand(this.commandObjects.blmpop(timeout2, direction, count2, keys2));
    }

    @Override
    public KeyValue<byte[], List<byte[]>> lmpop(ListDirection direction, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.lmpop(direction, keys2));
    }

    @Override
    public KeyValue<byte[], List<byte[]>> lmpop(ListDirection direction, int count2, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.lmpop(direction, count2, keys2));
    }

    @Override
    public KeyValue<byte[], List<byte[]>> blmpop(double timeout2, ListDirection direction, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.blmpop(timeout2, direction, keys2));
    }

    @Override
    public KeyValue<byte[], List<byte[]>> blmpop(double timeout2, ListDirection direction, int count2, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.blmpop(timeout2, direction, count2, keys2));
    }

    @Override
    public long hset(String key2, String field, String value2) {
        return this.executeCommand(this.commandObjects.hset(key2, field, value2));
    }

    @Override
    public long hset(String key2, Map<String, String> hash) {
        return this.executeCommand(this.commandObjects.hset(key2, hash));
    }

    @Override
    public String hget(String key2, String field) {
        return this.executeCommand(this.commandObjects.hget(key2, field));
    }

    @Override
    public long hsetnx(String key2, String field, String value2) {
        return this.executeCommand(this.commandObjects.hsetnx(key2, field, value2));
    }

    @Override
    public String hmset(String key2, Map<String, String> hash) {
        return this.executeCommand(this.commandObjects.hmset(key2, hash));
    }

    @Override
    public List<String> hmget(String key2, String ... fields2) {
        return this.executeCommand(this.commandObjects.hmget(key2, fields2));
    }

    @Override
    public long hset(byte[] key2, byte[] field, byte[] value2) {
        return this.executeCommand(this.commandObjects.hset(key2, field, value2));
    }

    @Override
    public long hset(byte[] key2, Map<byte[], byte[]> hash) {
        return this.executeCommand(this.commandObjects.hset(key2, hash));
    }

    @Override
    public byte[] hget(byte[] key2, byte[] field) {
        return this.executeCommand(this.commandObjects.hget(key2, field));
    }

    @Override
    public long hsetnx(byte[] key2, byte[] field, byte[] value2) {
        return this.executeCommand(this.commandObjects.hsetnx(key2, field, value2));
    }

    @Override
    public String hmset(byte[] key2, Map<byte[], byte[]> hash) {
        return this.executeCommand(this.commandObjects.hmset(key2, hash));
    }

    @Override
    public List<byte[]> hmget(byte[] key2, byte[] ... fields2) {
        return this.executeCommand(this.commandObjects.hmget(key2, fields2));
    }

    @Override
    public long hincrBy(String key2, String field, long value2) {
        return this.executeCommand(this.commandObjects.hincrBy(key2, field, value2));
    }

    @Override
    public double hincrByFloat(String key2, String field, double value2) {
        return this.executeCommand(this.commandObjects.hincrByFloat(key2, field, value2));
    }

    @Override
    public boolean hexists(String key2, String field) {
        return this.executeCommand(this.commandObjects.hexists(key2, field));
    }

    @Override
    public long hdel(String key2, String ... field) {
        return this.executeCommand(this.commandObjects.hdel(key2, field));
    }

    @Override
    public long hlen(String key2) {
        return this.executeCommand(this.commandObjects.hlen(key2));
    }

    @Override
    public long hincrBy(byte[] key2, byte[] field, long value2) {
        return this.executeCommand(this.commandObjects.hincrBy(key2, field, value2));
    }

    @Override
    public double hincrByFloat(byte[] key2, byte[] field, double value2) {
        return this.executeCommand(this.commandObjects.hincrByFloat(key2, field, value2));
    }

    @Override
    public boolean hexists(byte[] key2, byte[] field) {
        return this.executeCommand(this.commandObjects.hexists(key2, field));
    }

    @Override
    public long hdel(byte[] key2, byte[] ... field) {
        return this.executeCommand(this.commandObjects.hdel(key2, field));
    }

    @Override
    public long hlen(byte[] key2) {
        return this.executeCommand(this.commandObjects.hlen(key2));
    }

    @Override
    public Set<String> hkeys(String key2) {
        return this.executeCommand(this.commandObjects.hkeys(key2));
    }

    @Override
    public List<String> hvals(String key2) {
        return this.executeCommand(this.commandObjects.hvals(key2));
    }

    @Override
    public Map<String, String> hgetAll(String key2) {
        return this.executeCommand(this.commandObjects.hgetAll(key2));
    }

    @Override
    public Set<byte[]> hkeys(byte[] key2) {
        return this.executeCommand(this.commandObjects.hkeys(key2));
    }

    @Override
    public List<byte[]> hvals(byte[] key2) {
        return this.executeCommand(this.commandObjects.hvals(key2));
    }

    @Override
    public Map<byte[], byte[]> hgetAll(byte[] key2) {
        return this.executeCommand(this.commandObjects.hgetAll(key2));
    }

    @Override
    public String hrandfield(String key2) {
        return this.executeCommand(this.commandObjects.hrandfield(key2));
    }

    @Override
    public List<String> hrandfield(String key2, long count2) {
        return this.executeCommand(this.commandObjects.hrandfield(key2, count2));
    }

    @Override
    public List<Map.Entry<String, String>> hrandfieldWithValues(String key2, long count2) {
        return this.executeCommand(this.commandObjects.hrandfieldWithValues(key2, count2));
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key2, String cursor, ScanParams params) {
        return this.executeCommand(this.commandObjects.hscan(key2, cursor, params));
    }

    @Override
    public ScanResult<String> hscanNoValues(String key2, String cursor, ScanParams params) {
        return this.executeCommand(this.commandObjects.hscanNoValues(key2, cursor, params));
    }

    @Override
    public long hstrlen(String key2, String field) {
        return this.executeCommand(this.commandObjects.hstrlen(key2, field));
    }

    @Override
    public byte[] hrandfield(byte[] key2) {
        return this.executeCommand(this.commandObjects.hrandfield(key2));
    }

    @Override
    public List<byte[]> hrandfield(byte[] key2, long count2) {
        return this.executeCommand(this.commandObjects.hrandfield(key2, count2));
    }

    @Override
    public List<Map.Entry<byte[], byte[]>> hrandfieldWithValues(byte[] key2, long count2) {
        return this.executeCommand(this.commandObjects.hrandfieldWithValues(key2, count2));
    }

    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key2, byte[] cursor, ScanParams params) {
        return this.executeCommand(this.commandObjects.hscan(key2, cursor, params));
    }

    @Override
    public ScanResult<byte[]> hscanNoValues(byte[] key2, byte[] cursor, ScanParams params) {
        return this.executeCommand(this.commandObjects.hscanNoValues(key2, cursor, params));
    }

    @Override
    public long hstrlen(byte[] key2, byte[] field) {
        return this.executeCommand(this.commandObjects.hstrlen(key2, field));
    }

    @Override
    public List<Long> hexpire(String key2, long seconds, String ... fields2) {
        return this.executeCommand(this.commandObjects.hexpire(key2, seconds, fields2));
    }

    @Override
    public List<Long> hexpire(String key2, long seconds, ExpiryOption condition, String ... fields2) {
        return this.executeCommand(this.commandObjects.hexpire(key2, seconds, condition, fields2));
    }

    @Override
    public List<Long> hpexpire(String key2, long milliseconds, String ... fields2) {
        return this.executeCommand(this.commandObjects.hpexpire(key2, milliseconds, fields2));
    }

    @Override
    public List<Long> hpexpire(String key2, long milliseconds, ExpiryOption condition, String ... fields2) {
        return this.executeCommand(this.commandObjects.hpexpire(key2, milliseconds, condition, fields2));
    }

    @Override
    public List<Long> hexpireAt(String key2, long unixTimeSeconds, String ... fields2) {
        return this.executeCommand(this.commandObjects.hexpireAt(key2, unixTimeSeconds, fields2));
    }

    @Override
    public List<Long> hexpireAt(String key2, long unixTimeSeconds, ExpiryOption condition, String ... fields2) {
        return this.executeCommand(this.commandObjects.hexpireAt(key2, unixTimeSeconds, condition, fields2));
    }

    @Override
    public List<Long> hpexpireAt(String key2, long unixTimeMillis, String ... fields2) {
        return this.executeCommand(this.commandObjects.hpexpireAt(key2, unixTimeMillis, fields2));
    }

    @Override
    public List<Long> hpexpireAt(String key2, long unixTimeMillis, ExpiryOption condition, String ... fields2) {
        return this.executeCommand(this.commandObjects.hpexpireAt(key2, unixTimeMillis, condition, fields2));
    }

    @Override
    public List<Long> hexpire(byte[] key2, long seconds, byte[] ... fields2) {
        return this.executeCommand(this.commandObjects.hexpire(key2, seconds, fields2));
    }

    @Override
    public List<Long> hexpire(byte[] key2, long seconds, ExpiryOption condition, byte[] ... fields2) {
        return this.executeCommand(this.commandObjects.hexpire(key2, seconds, condition, fields2));
    }

    @Override
    public List<Long> hpexpire(byte[] key2, long milliseconds, byte[] ... fields2) {
        return this.executeCommand(this.commandObjects.hpexpire(key2, milliseconds, fields2));
    }

    @Override
    public List<Long> hpexpire(byte[] key2, long milliseconds, ExpiryOption condition, byte[] ... fields2) {
        return this.executeCommand(this.commandObjects.hpexpire(key2, milliseconds, condition, fields2));
    }

    @Override
    public List<Long> hexpireAt(byte[] key2, long unixTimeSeconds, byte[] ... fields2) {
        return this.executeCommand(this.commandObjects.hexpireAt(key2, unixTimeSeconds, fields2));
    }

    @Override
    public List<Long> hexpireAt(byte[] key2, long unixTimeSeconds, ExpiryOption condition, byte[] ... fields2) {
        return this.executeCommand(this.commandObjects.hexpireAt(key2, unixTimeSeconds, condition, fields2));
    }

    @Override
    public List<Long> hpexpireAt(byte[] key2, long unixTimeMillis, byte[] ... fields2) {
        return this.executeCommand(this.commandObjects.hpexpireAt(key2, unixTimeMillis, fields2));
    }

    @Override
    public List<Long> hpexpireAt(byte[] key2, long unixTimeMillis, ExpiryOption condition, byte[] ... fields2) {
        return this.executeCommand(this.commandObjects.hpexpireAt(key2, unixTimeMillis, condition, fields2));
    }

    @Override
    public List<Long> hexpireTime(String key2, String ... fields2) {
        return this.executeCommand(this.commandObjects.hexpireTime(key2, fields2));
    }

    @Override
    public List<Long> hpexpireTime(String key2, String ... fields2) {
        return this.executeCommand(this.commandObjects.hpexpireTime(key2, fields2));
    }

    @Override
    public List<Long> httl(String key2, String ... fields2) {
        return this.executeCommand(this.commandObjects.httl(key2, fields2));
    }

    @Override
    public List<Long> hpttl(String key2, String ... fields2) {
        return this.executeCommand(this.commandObjects.hpttl(key2, fields2));
    }

    @Override
    public List<Long> hexpireTime(byte[] key2, byte[] ... fields2) {
        return this.executeCommand(this.commandObjects.hexpireTime(key2, fields2));
    }

    @Override
    public List<Long> hpexpireTime(byte[] key2, byte[] ... fields2) {
        return this.executeCommand(this.commandObjects.hpexpireTime(key2, fields2));
    }

    @Override
    public List<Long> httl(byte[] key2, byte[] ... fields2) {
        return this.executeCommand(this.commandObjects.httl(key2, fields2));
    }

    @Override
    public List<Long> hpttl(byte[] key2, byte[] ... fields2) {
        return this.executeCommand(this.commandObjects.hpttl(key2, fields2));
    }

    @Override
    public List<Long> hpersist(String key2, String ... fields2) {
        return this.executeCommand(this.commandObjects.hpersist(key2, fields2));
    }

    @Override
    public List<Long> hpersist(byte[] key2, byte[] ... fields2) {
        return this.executeCommand(this.commandObjects.hpersist(key2, fields2));
    }

    @Override
    public long sadd(String key2, String ... members) {
        return this.executeCommand(this.commandObjects.sadd(key2, members));
    }

    @Override
    public Set<String> smembers(String key2) {
        return this.executeCommand(this.commandObjects.smembers(key2));
    }

    @Override
    public long srem(String key2, String ... members) {
        return this.executeCommand(this.commandObjects.srem(key2, members));
    }

    @Override
    public String spop(String key2) {
        return this.executeCommand(this.commandObjects.spop(key2));
    }

    @Override
    public Set<String> spop(String key2, long count2) {
        return this.executeCommand(this.commandObjects.spop(key2, count2));
    }

    @Override
    public long scard(String key2) {
        return this.executeCommand(this.commandObjects.scard(key2));
    }

    @Override
    public boolean sismember(String key2, String member) {
        return this.executeCommand(this.commandObjects.sismember(key2, member));
    }

    @Override
    public List<Boolean> smismember(String key2, String ... members) {
        return this.executeCommand(this.commandObjects.smismember(key2, members));
    }

    @Override
    public long sadd(byte[] key2, byte[] ... members) {
        return this.executeCommand(this.commandObjects.sadd(key2, members));
    }

    @Override
    public Set<byte[]> smembers(byte[] key2) {
        return this.executeCommand(this.commandObjects.smembers(key2));
    }

    @Override
    public long srem(byte[] key2, byte[] ... members) {
        return this.executeCommand(this.commandObjects.srem(key2, members));
    }

    @Override
    public byte[] spop(byte[] key2) {
        return this.executeCommand(this.commandObjects.spop(key2));
    }

    @Override
    public Set<byte[]> spop(byte[] key2, long count2) {
        return this.executeCommand(this.commandObjects.spop(key2, count2));
    }

    @Override
    public long scard(byte[] key2) {
        return this.executeCommand(this.commandObjects.scard(key2));
    }

    @Override
    public boolean sismember(byte[] key2, byte[] member) {
        return this.executeCommand(this.commandObjects.sismember(key2, member));
    }

    @Override
    public List<Boolean> smismember(byte[] key2, byte[] ... members) {
        return this.executeCommand(this.commandObjects.smismember(key2, members));
    }

    @Override
    public String srandmember(String key2) {
        return this.executeCommand(this.commandObjects.srandmember(key2));
    }

    @Override
    public List<String> srandmember(String key2, int count2) {
        return this.executeCommand(this.commandObjects.srandmember(key2, count2));
    }

    @Override
    public ScanResult<String> sscan(String key2, String cursor, ScanParams params) {
        return this.executeCommand(this.commandObjects.sscan(key2, cursor, params));
    }

    @Override
    public byte[] srandmember(byte[] key2) {
        return this.executeCommand(this.commandObjects.srandmember(key2));
    }

    @Override
    public List<byte[]> srandmember(byte[] key2, int count2) {
        return this.executeCommand(this.commandObjects.srandmember(key2, count2));
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] key2, byte[] cursor, ScanParams params) {
        return this.executeCommand(this.commandObjects.sscan(key2, cursor, params));
    }

    @Override
    public Set<String> sdiff(String ... keys2) {
        return this.executeCommand(this.commandObjects.sdiff(keys2));
    }

    @Override
    public long sdiffstore(String dstkey, String ... keys2) {
        return this.executeCommand(this.commandObjects.sdiffstore(dstkey, keys2));
    }

    @Override
    public Set<String> sinter(String ... keys2) {
        return this.executeCommand(this.commandObjects.sinter(keys2));
    }

    @Override
    public long sinterstore(String dstkey, String ... keys2) {
        return this.executeCommand(this.commandObjects.sinterstore(dstkey, keys2));
    }

    @Override
    public long sintercard(String ... keys2) {
        return this.executeCommand(this.commandObjects.sintercard(keys2));
    }

    @Override
    public long sintercard(int limit, String ... keys2) {
        return this.executeCommand(this.commandObjects.sintercard(limit, keys2));
    }

    @Override
    public Set<String> sunion(String ... keys2) {
        return this.executeCommand(this.commandObjects.sunion(keys2));
    }

    @Override
    public long sunionstore(String dstkey, String ... keys2) {
        return this.executeCommand(this.commandObjects.sunionstore(dstkey, keys2));
    }

    @Override
    public long smove(String srckey, String dstkey, String member) {
        return this.executeCommand(this.commandObjects.smove(srckey, dstkey, member));
    }

    @Override
    public Set<byte[]> sdiff(byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.sdiff(keys2));
    }

    @Override
    public long sdiffstore(byte[] dstkey, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.sdiffstore(dstkey, keys2));
    }

    @Override
    public Set<byte[]> sinter(byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.sinter(keys2));
    }

    @Override
    public long sinterstore(byte[] dstkey, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.sinterstore(dstkey, keys2));
    }

    @Override
    public long sintercard(byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.sintercard(keys2));
    }

    @Override
    public long sintercard(int limit, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.sintercard(limit, keys2));
    }

    @Override
    public Set<byte[]> sunion(byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.sunion(keys2));
    }

    @Override
    public long sunionstore(byte[] dstkey, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.sunionstore(dstkey, keys2));
    }

    @Override
    public long smove(byte[] srckey, byte[] dstkey, byte[] member) {
        return this.executeCommand(this.commandObjects.smove(srckey, dstkey, member));
    }

    @Override
    public long zadd(String key2, double score, String member) {
        return this.executeCommand(this.commandObjects.zadd(key2, score, member));
    }

    @Override
    public long zadd(String key2, double score, String member, ZAddParams params) {
        return this.executeCommand(this.commandObjects.zadd(key2, score, member, params));
    }

    @Override
    public long zadd(String key2, Map<String, Double> scoreMembers) {
        return this.executeCommand(this.commandObjects.zadd(key2, scoreMembers));
    }

    @Override
    public long zadd(String key2, Map<String, Double> scoreMembers, ZAddParams params) {
        return this.executeCommand(this.commandObjects.zadd(key2, scoreMembers, params));
    }

    @Override
    public Double zaddIncr(String key2, double score, String member, ZAddParams params) {
        return this.executeCommand(this.commandObjects.zaddIncr(key2, score, member, params));
    }

    @Override
    public long zadd(byte[] key2, double score, byte[] member) {
        return this.executeCommand(this.commandObjects.zadd(key2, score, member));
    }

    @Override
    public long zadd(byte[] key2, double score, byte[] member, ZAddParams params) {
        return this.executeCommand(this.commandObjects.zadd(key2, score, member, params));
    }

    @Override
    public long zadd(byte[] key2, Map<byte[], Double> scoreMembers) {
        return this.executeCommand(this.commandObjects.zadd(key2, scoreMembers));
    }

    @Override
    public long zadd(byte[] key2, Map<byte[], Double> scoreMembers, ZAddParams params) {
        return this.executeCommand(this.commandObjects.zadd(key2, scoreMembers, params));
    }

    @Override
    public Double zaddIncr(byte[] key2, double score, byte[] member, ZAddParams params) {
        return this.executeCommand(this.commandObjects.zaddIncr(key2, score, member, params));
    }

    @Override
    public long zrem(String key2, String ... members) {
        return this.executeCommand(this.commandObjects.zrem(key2, members));
    }

    @Override
    public double zincrby(String key2, double increment, String member) {
        return this.executeCommand(this.commandObjects.zincrby(key2, increment, member));
    }

    @Override
    public Double zincrby(String key2, double increment, String member, ZIncrByParams params) {
        return this.executeCommand(this.commandObjects.zincrby(key2, increment, member, params));
    }

    @Override
    public Long zrank(String key2, String member) {
        return this.executeCommand(this.commandObjects.zrank(key2, member));
    }

    @Override
    public Long zrevrank(String key2, String member) {
        return this.executeCommand(this.commandObjects.zrevrank(key2, member));
    }

    @Override
    public KeyValue<Long, Double> zrankWithScore(String key2, String member) {
        return this.executeCommand(this.commandObjects.zrankWithScore(key2, member));
    }

    @Override
    public KeyValue<Long, Double> zrevrankWithScore(String key2, String member) {
        return this.executeCommand(this.commandObjects.zrevrankWithScore(key2, member));
    }

    @Override
    public long zrem(byte[] key2, byte[] ... members) {
        return this.executeCommand(this.commandObjects.zrem(key2, members));
    }

    @Override
    public double zincrby(byte[] key2, double increment, byte[] member) {
        return this.executeCommand(this.commandObjects.zincrby(key2, increment, member));
    }

    @Override
    public Double zincrby(byte[] key2, double increment, byte[] member, ZIncrByParams params) {
        return this.executeCommand(this.commandObjects.zincrby(key2, increment, member, params));
    }

    @Override
    public Long zrank(byte[] key2, byte[] member) {
        return this.executeCommand(this.commandObjects.zrank(key2, member));
    }

    @Override
    public Long zrevrank(byte[] key2, byte[] member) {
        return this.executeCommand(this.commandObjects.zrevrank(key2, member));
    }

    @Override
    public KeyValue<Long, Double> zrankWithScore(byte[] key2, byte[] member) {
        return this.executeCommand(this.commandObjects.zrankWithScore(key2, member));
    }

    @Override
    public KeyValue<Long, Double> zrevrankWithScore(byte[] key2, byte[] member) {
        return this.executeCommand(this.commandObjects.zrevrankWithScore(key2, member));
    }

    @Override
    public String zrandmember(String key2) {
        return this.executeCommand(this.commandObjects.zrandmember(key2));
    }

    @Override
    public List<String> zrandmember(String key2, long count2) {
        return this.executeCommand(this.commandObjects.zrandmember(key2, count2));
    }

    @Override
    public List<Tuple> zrandmemberWithScores(String key2, long count2) {
        return this.executeCommand(this.commandObjects.zrandmemberWithScores(key2, count2));
    }

    @Override
    public long zcard(String key2) {
        return this.executeCommand(this.commandObjects.zcard(key2));
    }

    @Override
    public Double zscore(String key2, String member) {
        return this.executeCommand(this.commandObjects.zscore(key2, member));
    }

    @Override
    public List<Double> zmscore(String key2, String ... members) {
        return this.executeCommand(this.commandObjects.zmscore(key2, members));
    }

    @Override
    public byte[] zrandmember(byte[] key2) {
        return this.executeCommand(this.commandObjects.zrandmember(key2));
    }

    @Override
    public List<byte[]> zrandmember(byte[] key2, long count2) {
        return this.executeCommand(this.commandObjects.zrandmember(key2, count2));
    }

    @Override
    public List<Tuple> zrandmemberWithScores(byte[] key2, long count2) {
        return this.executeCommand(this.commandObjects.zrandmemberWithScores(key2, count2));
    }

    @Override
    public long zcard(byte[] key2) {
        return this.executeCommand(this.commandObjects.zcard(key2));
    }

    @Override
    public Double zscore(byte[] key2, byte[] member) {
        return this.executeCommand(this.commandObjects.zscore(key2, member));
    }

    @Override
    public List<Double> zmscore(byte[] key2, byte[] ... members) {
        return this.executeCommand(this.commandObjects.zmscore(key2, members));
    }

    @Override
    public Tuple zpopmax(String key2) {
        return this.executeCommand(this.commandObjects.zpopmax(key2));
    }

    @Override
    public List<Tuple> zpopmax(String key2, int count2) {
        return this.executeCommand(this.commandObjects.zpopmax(key2, count2));
    }

    @Override
    public Tuple zpopmin(String key2) {
        return this.executeCommand(this.commandObjects.zpopmin(key2));
    }

    @Override
    public List<Tuple> zpopmin(String key2, int count2) {
        return this.executeCommand(this.commandObjects.zpopmin(key2, count2));
    }

    @Override
    public long zcount(String key2, double min2, double max2) {
        return this.executeCommand(this.commandObjects.zcount(key2, min2, max2));
    }

    @Override
    public long zcount(String key2, String min2, String max2) {
        return this.executeCommand(this.commandObjects.zcount(key2, min2, max2));
    }

    @Override
    public Tuple zpopmax(byte[] key2) {
        return this.executeCommand(this.commandObjects.zpopmax(key2));
    }

    @Override
    public List<Tuple> zpopmax(byte[] key2, int count2) {
        return this.executeCommand(this.commandObjects.zpopmax(key2, count2));
    }

    @Override
    public Tuple zpopmin(byte[] key2) {
        return this.executeCommand(this.commandObjects.zpopmin(key2));
    }

    @Override
    public List<Tuple> zpopmin(byte[] key2, int count2) {
        return this.executeCommand(this.commandObjects.zpopmin(key2, count2));
    }

    @Override
    public long zcount(byte[] key2, double min2, double max2) {
        return this.executeCommand(this.commandObjects.zcount(key2, min2, max2));
    }

    @Override
    public long zcount(byte[] key2, byte[] min2, byte[] max2) {
        return this.executeCommand(this.commandObjects.zcount(key2, min2, max2));
    }

    @Override
    public List<String> zrange(String key2, long start2, long stop) {
        return this.executeCommand(this.commandObjects.zrange(key2, start2, stop));
    }

    @Override
    public List<String> zrevrange(String key2, long start2, long stop) {
        return this.executeCommand(this.commandObjects.zrevrange(key2, start2, stop));
    }

    @Override
    public List<Tuple> zrangeWithScores(String key2, long start2, long stop) {
        return this.executeCommand(this.commandObjects.zrangeWithScores(key2, start2, stop));
    }

    @Override
    public List<Tuple> zrevrangeWithScores(String key2, long start2, long stop) {
        return this.executeCommand(this.commandObjects.zrevrangeWithScores(key2, start2, stop));
    }

    @Override
    public List<String> zrange(String key2, ZRangeParams zRangeParams) {
        return this.executeCommand(this.commandObjects.zrange(key2, zRangeParams));
    }

    @Override
    public List<Tuple> zrangeWithScores(String key2, ZRangeParams zRangeParams) {
        return this.executeCommand(this.commandObjects.zrangeWithScores(key2, zRangeParams));
    }

    @Override
    public long zrangestore(String dest, String src, ZRangeParams zRangeParams) {
        return this.executeCommand(this.commandObjects.zrangestore(dest, src, zRangeParams));
    }

    @Override
    public List<String> zrangeByScore(String key2, double min2, double max2) {
        return this.executeCommand(this.commandObjects.zrangeByScore(key2, min2, max2));
    }

    @Override
    public List<String> zrangeByScore(String key2, String min2, String max2) {
        return this.executeCommand(this.commandObjects.zrangeByScore(key2, min2, max2));
    }

    @Override
    public List<String> zrevrangeByScore(String key2, double max2, double min2) {
        return this.executeCommand(this.commandObjects.zrevrangeByScore(key2, max2, min2));
    }

    @Override
    public List<String> zrangeByScore(String key2, double min2, double max2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrangeByScore(key2, min2, max2, offset, count2));
    }

    @Override
    public List<String> zrevrangeByScore(String key2, String max2, String min2) {
        return this.executeCommand(this.commandObjects.zrevrangeByScore(key2, max2, min2));
    }

    @Override
    public List<String> zrangeByScore(String key2, String min2, String max2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrangeByScore(key2, min2, max2, offset, count2));
    }

    @Override
    public List<String> zrevrangeByScore(String key2, double max2, double min2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrevrangeByScore(key2, max2, min2, offset, count2));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(String key2, double min2, double max2) {
        return this.executeCommand(this.commandObjects.zrangeByScoreWithScores(key2, min2, max2));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(String key2, double max2, double min2) {
        return this.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(key2, max2, min2));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(String key2, double min2, double max2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrangeByScoreWithScores(key2, min2, max2, offset, count2));
    }

    @Override
    public List<String> zrevrangeByScore(String key2, String max2, String min2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrevrangeByScore(key2, max2, min2, offset, count2));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(String key2, String min2, String max2) {
        return this.executeCommand(this.commandObjects.zrangeByScoreWithScores(key2, min2, max2));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(String key2, String max2, String min2) {
        return this.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(key2, max2, min2));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(String key2, String min2, String max2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrangeByScoreWithScores(key2, min2, max2, offset, count2));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(String key2, double max2, double min2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(key2, max2, min2, offset, count2));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(String key2, String max2, String min2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(key2, max2, min2, offset, count2));
    }

    @Override
    public List<byte[]> zrange(byte[] key2, long start2, long stop) {
        return this.executeCommand(this.commandObjects.zrange(key2, start2, stop));
    }

    @Override
    public List<byte[]> zrevrange(byte[] key2, long start2, long stop) {
        return this.executeCommand(this.commandObjects.zrevrange(key2, start2, stop));
    }

    @Override
    public List<Tuple> zrangeWithScores(byte[] key2, long start2, long stop) {
        return this.executeCommand(this.commandObjects.zrangeWithScores(key2, start2, stop));
    }

    @Override
    public List<Tuple> zrevrangeWithScores(byte[] key2, long start2, long stop) {
        return this.executeCommand(this.commandObjects.zrevrangeWithScores(key2, start2, stop));
    }

    @Override
    public List<byte[]> zrange(byte[] key2, ZRangeParams zRangeParams) {
        return this.executeCommand(this.commandObjects.zrange(key2, zRangeParams));
    }

    @Override
    public List<Tuple> zrangeWithScores(byte[] key2, ZRangeParams zRangeParams) {
        return this.executeCommand(this.commandObjects.zrangeWithScores(key2, zRangeParams));
    }

    @Override
    public long zrangestore(byte[] dest, byte[] src, ZRangeParams zRangeParams) {
        return this.executeCommand(this.commandObjects.zrangestore(dest, src, zRangeParams));
    }

    @Override
    public List<byte[]> zrangeByScore(byte[] key2, double min2, double max2) {
        return this.executeCommand(this.commandObjects.zrangeByScore(key2, min2, max2));
    }

    @Override
    public List<byte[]> zrangeByScore(byte[] key2, byte[] min2, byte[] max2) {
        return this.executeCommand(this.commandObjects.zrangeByScore(key2, min2, max2));
    }

    @Override
    public List<byte[]> zrevrangeByScore(byte[] key2, double max2, double min2) {
        return this.executeCommand(this.commandObjects.zrevrangeByScore(key2, max2, min2));
    }

    @Override
    public List<byte[]> zrangeByScore(byte[] key2, double min2, double max2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrangeByScore(key2, min2, max2, offset, count2));
    }

    @Override
    public List<byte[]> zrevrangeByScore(byte[] key2, byte[] max2, byte[] min2) {
        return this.executeCommand(this.commandObjects.zrevrangeByScore(key2, max2, min2));
    }

    @Override
    public List<byte[]> zrangeByScore(byte[] key2, byte[] min2, byte[] max2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrangeByScore(key2, min2, max2, offset, count2));
    }

    @Override
    public List<byte[]> zrevrangeByScore(byte[] key2, double max2, double min2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrevrangeByScore(key2, max2, min2, offset, count2));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(byte[] key2, double min2, double max2) {
        return this.executeCommand(this.commandObjects.zrangeByScoreWithScores(key2, min2, max2));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(byte[] key2, double max2, double min2) {
        return this.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(key2, max2, min2));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(byte[] key2, double min2, double max2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrangeByScoreWithScores(key2, min2, max2, offset, count2));
    }

    @Override
    public List<byte[]> zrevrangeByScore(byte[] key2, byte[] max2, byte[] min2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrevrangeByScore(key2, max2, min2, offset, count2));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(byte[] key2, byte[] min2, byte[] max2) {
        return this.executeCommand(this.commandObjects.zrangeByScoreWithScores(key2, min2, max2));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(byte[] key2, byte[] max2, byte[] min2) {
        return this.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(key2, max2, min2));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(byte[] key2, byte[] min2, byte[] max2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrangeByScoreWithScores(key2, min2, max2, offset, count2));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(byte[] key2, double max2, double min2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(key2, max2, min2, offset, count2));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(byte[] key2, byte[] max2, byte[] min2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(key2, max2, min2, offset, count2));
    }

    @Override
    public long zremrangeByRank(String key2, long start2, long stop) {
        return this.executeCommand(this.commandObjects.zremrangeByRank(key2, start2, stop));
    }

    @Override
    public long zremrangeByScore(String key2, double min2, double max2) {
        return this.executeCommand(this.commandObjects.zremrangeByScore(key2, min2, max2));
    }

    @Override
    public long zremrangeByScore(String key2, String min2, String max2) {
        return this.executeCommand(this.commandObjects.zremrangeByScore(key2, min2, max2));
    }

    @Override
    public long zremrangeByRank(byte[] key2, long start2, long stop) {
        return this.executeCommand(this.commandObjects.zremrangeByRank(key2, start2, stop));
    }

    @Override
    public long zremrangeByScore(byte[] key2, double min2, double max2) {
        return this.executeCommand(this.commandObjects.zremrangeByScore(key2, min2, max2));
    }

    @Override
    public long zremrangeByScore(byte[] key2, byte[] min2, byte[] max2) {
        return this.executeCommand(this.commandObjects.zremrangeByScore(key2, min2, max2));
    }

    @Override
    public long zlexcount(String key2, String min2, String max2) {
        return this.executeCommand(this.commandObjects.zlexcount(key2, min2, max2));
    }

    @Override
    public List<String> zrangeByLex(String key2, String min2, String max2) {
        return this.executeCommand(this.commandObjects.zrangeByLex(key2, min2, max2));
    }

    @Override
    public List<String> zrangeByLex(String key2, String min2, String max2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrangeByLex(key2, min2, max2, offset, count2));
    }

    @Override
    public List<String> zrevrangeByLex(String key2, String max2, String min2) {
        return this.executeCommand(this.commandObjects.zrevrangeByLex(key2, max2, min2));
    }

    @Override
    public List<String> zrevrangeByLex(String key2, String max2, String min2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrevrangeByLex(key2, max2, min2, offset, count2));
    }

    @Override
    public long zremrangeByLex(String key2, String min2, String max2) {
        return this.executeCommand(this.commandObjects.zremrangeByLex(key2, min2, max2));
    }

    @Override
    public long zlexcount(byte[] key2, byte[] min2, byte[] max2) {
        return this.executeCommand(this.commandObjects.zlexcount(key2, min2, max2));
    }

    @Override
    public List<byte[]> zrangeByLex(byte[] key2, byte[] min2, byte[] max2) {
        return this.executeCommand(this.commandObjects.zrangeByLex(key2, min2, max2));
    }

    @Override
    public List<byte[]> zrangeByLex(byte[] key2, byte[] min2, byte[] max2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrangeByLex(key2, min2, max2, offset, count2));
    }

    @Override
    public List<byte[]> zrevrangeByLex(byte[] key2, byte[] max2, byte[] min2) {
        return this.executeCommand(this.commandObjects.zrevrangeByLex(key2, max2, min2));
    }

    @Override
    public List<byte[]> zrevrangeByLex(byte[] key2, byte[] max2, byte[] min2, int offset, int count2) {
        return this.executeCommand(this.commandObjects.zrevrangeByLex(key2, max2, min2, offset, count2));
    }

    @Override
    public long zremrangeByLex(byte[] key2, byte[] min2, byte[] max2) {
        return this.executeCommand(this.commandObjects.zremrangeByLex(key2, min2, max2));
    }

    @Override
    public ScanResult<Tuple> zscan(String key2, String cursor, ScanParams params) {
        return this.executeCommand(this.commandObjects.zscan(key2, cursor, params));
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] key2, byte[] cursor, ScanParams params) {
        return this.executeCommand(this.commandObjects.zscan(key2, cursor, params));
    }

    @Override
    public KeyValue<String, Tuple> bzpopmax(double timeout2, String ... keys2) {
        return this.executeCommand(this.commandObjects.bzpopmax(timeout2, keys2));
    }

    @Override
    public KeyValue<String, Tuple> bzpopmin(double timeout2, String ... keys2) {
        return this.executeCommand(this.commandObjects.bzpopmin(timeout2, keys2));
    }

    @Override
    public KeyValue<byte[], Tuple> bzpopmax(double timeout2, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.bzpopmax(timeout2, keys2));
    }

    @Override
    public KeyValue<byte[], Tuple> bzpopmin(double timeout2, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.bzpopmin(timeout2, keys2));
    }

    @Override
    public List<String> zdiff(String ... keys2) {
        return this.executeCommand(this.commandObjects.zdiff(keys2));
    }

    @Override
    public List<Tuple> zdiffWithScores(String ... keys2) {
        return this.executeCommand(this.commandObjects.zdiffWithScores(keys2));
    }

    @Override
    @Deprecated
    public long zdiffStore(String dstkey, String ... keys2) {
        return this.executeCommand(this.commandObjects.zdiffStore(dstkey, keys2));
    }

    @Override
    public long zdiffstore(String dstkey, String ... keys2) {
        return this.executeCommand(this.commandObjects.zdiffstore(dstkey, keys2));
    }

    @Override
    public List<byte[]> zdiff(byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.zdiff(keys2));
    }

    @Override
    public List<Tuple> zdiffWithScores(byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.zdiffWithScores(keys2));
    }

    @Override
    @Deprecated
    public long zdiffStore(byte[] dstkey, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.zdiffStore(dstkey, keys2));
    }

    @Override
    public long zdiffstore(byte[] dstkey, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.zdiffstore(dstkey, keys2));
    }

    @Override
    public long zinterstore(String dstkey, String ... sets) {
        return this.executeCommand(this.commandObjects.zinterstore(dstkey, sets));
    }

    @Override
    public long zinterstore(String dstkey, ZParams params, String ... sets) {
        return this.executeCommand(this.commandObjects.zinterstore(dstkey, params, sets));
    }

    @Override
    public List<String> zinter(ZParams params, String ... keys2) {
        return this.executeCommand(this.commandObjects.zinter(params, keys2));
    }

    @Override
    public List<Tuple> zinterWithScores(ZParams params, String ... keys2) {
        return this.executeCommand(this.commandObjects.zinterWithScores(params, keys2));
    }

    @Override
    public long zinterstore(byte[] dstkey, byte[] ... sets) {
        return this.executeCommand(this.commandObjects.zinterstore(dstkey, sets));
    }

    @Override
    public long zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        return this.executeCommand(this.commandObjects.zinterstore(dstkey, params, sets));
    }

    @Override
    public long zintercard(byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.zintercard(keys2));
    }

    @Override
    public long zintercard(long limit, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.zintercard(limit, keys2));
    }

    @Override
    public long zintercard(String ... keys2) {
        return this.executeCommand(this.commandObjects.zintercard(keys2));
    }

    @Override
    public long zintercard(long limit, String ... keys2) {
        return this.executeCommand(this.commandObjects.zintercard(limit, keys2));
    }

    @Override
    public List<byte[]> zinter(ZParams params, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.zinter(params, keys2));
    }

    @Override
    public List<Tuple> zinterWithScores(ZParams params, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.zinterWithScores(params, keys2));
    }

    @Override
    public List<String> zunion(ZParams params, String ... keys2) {
        return this.executeCommand(this.commandObjects.zunion(params, keys2));
    }

    @Override
    public List<Tuple> zunionWithScores(ZParams params, String ... keys2) {
        return this.executeCommand(this.commandObjects.zunionWithScores(params, keys2));
    }

    @Override
    public long zunionstore(String dstkey, String ... sets) {
        return this.executeCommand(this.commandObjects.zunionstore(dstkey, sets));
    }

    @Override
    public long zunionstore(String dstkey, ZParams params, String ... sets) {
        return this.executeCommand(this.commandObjects.zunionstore(dstkey, params, sets));
    }

    @Override
    public List<byte[]> zunion(ZParams params, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.zunion(params, keys2));
    }

    @Override
    public List<Tuple> zunionWithScores(ZParams params, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.zunionWithScores(params, keys2));
    }

    @Override
    public long zunionstore(byte[] dstkey, byte[] ... sets) {
        return this.executeCommand(this.commandObjects.zunionstore(dstkey, sets));
    }

    @Override
    public long zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        return this.executeCommand(this.commandObjects.zunionstore(dstkey, params, sets));
    }

    @Override
    public KeyValue<String, List<Tuple>> zmpop(SortedSetOption option, String ... keys2) {
        return this.executeCommand(this.commandObjects.zmpop(option, keys2));
    }

    @Override
    public KeyValue<String, List<Tuple>> zmpop(SortedSetOption option, int count2, String ... keys2) {
        return this.executeCommand(this.commandObjects.zmpop(option, count2, keys2));
    }

    @Override
    public KeyValue<String, List<Tuple>> bzmpop(double timeout2, SortedSetOption option, String ... keys2) {
        return this.executeCommand(this.commandObjects.bzmpop(timeout2, option, keys2));
    }

    @Override
    public KeyValue<String, List<Tuple>> bzmpop(double timeout2, SortedSetOption option, int count2, String ... keys2) {
        return this.executeCommand(this.commandObjects.bzmpop(timeout2, option, count2, keys2));
    }

    @Override
    public KeyValue<byte[], List<Tuple>> zmpop(SortedSetOption option, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.zmpop(option, keys2));
    }

    @Override
    public KeyValue<byte[], List<Tuple>> zmpop(SortedSetOption option, int count2, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.zmpop(option, count2, keys2));
    }

    @Override
    public KeyValue<byte[], List<Tuple>> bzmpop(double timeout2, SortedSetOption option, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.bzmpop(timeout2, option, keys2));
    }

    @Override
    public KeyValue<byte[], List<Tuple>> bzmpop(double timeout2, SortedSetOption option, int count2, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.bzmpop(timeout2, option, count2, keys2));
    }

    @Override
    public long geoadd(String key2, double longitude, double latitude, String member) {
        return this.executeCommand(this.commandObjects.geoadd(key2, longitude, latitude, member));
    }

    @Override
    public long geoadd(String key2, Map<String, GeoCoordinate> memberCoordinateMap) {
        return this.executeCommand(this.commandObjects.geoadd(key2, memberCoordinateMap));
    }

    @Override
    public long geoadd(String key2, GeoAddParams params, Map<String, GeoCoordinate> memberCoordinateMap) {
        return this.executeCommand(this.commandObjects.geoadd(key2, params, memberCoordinateMap));
    }

    @Override
    public Double geodist(String key2, String member1, String member2) {
        return this.executeCommand(this.commandObjects.geodist(key2, member1, member2));
    }

    @Override
    public Double geodist(String key2, String member1, String member2, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geodist(key2, member1, member2, unit));
    }

    @Override
    public List<String> geohash(String key2, String ... members) {
        return this.executeCommand(this.commandObjects.geohash(key2, members));
    }

    @Override
    public List<GeoCoordinate> geopos(String key2, String ... members) {
        return this.executeCommand(this.commandObjects.geopos(key2, members));
    }

    @Override
    public long geoadd(byte[] key2, double longitude, double latitude, byte[] member) {
        return this.executeCommand(this.commandObjects.geoadd(key2, longitude, latitude, member));
    }

    @Override
    public long geoadd(byte[] key2, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        return this.executeCommand(this.commandObjects.geoadd(key2, memberCoordinateMap));
    }

    @Override
    public long geoadd(byte[] key2, GeoAddParams params, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        return this.executeCommand(this.commandObjects.geoadd(key2, params, memberCoordinateMap));
    }

    @Override
    public Double geodist(byte[] key2, byte[] member1, byte[] member2) {
        return this.executeCommand(this.commandObjects.geodist(key2, member1, member2));
    }

    @Override
    public Double geodist(byte[] key2, byte[] member1, byte[] member2, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geodist(key2, member1, member2, unit));
    }

    @Override
    public List<byte[]> geohash(byte[] key2, byte[] ... members) {
        return this.executeCommand(this.commandObjects.geohash(key2, members));
    }

    @Override
    public List<GeoCoordinate> geopos(byte[] key2, byte[] ... members) {
        return this.executeCommand(this.commandObjects.geopos(key2, members));
    }

    @Override
    public List<GeoRadiusResponse> georadius(String key2, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.georadius(key2, longitude, latitude, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(String key2, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.georadiusReadonly(key2, longitude, latitude, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> georadius(String key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.executeCommand(this.commandObjects.georadius(key2, longitude, latitude, radius, unit, param));
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(String key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.executeCommand(this.commandObjects.georadiusReadonly(key2, longitude, latitude, radius, unit, param));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String key2, String member, double radius, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.georadiusByMember(key2, member, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key2, String member, double radius, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.georadiusByMemberReadonly(key2, member, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String key2, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.executeCommand(this.commandObjects.georadiusByMember(key2, member, radius, unit, param));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key2, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.executeCommand(this.commandObjects.georadiusByMemberReadonly(key2, member, radius, unit, param));
    }

    @Override
    public long georadiusStore(String key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        return this.executeCommand(this.commandObjects.georadiusStore(key2, longitude, latitude, radius, unit, param, storeParam));
    }

    @Override
    public long georadiusByMemberStore(String key2, String member, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        return this.executeCommand(this.commandObjects.georadiusByMemberStore(key2, member, radius, unit, param, storeParam));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String key2, String member, double radius, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geosearch(key2, member, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String key2, GeoCoordinate coord, double radius, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geosearch(key2, coord, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String key2, String member, double width, double height, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geosearch(key2, member, width, height, unit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String key2, GeoCoordinate coord, double width, double height, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geosearch(key2, coord, width, height, unit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String key2, GeoSearchParam params) {
        return this.executeCommand(this.commandObjects.geosearch(key2, params));
    }

    @Override
    public long geosearchStore(String dest, String src, String member, double radius, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geosearchStore(dest, src, member, radius, unit));
    }

    @Override
    public long geosearchStore(String dest, String src, GeoCoordinate coord, double radius, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geosearchStore(dest, src, coord, radius, unit));
    }

    @Override
    public long geosearchStore(String dest, String src, String member, double width, double height, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geosearchStore(dest, src, member, width, height, unit));
    }

    @Override
    public long geosearchStore(String dest, String src, GeoCoordinate coord, double width, double height, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geosearchStore(dest, src, coord, width, height, unit));
    }

    @Override
    public long geosearchStore(String dest, String src, GeoSearchParam params) {
        return this.executeCommand(this.commandObjects.geosearchStore(dest, src, params));
    }

    @Override
    public long geosearchStoreStoreDist(String dest, String src, GeoSearchParam params) {
        return this.executeCommand(this.commandObjects.geosearchStoreStoreDist(dest, src, params));
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key2, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.georadius(key2, longitude, latitude, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(byte[] key2, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.georadiusReadonly(key2, longitude, latitude, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.executeCommand(this.commandObjects.georadius(key2, longitude, latitude, radius, unit, param));
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(byte[] key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.executeCommand(this.commandObjects.georadiusReadonly(key2, longitude, latitude, radius, unit, param));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key2, byte[] member, double radius, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.georadiusByMember(key2, member, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] key2, byte[] member, double radius, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.georadiusByMemberReadonly(key2, member, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key2, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.executeCommand(this.commandObjects.georadiusByMember(key2, member, radius, unit, param));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] key2, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.executeCommand(this.commandObjects.georadiusByMemberReadonly(key2, member, radius, unit, param));
    }

    @Override
    public long georadiusStore(byte[] key2, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        return this.executeCommand(this.commandObjects.georadiusStore(key2, longitude, latitude, radius, unit, param, storeParam));
    }

    @Override
    public long georadiusByMemberStore(byte[] key2, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        return this.executeCommand(this.commandObjects.georadiusByMemberStore(key2, member, radius, unit, param, storeParam));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] key2, byte[] member, double radius, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geosearch(key2, member, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] key2, GeoCoordinate coord, double radius, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geosearch(key2, coord, radius, unit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] key2, byte[] member, double width, double height, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geosearch(key2, member, width, height, unit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] key2, GeoCoordinate coord, double width, double height, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geosearch(key2, coord, width, height, unit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] key2, GeoSearchParam params) {
        return this.executeCommand(this.commandObjects.geosearch(key2, params));
    }

    @Override
    public long geosearchStore(byte[] dest, byte[] src, byte[] member, double radius, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geosearchStore(dest, src, member, radius, unit));
    }

    @Override
    public long geosearchStore(byte[] dest, byte[] src, GeoCoordinate coord, double radius, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geosearchStore(dest, src, coord, radius, unit));
    }

    @Override
    public long geosearchStore(byte[] dest, byte[] src, byte[] member, double width, double height, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geosearchStore(dest, src, member, width, height, unit));
    }

    @Override
    public long geosearchStore(byte[] dest, byte[] src, GeoCoordinate coord, double width, double height, GeoUnit unit) {
        return this.executeCommand(this.commandObjects.geosearchStore(dest, src, coord, width, height, unit));
    }

    @Override
    public long geosearchStore(byte[] dest, byte[] src, GeoSearchParam params) {
        return this.executeCommand(this.commandObjects.geosearchStore(dest, src, params));
    }

    @Override
    public long geosearchStoreStoreDist(byte[] dest, byte[] src, GeoSearchParam params) {
        return this.executeCommand(this.commandObjects.geosearchStoreStoreDist(dest, src, params));
    }

    @Override
    public long pfadd(String key2, String ... elements) {
        return this.executeCommand(this.commandObjects.pfadd(key2, elements));
    }

    @Override
    public String pfmerge(String destkey, String ... sourcekeys) {
        return this.executeCommand(this.commandObjects.pfmerge(destkey, sourcekeys));
    }

    @Override
    public long pfcount(String key2) {
        return this.executeCommand(this.commandObjects.pfcount(key2));
    }

    @Override
    public long pfcount(String ... keys2) {
        return this.executeCommand(this.commandObjects.pfcount(keys2));
    }

    @Override
    public long pfadd(byte[] key2, byte[] ... elements) {
        return this.executeCommand(this.commandObjects.pfadd(key2, elements));
    }

    @Override
    public String pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        return this.executeCommand(this.commandObjects.pfmerge(destkey, sourcekeys));
    }

    @Override
    public long pfcount(byte[] key2) {
        return this.executeCommand(this.commandObjects.pfcount(key2));
    }

    @Override
    public long pfcount(byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.pfcount(keys2));
    }

    @Override
    public StreamEntryID xadd(String key2, StreamEntryID id, Map<String, String> hash) {
        return this.executeCommand(this.commandObjects.xadd(key2, id, hash));
    }

    @Override
    public StreamEntryID xadd(String key2, XAddParams params, Map<String, String> hash) {
        return this.executeCommand(this.commandObjects.xadd(key2, params, hash));
    }

    @Override
    public long xlen(String key2) {
        return this.executeCommand(this.commandObjects.xlen(key2));
    }

    @Override
    public List<StreamEntry> xrange(String key2, StreamEntryID start2, StreamEntryID end2) {
        return this.executeCommand(this.commandObjects.xrange(key2, start2, end2));
    }

    @Override
    public List<StreamEntry> xrange(String key2, StreamEntryID start2, StreamEntryID end2, int count2) {
        return this.executeCommand(this.commandObjects.xrange(key2, start2, end2, count2));
    }

    @Override
    public List<StreamEntry> xrevrange(String key2, StreamEntryID end2, StreamEntryID start2) {
        return this.executeCommand(this.commandObjects.xrevrange(key2, end2, start2));
    }

    @Override
    public List<StreamEntry> xrevrange(String key2, StreamEntryID end2, StreamEntryID start2, int count2) {
        return this.executeCommand(this.commandObjects.xrevrange(key2, end2, start2, count2));
    }

    @Override
    public List<StreamEntry> xrange(String key2, String start2, String end2) {
        return this.executeCommand(this.commandObjects.xrange(key2, start2, end2));
    }

    @Override
    public List<StreamEntry> xrange(String key2, String start2, String end2, int count2) {
        return this.executeCommand(this.commandObjects.xrange(key2, start2, end2, count2));
    }

    @Override
    public List<StreamEntry> xrevrange(String key2, String end2, String start2) {
        return this.executeCommand(this.commandObjects.xrevrange(key2, end2, start2));
    }

    @Override
    public List<StreamEntry> xrevrange(String key2, String end2, String start2, int count2) {
        return this.executeCommand(this.commandObjects.xrevrange(key2, end2, start2, count2));
    }

    @Override
    public long xack(String key2, String group, StreamEntryID ... ids) {
        return this.executeCommand(this.commandObjects.xack(key2, group, ids));
    }

    @Override
    public String xgroupCreate(String key2, String groupName, StreamEntryID id, boolean makeStream) {
        return this.executeCommand(this.commandObjects.xgroupCreate(key2, groupName, id, makeStream));
    }

    @Override
    public String xgroupSetID(String key2, String groupName, StreamEntryID id) {
        return this.executeCommand(this.commandObjects.xgroupSetID(key2, groupName, id));
    }

    @Override
    public long xgroupDestroy(String key2, String groupName) {
        return this.executeCommand(this.commandObjects.xgroupDestroy(key2, groupName));
    }

    @Override
    public boolean xgroupCreateConsumer(String key2, String groupName, String consumerName) {
        return this.executeCommand(this.commandObjects.xgroupCreateConsumer(key2, groupName, consumerName));
    }

    @Override
    public long xgroupDelConsumer(String key2, String groupName, String consumerName) {
        return this.executeCommand(this.commandObjects.xgroupDelConsumer(key2, groupName, consumerName));
    }

    @Override
    public StreamPendingSummary xpending(String key2, String groupName) {
        return this.executeCommand(this.commandObjects.xpending(key2, groupName));
    }

    @Override
    public List<StreamPendingEntry> xpending(String key2, String groupName, XPendingParams params) {
        return this.executeCommand(this.commandObjects.xpending(key2, groupName, params));
    }

    @Override
    public long xdel(String key2, StreamEntryID ... ids) {
        return this.executeCommand(this.commandObjects.xdel(key2, ids));
    }

    @Override
    public long xtrim(String key2, long maxLen, boolean approximate) {
        return this.executeCommand(this.commandObjects.xtrim(key2, maxLen, approximate));
    }

    @Override
    public long xtrim(String key2, XTrimParams params) {
        return this.executeCommand(this.commandObjects.xtrim(key2, params));
    }

    @Override
    public List<StreamEntry> xclaim(String key2, String group, String consumerName, long minIdleTime, XClaimParams params, StreamEntryID ... ids) {
        return this.executeCommand(this.commandObjects.xclaim(key2, group, consumerName, minIdleTime, params, ids));
    }

    @Override
    public List<StreamEntryID> xclaimJustId(String key2, String group, String consumerName, long minIdleTime, XClaimParams params, StreamEntryID ... ids) {
        return this.executeCommand(this.commandObjects.xclaimJustId(key2, group, consumerName, minIdleTime, params, ids));
    }

    @Override
    public Map.Entry<StreamEntryID, List<StreamEntry>> xautoclaim(String key2, String group, String consumerName, long minIdleTime, StreamEntryID start2, XAutoClaimParams params) {
        return this.executeCommand(this.commandObjects.xautoclaim(key2, group, consumerName, minIdleTime, start2, params));
    }

    @Override
    public Map.Entry<StreamEntryID, List<StreamEntryID>> xautoclaimJustId(String key2, String group, String consumerName, long minIdleTime, StreamEntryID start2, XAutoClaimParams params) {
        return this.executeCommand(this.commandObjects.xautoclaimJustId(key2, group, consumerName, minIdleTime, start2, params));
    }

    @Override
    public StreamInfo xinfoStream(String key2) {
        return this.executeCommand(this.commandObjects.xinfoStream(key2));
    }

    @Override
    public StreamFullInfo xinfoStreamFull(String key2) {
        return this.executeCommand(this.commandObjects.xinfoStreamFull(key2));
    }

    @Override
    public StreamFullInfo xinfoStreamFull(String key2, int count2) {
        return this.executeCommand(this.commandObjects.xinfoStreamFull(key2, count2));
    }

    @Override
    public List<StreamGroupInfo> xinfoGroups(String key2) {
        return this.executeCommand(this.commandObjects.xinfoGroups(key2));
    }

    @Override
    public List<StreamConsumersInfo> xinfoConsumers(String key2, String group) {
        return this.executeCommand(this.commandObjects.xinfoConsumers(key2, group));
    }

    @Override
    public List<StreamConsumerInfo> xinfoConsumers2(String key2, String group) {
        return this.executeCommand(this.commandObjects.xinfoConsumers2(key2, group));
    }

    @Override
    public List<Map.Entry<String, List<StreamEntry>>> xread(XReadParams xReadParams, Map<String, StreamEntryID> streams) {
        return this.executeCommand(this.commandObjects.xread(xReadParams, streams));
    }

    @Override
    public Map<String, List<StreamEntry>> xreadAsMap(XReadParams xReadParams, Map<String, StreamEntryID> streams) {
        return this.executeCommand(this.commandObjects.xreadAsMap(xReadParams, streams));
    }

    @Override
    public List<Map.Entry<String, List<StreamEntry>>> xreadGroup(String groupName, String consumer2, XReadGroupParams xReadGroupParams, Map<String, StreamEntryID> streams) {
        return this.executeCommand(this.commandObjects.xreadGroup(groupName, consumer2, xReadGroupParams, streams));
    }

    @Override
    public Map<String, List<StreamEntry>> xreadGroupAsMap(String groupName, String consumer2, XReadGroupParams xReadGroupParams, Map<String, StreamEntryID> streams) {
        return this.executeCommand(this.commandObjects.xreadGroupAsMap(groupName, consumer2, xReadGroupParams, streams));
    }

    @Override
    public byte[] xadd(byte[] key2, XAddParams params, Map<byte[], byte[]> hash) {
        return this.executeCommand(this.commandObjects.xadd(key2, params, hash));
    }

    @Override
    public long xlen(byte[] key2) {
        return this.executeCommand(this.commandObjects.xlen(key2));
    }

    @Override
    public List<Object> xrange(byte[] key2, byte[] start2, byte[] end2) {
        return this.executeCommand(this.commandObjects.xrange(key2, start2, end2));
    }

    @Override
    public List<Object> xrange(byte[] key2, byte[] start2, byte[] end2, int count2) {
        return this.executeCommand(this.commandObjects.xrange(key2, start2, end2, count2));
    }

    @Override
    public List<Object> xrevrange(byte[] key2, byte[] end2, byte[] start2) {
        return this.executeCommand(this.commandObjects.xrevrange(key2, end2, start2));
    }

    @Override
    public List<Object> xrevrange(byte[] key2, byte[] end2, byte[] start2, int count2) {
        return this.executeCommand(this.commandObjects.xrevrange(key2, end2, start2, count2));
    }

    @Override
    public long xack(byte[] key2, byte[] group, byte[] ... ids) {
        return this.executeCommand(this.commandObjects.xack(key2, group, ids));
    }

    @Override
    public String xgroupCreate(byte[] key2, byte[] groupName, byte[] id, boolean makeStream) {
        return this.executeCommand(this.commandObjects.xgroupCreate(key2, groupName, id, makeStream));
    }

    @Override
    public String xgroupSetID(byte[] key2, byte[] groupName, byte[] id) {
        return this.executeCommand(this.commandObjects.xgroupSetID(key2, groupName, id));
    }

    @Override
    public long xgroupDestroy(byte[] key2, byte[] groupName) {
        return this.executeCommand(this.commandObjects.xgroupDestroy(key2, groupName));
    }

    @Override
    public boolean xgroupCreateConsumer(byte[] key2, byte[] groupName, byte[] consumerName) {
        return this.executeCommand(this.commandObjects.xgroupCreateConsumer(key2, groupName, consumerName));
    }

    @Override
    public long xgroupDelConsumer(byte[] key2, byte[] groupName, byte[] consumerName) {
        return this.executeCommand(this.commandObjects.xgroupDelConsumer(key2, groupName, consumerName));
    }

    @Override
    public long xdel(byte[] key2, byte[] ... ids) {
        return this.executeCommand(this.commandObjects.xdel(key2, ids));
    }

    @Override
    public long xtrim(byte[] key2, long maxLen, boolean approximateLength) {
        return this.executeCommand(this.commandObjects.xtrim(key2, maxLen, approximateLength));
    }

    @Override
    public long xtrim(byte[] key2, XTrimParams params) {
        return this.executeCommand(this.commandObjects.xtrim(key2, params));
    }

    @Override
    public Object xpending(byte[] key2, byte[] groupName) {
        return this.executeCommand(this.commandObjects.xpending(key2, groupName));
    }

    @Override
    public List<Object> xpending(byte[] key2, byte[] groupName, XPendingParams params) {
        return this.executeCommand(this.commandObjects.xpending(key2, groupName, params));
    }

    @Override
    public List<byte[]> xclaim(byte[] key2, byte[] group, byte[] consumerName, long minIdleTime, XClaimParams params, byte[] ... ids) {
        return this.executeCommand(this.commandObjects.xclaim(key2, group, consumerName, minIdleTime, params, ids));
    }

    @Override
    public List<byte[]> xclaimJustId(byte[] key2, byte[] group, byte[] consumerName, long minIdleTime, XClaimParams params, byte[] ... ids) {
        return this.executeCommand(this.commandObjects.xclaimJustId(key2, group, consumerName, minIdleTime, params, ids));
    }

    @Override
    public List<Object> xautoclaim(byte[] key2, byte[] groupName, byte[] consumerName, long minIdleTime, byte[] start2, XAutoClaimParams params) {
        return this.executeCommand(this.commandObjects.xautoclaim(key2, groupName, consumerName, minIdleTime, start2, params));
    }

    @Override
    public List<Object> xautoclaimJustId(byte[] key2, byte[] groupName, byte[] consumerName, long minIdleTime, byte[] start2, XAutoClaimParams params) {
        return this.executeCommand(this.commandObjects.xautoclaimJustId(key2, groupName, consumerName, minIdleTime, start2, params));
    }

    @Override
    public Object xinfoStream(byte[] key2) {
        return this.executeCommand(this.commandObjects.xinfoStream(key2));
    }

    @Override
    public Object xinfoStreamFull(byte[] key2) {
        return this.executeCommand(this.commandObjects.xinfoStreamFull(key2));
    }

    @Override
    public Object xinfoStreamFull(byte[] key2, int count2) {
        return this.executeCommand(this.commandObjects.xinfoStreamFull(key2, count2));
    }

    @Override
    public List<Object> xinfoGroups(byte[] key2) {
        return this.executeCommand(this.commandObjects.xinfoGroups(key2));
    }

    @Override
    public List<Object> xinfoConsumers(byte[] key2, byte[] group) {
        return this.executeCommand(this.commandObjects.xinfoConsumers(key2, group));
    }

    @Override
    public List<Object> xread(XReadParams xReadParams, Map.Entry<byte[], byte[]> ... streams) {
        return this.executeCommand(this.commandObjects.xread(xReadParams, streams));
    }

    @Override
    public List<Object> xreadGroup(byte[] groupName, byte[] consumer2, XReadGroupParams xReadGroupParams, Map.Entry<byte[], byte[]> ... streams) {
        return this.executeCommand(this.commandObjects.xreadGroup(groupName, consumer2, xReadGroupParams, streams));
    }

    @Override
    public Object eval(String script) {
        return this.executeCommand(this.commandObjects.eval(script));
    }

    @Override
    public Object eval(String script, int keyCount, String ... params) {
        return this.executeCommand(this.commandObjects.eval(script, keyCount, params));
    }

    @Override
    public Object eval(String script, List<String> keys2, List<String> args2) {
        return this.executeCommand(this.commandObjects.eval(script, keys2, args2));
    }

    @Override
    public Object evalReadonly(String script, List<String> keys2, List<String> args2) {
        return this.executeCommand(this.commandObjects.evalReadonly(script, keys2, args2));
    }

    @Override
    public Object evalsha(String sha1) {
        return this.executeCommand(this.commandObjects.evalsha(sha1));
    }

    @Override
    public Object evalsha(String sha1, int keyCount, String ... params) {
        return this.executeCommand(this.commandObjects.evalsha(sha1, keyCount, params));
    }

    @Override
    public Object evalsha(String sha1, List<String> keys2, List<String> args2) {
        return this.executeCommand(this.commandObjects.evalsha(sha1, keys2, args2));
    }

    @Override
    public Object evalshaReadonly(String sha1, List<String> keys2, List<String> args2) {
        return this.executeCommand(this.commandObjects.evalshaReadonly(sha1, keys2, args2));
    }

    @Override
    public Object eval(byte[] script) {
        return this.executeCommand(this.commandObjects.eval(script));
    }

    @Override
    public Object eval(byte[] script, int keyCount, byte[] ... params) {
        return this.executeCommand(this.commandObjects.eval(script, keyCount, params));
    }

    @Override
    public Object eval(byte[] script, List<byte[]> keys2, List<byte[]> args2) {
        return this.executeCommand(this.commandObjects.eval(script, keys2, args2));
    }

    @Override
    public Object evalReadonly(byte[] script, List<byte[]> keys2, List<byte[]> args2) {
        return this.executeCommand(this.commandObjects.evalReadonly(script, keys2, args2));
    }

    @Override
    public Object evalsha(byte[] sha1) {
        return this.executeCommand(this.commandObjects.evalsha(sha1));
    }

    @Override
    public Object evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        return this.executeCommand(this.commandObjects.evalsha(sha1, keyCount, params));
    }

    @Override
    public Object evalsha(byte[] sha1, List<byte[]> keys2, List<byte[]> args2) {
        return this.executeCommand(this.commandObjects.evalsha(sha1, keys2, args2));
    }

    @Override
    public Object evalshaReadonly(byte[] sha1, List<byte[]> keys2, List<byte[]> args2) {
        return this.executeCommand(this.commandObjects.evalshaReadonly(sha1, keys2, args2));
    }

    @Override
    public Object fcall(String name, List<String> keys2, List<String> args2) {
        return this.executeCommand(this.commandObjects.fcall(name, keys2, args2));
    }

    @Override
    public Object fcallReadonly(String name, List<String> keys2, List<String> args2) {
        return this.executeCommand(this.commandObjects.fcallReadonly(name, keys2, args2));
    }

    @Override
    public String functionDelete(String libraryName) {
        return this.checkAndBroadcastCommand(this.commandObjects.functionDelete(libraryName));
    }

    @Override
    public String functionFlush() {
        return this.checkAndBroadcastCommand(this.commandObjects.functionFlush());
    }

    @Override
    public String functionFlush(FlushMode mode) {
        return this.checkAndBroadcastCommand(this.commandObjects.functionFlush(mode));
    }

    @Override
    public String functionKill() {
        return this.checkAndBroadcastCommand(this.commandObjects.functionKill());
    }

    @Override
    public List<LibraryInfo> functionList() {
        return this.executeCommand(this.commandObjects.functionList());
    }

    @Override
    public List<LibraryInfo> functionList(String libraryNamePattern) {
        return this.executeCommand(this.commandObjects.functionList(libraryNamePattern));
    }

    @Override
    public List<LibraryInfo> functionListWithCode() {
        return this.executeCommand(this.commandObjects.functionListWithCode());
    }

    @Override
    public List<LibraryInfo> functionListWithCode(String libraryNamePattern) {
        return this.executeCommand(this.commandObjects.functionListWithCode(libraryNamePattern));
    }

    @Override
    public String functionLoad(String functionCode) {
        return this.checkAndBroadcastCommand(this.commandObjects.functionLoad(functionCode));
    }

    @Override
    public String functionLoadReplace(String functionCode) {
        return this.checkAndBroadcastCommand(this.commandObjects.functionLoadReplace(functionCode));
    }

    @Override
    public FunctionStats functionStats() {
        return this.executeCommand(this.commandObjects.functionStats());
    }

    @Override
    public Object fcall(byte[] name, List<byte[]> keys2, List<byte[]> args2) {
        return this.executeCommand(this.commandObjects.fcall(name, keys2, args2));
    }

    @Override
    public Object fcallReadonly(byte[] name, List<byte[]> keys2, List<byte[]> args2) {
        return this.executeCommand(this.commandObjects.fcallReadonly(name, keys2, args2));
    }

    @Override
    public String functionDelete(byte[] libraryName) {
        return this.checkAndBroadcastCommand(this.commandObjects.functionDelete(libraryName));
    }

    @Override
    public byte[] functionDump() {
        return this.executeCommand(this.commandObjects.functionDump());
    }

    @Override
    public List<Object> functionListBinary() {
        return this.executeCommand(this.commandObjects.functionListBinary());
    }

    @Override
    public List<Object> functionList(byte[] libraryNamePattern) {
        return this.executeCommand(this.commandObjects.functionList(libraryNamePattern));
    }

    @Override
    public List<Object> functionListWithCodeBinary() {
        return this.executeCommand(this.commandObjects.functionListWithCodeBinary());
    }

    @Override
    public List<Object> functionListWithCode(byte[] libraryNamePattern) {
        return this.executeCommand(this.commandObjects.functionListWithCode(libraryNamePattern));
    }

    @Override
    public String functionLoad(byte[] functionCode) {
        return this.checkAndBroadcastCommand(this.commandObjects.functionLoad(functionCode));
    }

    @Override
    public String functionLoadReplace(byte[] functionCode) {
        return this.checkAndBroadcastCommand(this.commandObjects.functionLoadReplace(functionCode));
    }

    @Override
    public String functionRestore(byte[] serializedValue) {
        return this.checkAndBroadcastCommand(this.commandObjects.functionRestore(serializedValue));
    }

    @Override
    public String functionRestore(byte[] serializedValue, FunctionRestorePolicy policy) {
        return this.checkAndBroadcastCommand(this.commandObjects.functionRestore(serializedValue, policy));
    }

    @Override
    public Object functionStatsBinary() {
        return this.executeCommand(this.commandObjects.functionStatsBinary());
    }

    @Override
    public Long objectRefcount(String key2) {
        return this.executeCommand(this.commandObjects.objectRefcount(key2));
    }

    @Override
    public String objectEncoding(String key2) {
        return this.executeCommand(this.commandObjects.objectEncoding(key2));
    }

    @Override
    public Long objectIdletime(String key2) {
        return this.executeCommand(this.commandObjects.objectIdletime(key2));
    }

    @Override
    public Long objectFreq(String key2) {
        return this.executeCommand(this.commandObjects.objectFreq(key2));
    }

    @Override
    public Long objectRefcount(byte[] key2) {
        return this.executeCommand(this.commandObjects.objectRefcount(key2));
    }

    @Override
    public byte[] objectEncoding(byte[] key2) {
        return this.executeCommand(this.commandObjects.objectEncoding(key2));
    }

    @Override
    public Long objectIdletime(byte[] key2) {
        return this.executeCommand(this.commandObjects.objectIdletime(key2));
    }

    @Override
    public Long objectFreq(byte[] key2) {
        return this.executeCommand(this.commandObjects.objectFreq(key2));
    }

    @Override
    public String migrate(String host2, int port2, String key2, int timeout2) {
        return this.executeCommand(this.commandObjects.migrate(host2, port2, key2, timeout2));
    }

    @Override
    public String migrate(String host2, int port2, int timeout2, MigrateParams params, String ... keys2) {
        return this.executeCommand(this.commandObjects.migrate(host2, port2, timeout2, params, keys2));
    }

    @Override
    public String migrate(String host2, int port2, byte[] key2, int timeout2) {
        return this.executeCommand(this.commandObjects.migrate(host2, port2, key2, timeout2));
    }

    @Override
    public String migrate(String host2, int port2, int timeout2, MigrateParams params, byte[] ... keys2) {
        return this.executeCommand(this.commandObjects.migrate(host2, port2, timeout2, params, keys2));
    }

    @Override
    public long waitReplicas(String sampleKey, int replicas, long timeout2) {
        return this.executeCommand(this.commandObjects.waitReplicas(sampleKey, replicas, timeout2));
    }

    @Override
    public long waitReplicas(byte[] sampleKey, int replicas, long timeout2) {
        return this.executeCommand(this.commandObjects.waitReplicas(sampleKey, replicas, timeout2));
    }

    @Override
    public KeyValue<Long, Long> waitAOF(String sampleKey, long numLocal, long numReplicas, long timeout2) {
        return this.executeCommand(this.commandObjects.waitAOF(sampleKey, numLocal, numReplicas, timeout2));
    }

    @Override
    public KeyValue<Long, Long> waitAOF(byte[] sampleKey, long numLocal, long numReplicas, long timeout2) {
        return this.executeCommand(this.commandObjects.waitAOF(sampleKey, numLocal, numReplicas, timeout2));
    }

    @Override
    public Object eval(String script, String sampleKey) {
        return this.executeCommand(this.commandObjects.eval(script, sampleKey));
    }

    @Override
    public Object evalsha(String sha1, String sampleKey) {
        return this.executeCommand(this.commandObjects.evalsha(sha1, sampleKey));
    }

    @Override
    public Object eval(byte[] script, byte[] sampleKey) {
        return this.executeCommand(this.commandObjects.eval(script, sampleKey));
    }

    @Override
    public Object evalsha(byte[] sha1, byte[] sampleKey) {
        return this.executeCommand(this.commandObjects.evalsha(sha1, sampleKey));
    }

    public List<Boolean> scriptExists(List<String> sha1s) {
        return this.checkAndBroadcastCommand(this.commandObjects.scriptExists(sha1s));
    }

    @Override
    public Boolean scriptExists(String sha1, String sampleKey) {
        return this.scriptExists(sampleKey, new String[]{sha1}).get(0);
    }

    @Override
    public List<Boolean> scriptExists(String sampleKey, String ... sha1s) {
        return this.executeCommand(this.commandObjects.scriptExists(sampleKey, sha1s));
    }

    @Override
    public Boolean scriptExists(byte[] sha1, byte[] sampleKey) {
        return this.scriptExists(sampleKey, new byte[][]{sha1}).get(0);
    }

    @Override
    public List<Boolean> scriptExists(byte[] sampleKey, byte[] ... sha1s) {
        return this.executeCommand(this.commandObjects.scriptExists(sampleKey, sha1s));
    }

    public String scriptLoad(String script) {
        return this.checkAndBroadcastCommand(this.commandObjects.scriptLoad(script));
    }

    @Override
    public String scriptLoad(String script, String sampleKey) {
        return this.executeCommand(this.commandObjects.scriptLoad(script, sampleKey));
    }

    public String scriptFlush() {
        return this.checkAndBroadcastCommand(this.commandObjects.scriptFlush());
    }

    @Override
    public String scriptFlush(String sampleKey) {
        return this.executeCommand(this.commandObjects.scriptFlush(sampleKey));
    }

    @Override
    public String scriptFlush(String sampleKey, FlushMode flushMode) {
        return this.executeCommand(this.commandObjects.scriptFlush(sampleKey, flushMode));
    }

    public String scriptKill() {
        return this.checkAndBroadcastCommand(this.commandObjects.scriptKill());
    }

    @Override
    public String scriptKill(String sampleKey) {
        return this.executeCommand(this.commandObjects.scriptKill(sampleKey));
    }

    @Override
    public byte[] scriptLoad(byte[] script, byte[] sampleKey) {
        return this.executeCommand(this.commandObjects.scriptLoad(script, sampleKey));
    }

    @Override
    public String scriptFlush(byte[] sampleKey) {
        return this.executeCommand(this.commandObjects.scriptFlush(sampleKey));
    }

    @Override
    public String scriptFlush(byte[] sampleKey, FlushMode flushMode) {
        return this.executeCommand(this.commandObjects.scriptFlush(sampleKey, flushMode));
    }

    @Override
    public String scriptKill(byte[] sampleKey) {
        return this.executeCommand(this.commandObjects.scriptKill(sampleKey));
    }

    public String slowlogReset() {
        return this.checkAndBroadcastCommand(this.commandObjects.slowlogReset());
    }

    public long publish(String channel2, String message) {
        return this.executeCommand(this.commandObjects.publish(channel2, message));
    }

    public long publish(byte[] channel2, byte[] message) {
        return this.executeCommand(this.commandObjects.publish(channel2, message));
    }

    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        try (Connection connection = this.provider.getConnection();){
            jedisPubSub.proceed(connection, channels);
        }
    }

    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns2) {
        try (Connection connection = this.provider.getConnection();){
            jedisPubSub.proceedWithPatterns(connection, patterns2);
        }
    }

    public void subscribe(BinaryJedisPubSub jedisPubSub, byte[] ... channels) {
        try (Connection connection = this.provider.getConnection();){
            jedisPubSub.proceed(connection, (T[])channels);
        }
    }

    public void psubscribe(BinaryJedisPubSub jedisPubSub, byte[] ... patterns2) {
        try (Connection connection = this.provider.getConnection();){
            jedisPubSub.proceedWithPatterns(connection, (T[])patterns2);
        }
    }

    public long hsetObject(String key2, String field, Object value2) {
        return this.executeCommand(this.commandObjects.hsetObject(key2, field, value2));
    }

    public long hsetObject(String key2, Map<String, Object> hash) {
        return this.executeCommand(this.commandObjects.hsetObject(key2, hash));
    }

    @Override
    public String ftCreate(String indexName, IndexOptions indexOptions, Schema schema) {
        return this.checkAndBroadcastCommand(this.commandObjects.ftCreate(indexName, indexOptions, schema));
    }

    @Override
    public String ftCreate(String indexName, FTCreateParams createParams, Iterable<SchemaField> schemaFields) {
        return this.checkAndBroadcastCommand(this.commandObjects.ftCreate(indexName, createParams, schemaFields));
    }

    @Override
    public String ftAlter(String indexName, Schema schema) {
        return this.checkAndBroadcastCommand(this.commandObjects.ftAlter(indexName, schema));
    }

    @Override
    public String ftAlter(String indexName, Iterable<SchemaField> schemaFields) {
        return this.checkAndBroadcastCommand(this.commandObjects.ftAlter(indexName, schemaFields));
    }

    @Override
    public String ftAliasAdd(String aliasName, String indexName) {
        return this.checkAndBroadcastCommand(this.commandObjects.ftAliasAdd(aliasName, indexName));
    }

    @Override
    public String ftAliasUpdate(String aliasName, String indexName) {
        return this.checkAndBroadcastCommand(this.commandObjects.ftAliasUpdate(aliasName, indexName));
    }

    @Override
    public String ftAliasDel(String aliasName) {
        return this.checkAndBroadcastCommand(this.commandObjects.ftAliasDel(aliasName));
    }

    @Override
    public String ftDropIndex(String indexName) {
        return this.checkAndBroadcastCommand(this.commandObjects.ftDropIndex(indexName));
    }

    @Override
    public String ftDropIndexDD(String indexName) {
        return this.checkAndBroadcastCommand(this.commandObjects.ftDropIndexDD(indexName));
    }

    @Override
    public SearchResult ftSearch(String indexName, String query2) {
        return this.executeCommand(this.commandObjects.ftSearch(indexName, query2));
    }

    @Override
    public SearchResult ftSearch(String indexName, String query2, FTSearchParams params) {
        return this.executeCommand(this.commandObjects.ftSearch(indexName, query2, params));
    }

    public FtSearchIteration ftSearchIteration(int batchSize, String indexName, String query2, FTSearchParams params) {
        return new FtSearchIteration(this.provider, this.commandObjects.getProtocol(), batchSize, indexName, query2, params);
    }

    @Override
    public SearchResult ftSearch(String indexName, Query query2) {
        return this.executeCommand(this.commandObjects.ftSearch(indexName, query2));
    }

    public FtSearchIteration ftSearchIteration(int batchSize, String indexName, Query query2) {
        return new FtSearchIteration(this.provider, this.commandObjects.getProtocol(), batchSize, indexName, query2);
    }

    @Override
    @Deprecated
    public SearchResult ftSearch(byte[] indexName, Query query2) {
        return this.executeCommand(this.commandObjects.ftSearch(indexName, query2));
    }

    @Override
    public String ftExplain(String indexName, Query query2) {
        return this.executeCommand(this.commandObjects.ftExplain(indexName, query2));
    }

    @Override
    public List<String> ftExplainCLI(String indexName, Query query2) {
        return this.executeCommand(this.commandObjects.ftExplainCLI(indexName, query2));
    }

    @Override
    public AggregationResult ftAggregate(String indexName, AggregationBuilder aggr) {
        return this.executeCommand(this.commandObjects.ftAggregate(indexName, aggr));
    }

    @Override
    public AggregationResult ftCursorRead(String indexName, long cursorId, int count2) {
        return this.executeCommand(this.commandObjects.ftCursorRead(indexName, cursorId, count2));
    }

    @Override
    public String ftCursorDel(String indexName, long cursorId) {
        return this.executeCommand(this.commandObjects.ftCursorDel(indexName, cursorId));
    }

    public FtAggregateIteration ftAggregateIteration(String indexName, AggregationBuilder aggr) {
        return new FtAggregateIteration(this.provider, indexName, aggr);
    }

    @Override
    public Map.Entry<AggregationResult, Map<String, Object>> ftProfileAggregate(String indexName, FTProfileParams profileParams, AggregationBuilder aggr) {
        return this.executeCommand(this.commandObjects.ftProfileAggregate(indexName, profileParams, aggr));
    }

    @Override
    public Map.Entry<SearchResult, Map<String, Object>> ftProfileSearch(String indexName, FTProfileParams profileParams, Query query2) {
        return this.executeCommand(this.commandObjects.ftProfileSearch(indexName, profileParams, query2));
    }

    @Override
    public Map.Entry<SearchResult, Map<String, Object>> ftProfileSearch(String indexName, FTProfileParams profileParams, String query2, FTSearchParams searchParams) {
        return this.executeCommand(this.commandObjects.ftProfileSearch(indexName, profileParams, query2, searchParams));
    }

    @Override
    public String ftSynUpdate(String indexName, String synonymGroupId, String ... terms) {
        return this.executeCommand(this.commandObjects.ftSynUpdate(indexName, synonymGroupId, terms));
    }

    @Override
    public Map<String, List<String>> ftSynDump(String indexName) {
        return this.executeCommand(this.commandObjects.ftSynDump(indexName));
    }

    @Override
    public long ftDictAdd(String dictionary, String ... terms) {
        return this.executeCommand(this.commandObjects.ftDictAdd(dictionary, terms));
    }

    @Override
    public long ftDictDel(String dictionary, String ... terms) {
        return this.executeCommand(this.commandObjects.ftDictDel(dictionary, terms));
    }

    @Override
    public Set<String> ftDictDump(String dictionary) {
        return this.executeCommand(this.commandObjects.ftDictDump(dictionary));
    }

    @Override
    public long ftDictAddBySampleKey(String indexName, String dictionary, String ... terms) {
        return this.executeCommand(this.commandObjects.ftDictAddBySampleKey(indexName, dictionary, terms));
    }

    @Override
    public long ftDictDelBySampleKey(String indexName, String dictionary, String ... terms) {
        return this.executeCommand(this.commandObjects.ftDictDelBySampleKey(indexName, dictionary, terms));
    }

    @Override
    public Set<String> ftDictDumpBySampleKey(String indexName, String dictionary) {
        return this.executeCommand(this.commandObjects.ftDictDumpBySampleKey(indexName, dictionary));
    }

    @Override
    public Map<String, Map<String, Double>> ftSpellCheck(String index, String query2) {
        return this.executeCommand(this.commandObjects.ftSpellCheck(index, query2));
    }

    @Override
    public Map<String, Map<String, Double>> ftSpellCheck(String index, String query2, FTSpellCheckParams spellCheckParams) {
        return this.executeCommand(this.commandObjects.ftSpellCheck(index, query2, spellCheckParams));
    }

    @Override
    public Map<String, Object> ftInfo(String indexName) {
        return this.executeCommand(this.commandObjects.ftInfo(indexName));
    }

    @Override
    public Set<String> ftTagVals(String indexName, String fieldName) {
        return this.executeCommand(this.commandObjects.ftTagVals(indexName, fieldName));
    }

    @Override
    public Map<String, Object> ftConfigGet(String option) {
        return this.executeCommand(this.commandObjects.ftConfigGet(option));
    }

    @Override
    public Map<String, Object> ftConfigGet(String indexName, String option) {
        return this.executeCommand(this.commandObjects.ftConfigGet(indexName, option));
    }

    @Override
    public String ftConfigSet(String option, String value2) {
        return this.executeCommand(this.commandObjects.ftConfigSet(option, value2));
    }

    @Override
    public String ftConfigSet(String indexName, String option, String value2) {
        return this.executeCommand(this.commandObjects.ftConfigSet(indexName, option, value2));
    }

    @Override
    public long ftSugAdd(String key2, String string, double score) {
        return this.executeCommand(this.commandObjects.ftSugAdd(key2, string, score));
    }

    @Override
    public long ftSugAddIncr(String key2, String string, double score) {
        return this.executeCommand(this.commandObjects.ftSugAddIncr(key2, string, score));
    }

    @Override
    public List<String> ftSugGet(String key2, String prefix2) {
        return this.executeCommand(this.commandObjects.ftSugGet(key2, prefix2));
    }

    @Override
    public List<String> ftSugGet(String key2, String prefix2, boolean fuzzy, int max2) {
        return this.executeCommand(this.commandObjects.ftSugGet(key2, prefix2, fuzzy, max2));
    }

    @Override
    public List<Tuple> ftSugGetWithScores(String key2, String prefix2) {
        return this.executeCommand(this.commandObjects.ftSugGetWithScores(key2, prefix2));
    }

    @Override
    public List<Tuple> ftSugGetWithScores(String key2, String prefix2, boolean fuzzy, int max2) {
        return this.executeCommand(this.commandObjects.ftSugGetWithScores(key2, prefix2, fuzzy, max2));
    }

    @Override
    public boolean ftSugDel(String key2, String string) {
        return this.executeCommand(this.commandObjects.ftSugDel(key2, string));
    }

    @Override
    public long ftSugLen(String key2) {
        return this.executeCommand(this.commandObjects.ftSugLen(key2));
    }

    @Override
    public Set<String> ftList() {
        return this.executeCommand(this.commandObjects.ftList());
    }

    @Override
    public String jsonSet(String key2, Path2 path2, Object object) {
        return this.executeCommand(this.commandObjects.jsonSet(key2, path2, object));
    }

    @Override
    public String jsonSetWithEscape(String key2, Path2 path2, Object object) {
        return this.executeCommand(this.commandObjects.jsonSetWithEscape(key2, path2, object));
    }

    @Override
    @Deprecated
    public String jsonSet(String key2, Path path2, Object pojo) {
        return this.executeCommand(this.commandObjects.jsonSet(key2, path2, pojo));
    }

    @Override
    @Deprecated
    public String jsonSetWithPlainString(String key2, Path path2, String string) {
        return this.executeCommand(this.commandObjects.jsonSetWithPlainString(key2, path2, string));
    }

    @Override
    public String jsonSet(String key2, Path2 path2, Object pojo, JsonSetParams params) {
        return this.executeCommand(this.commandObjects.jsonSet(key2, path2, pojo, params));
    }

    @Override
    public String jsonSetWithEscape(String key2, Path2 path2, Object pojo, JsonSetParams params) {
        return this.executeCommand(this.commandObjects.jsonSetWithEscape(key2, path2, pojo, params));
    }

    @Override
    @Deprecated
    public String jsonSet(String key2, Path path2, Object pojo, JsonSetParams params) {
        return this.executeCommand(this.commandObjects.jsonSet(key2, path2, pojo, params));
    }

    @Override
    public String jsonMerge(String key2, Path2 path2, Object object) {
        return this.executeCommand(this.commandObjects.jsonMerge(key2, path2, object));
    }

    @Override
    @Deprecated
    public String jsonMerge(String key2, Path path2, Object pojo) {
        return this.executeCommand(this.commandObjects.jsonMerge(key2, path2, pojo));
    }

    @Override
    public Object jsonGet(String key2) {
        return this.executeCommand(this.commandObjects.jsonGet(key2));
    }

    @Override
    @Deprecated
    public <T> T jsonGet(String key2, Class<T> clazz) {
        return this.executeCommand(this.commandObjects.jsonGet(key2, clazz));
    }

    @Override
    public Object jsonGet(String key2, Path2 ... paths) {
        return this.executeCommand(this.commandObjects.jsonGet(key2, paths));
    }

    @Override
    @Deprecated
    public Object jsonGet(String key2, Path ... paths) {
        return this.executeCommand(this.commandObjects.jsonGet(key2, paths));
    }

    @Override
    @Deprecated
    public String jsonGetAsPlainString(String key2, Path path2) {
        return this.executeCommand(this.commandObjects.jsonGetAsPlainString(key2, path2));
    }

    @Override
    @Deprecated
    public <T> T jsonGet(String key2, Class<T> clazz, Path ... paths) {
        return this.executeCommand(this.commandObjects.jsonGet(key2, clazz, paths));
    }

    @Override
    public List<JSONArray> jsonMGet(Path2 path2, String ... keys2) {
        return this.executeCommand(this.commandObjects.jsonMGet(path2, keys2));
    }

    @Override
    @Deprecated
    public <T> List<T> jsonMGet(Path path2, Class<T> clazz, String ... keys2) {
        return this.executeCommand(this.commandObjects.jsonMGet(path2, clazz, keys2));
    }

    @Override
    public long jsonDel(String key2) {
        return this.executeCommand(this.commandObjects.jsonDel(key2));
    }

    @Override
    public long jsonDel(String key2, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonDel(key2, path2));
    }

    @Override
    @Deprecated
    public long jsonDel(String key2, Path path2) {
        return this.executeCommand(this.commandObjects.jsonDel(key2, path2));
    }

    @Override
    public long jsonClear(String key2) {
        return this.executeCommand(this.commandObjects.jsonClear(key2));
    }

    @Override
    public long jsonClear(String key2, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonClear(key2, path2));
    }

    @Override
    @Deprecated
    public long jsonClear(String key2, Path path2) {
        return this.executeCommand(this.commandObjects.jsonClear(key2, path2));
    }

    @Override
    public List<Boolean> jsonToggle(String key2, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonToggle(key2, path2));
    }

    @Override
    @Deprecated
    public String jsonToggle(String key2, Path path2) {
        return this.executeCommand(this.commandObjects.jsonToggle(key2, path2));
    }

    @Override
    @Deprecated
    public Class<?> jsonType(String key2) {
        return this.executeCommand(this.commandObjects.jsonType(key2));
    }

    @Override
    public List<Class<?>> jsonType(String key2, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonType(key2, path2));
    }

    @Override
    @Deprecated
    public Class<?> jsonType(String key2, Path path2) {
        return this.executeCommand(this.commandObjects.jsonType(key2, path2));
    }

    @Override
    @Deprecated
    public long jsonStrAppend(String key2, Object string) {
        return this.executeCommand(this.commandObjects.jsonStrAppend(key2, string));
    }

    @Override
    public List<Long> jsonStrAppend(String key2, Path2 path2, Object string) {
        return this.executeCommand(this.commandObjects.jsonStrAppend(key2, path2, string));
    }

    @Override
    @Deprecated
    public long jsonStrAppend(String key2, Path path2, Object string) {
        return this.executeCommand(this.commandObjects.jsonStrAppend(key2, path2, string));
    }

    @Override
    @Deprecated
    public Long jsonStrLen(String key2) {
        return this.executeCommand(this.commandObjects.jsonStrLen(key2));
    }

    @Override
    public List<Long> jsonStrLen(String key2, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonStrLen(key2, path2));
    }

    @Override
    @Deprecated
    public Long jsonStrLen(String key2, Path path2) {
        return this.executeCommand(this.commandObjects.jsonStrLen(key2, path2));
    }

    @Override
    public Object jsonNumIncrBy(String key2, Path2 path2, double value2) {
        return this.executeCommand(this.commandObjects.jsonNumIncrBy(key2, path2, value2));
    }

    @Override
    @Deprecated
    public double jsonNumIncrBy(String key2, Path path2, double value2) {
        return this.executeCommand(this.commandObjects.jsonNumIncrBy(key2, path2, value2));
    }

    @Override
    public List<Long> jsonArrAppend(String key2, Path2 path2, Object ... objects) {
        return this.executeCommand(this.commandObjects.jsonArrAppend(key2, path2, objects));
    }

    @Override
    public List<Long> jsonArrAppendWithEscape(String key2, Path2 path2, Object ... objects) {
        return this.executeCommand(this.commandObjects.jsonArrAppendWithEscape(key2, path2, objects));
    }

    @Override
    @Deprecated
    public Long jsonArrAppend(String key2, Path path2, Object ... pojos) {
        return this.executeCommand(this.commandObjects.jsonArrAppend(key2, path2, pojos));
    }

    @Override
    public List<Long> jsonArrIndex(String key2, Path2 path2, Object scalar) {
        return this.executeCommand(this.commandObjects.jsonArrIndex(key2, path2, scalar));
    }

    @Override
    public List<Long> jsonArrIndexWithEscape(String key2, Path2 path2, Object scalar) {
        return this.executeCommand(this.commandObjects.jsonArrIndexWithEscape(key2, path2, scalar));
    }

    @Override
    @Deprecated
    public long jsonArrIndex(String key2, Path path2, Object scalar) {
        return this.executeCommand(this.commandObjects.jsonArrIndex(key2, path2, scalar));
    }

    @Override
    public List<Long> jsonArrInsert(String key2, Path2 path2, int index, Object ... objects) {
        return this.executeCommand(this.commandObjects.jsonArrInsert(key2, path2, index, objects));
    }

    @Override
    public List<Long> jsonArrInsertWithEscape(String key2, Path2 path2, int index, Object ... objects) {
        return this.executeCommand(this.commandObjects.jsonArrInsertWithEscape(key2, path2, index, objects));
    }

    @Override
    @Deprecated
    public long jsonArrInsert(String key2, Path path2, int index, Object ... pojos) {
        return this.executeCommand(this.commandObjects.jsonArrInsert(key2, path2, index, pojos));
    }

    @Override
    @Deprecated
    public Object jsonArrPop(String key2) {
        return this.executeCommand(this.commandObjects.jsonArrPop(key2));
    }

    @Override
    @Deprecated
    public <T> T jsonArrPop(String key2, Class<T> clazz) {
        return this.executeCommand(this.commandObjects.jsonArrPop(key2, clazz));
    }

    @Override
    public List<Object> jsonArrPop(String key2, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonArrPop(key2, path2));
    }

    @Override
    @Deprecated
    public Object jsonArrPop(String key2, Path path2) {
        return this.executeCommand(this.commandObjects.jsonArrPop(key2, path2));
    }

    @Override
    @Deprecated
    public <T> T jsonArrPop(String key2, Class<T> clazz, Path path2) {
        return this.executeCommand(this.commandObjects.jsonArrPop(key2, clazz, path2));
    }

    @Override
    public List<Object> jsonArrPop(String key2, Path2 path2, int index) {
        return this.executeCommand(this.commandObjects.jsonArrPop(key2, path2, index));
    }

    @Override
    @Deprecated
    public Object jsonArrPop(String key2, Path path2, int index) {
        return this.executeCommand(this.commandObjects.jsonArrPop(key2, path2, index));
    }

    @Override
    @Deprecated
    public <T> T jsonArrPop(String key2, Class<T> clazz, Path path2, int index) {
        return this.executeCommand(this.commandObjects.jsonArrPop(key2, clazz, path2, index));
    }

    @Override
    @Deprecated
    public Long jsonArrLen(String key2) {
        return this.executeCommand(this.commandObjects.jsonArrLen(key2));
    }

    @Override
    public List<Long> jsonArrLen(String key2, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonArrLen(key2, path2));
    }

    @Override
    @Deprecated
    public Long jsonArrLen(String key2, Path path2) {
        return this.executeCommand(this.commandObjects.jsonArrLen(key2, path2));
    }

    @Override
    public List<Long> jsonArrTrim(String key2, Path2 path2, int start2, int stop) {
        return this.executeCommand(this.commandObjects.jsonArrTrim(key2, path2, start2, stop));
    }

    @Override
    @Deprecated
    public Long jsonArrTrim(String key2, Path path2, int start2, int stop) {
        return this.executeCommand(this.commandObjects.jsonArrTrim(key2, path2, start2, stop));
    }

    @Override
    @Deprecated
    public Long jsonObjLen(String key2) {
        return this.executeCommand(this.commandObjects.jsonObjLen(key2));
    }

    @Override
    @Deprecated
    public Long jsonObjLen(String key2, Path path2) {
        return this.executeCommand(this.commandObjects.jsonObjLen(key2, path2));
    }

    @Override
    public List<Long> jsonObjLen(String key2, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonObjLen(key2, path2));
    }

    @Override
    @Deprecated
    public List<String> jsonObjKeys(String key2) {
        return this.executeCommand(this.commandObjects.jsonObjKeys(key2));
    }

    @Override
    @Deprecated
    public List<String> jsonObjKeys(String key2, Path path2) {
        return this.executeCommand(this.commandObjects.jsonObjKeys(key2, path2));
    }

    @Override
    public List<List<String>> jsonObjKeys(String key2, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonObjKeys(key2, path2));
    }

    @Override
    @Deprecated
    public long jsonDebugMemory(String key2) {
        return this.executeCommand(this.commandObjects.jsonDebugMemory(key2));
    }

    @Override
    @Deprecated
    public long jsonDebugMemory(String key2, Path path2) {
        return this.executeCommand(this.commandObjects.jsonDebugMemory(key2, path2));
    }

    @Override
    public List<Long> jsonDebugMemory(String key2, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonDebugMemory(key2, path2));
    }

    @Override
    public String tsCreate(String key2) {
        return this.executeCommand(this.commandObjects.tsCreate(key2));
    }

    @Override
    public String tsCreate(String key2, TSCreateParams createParams) {
        return this.executeCommand(this.commandObjects.tsCreate(key2, createParams));
    }

    @Override
    public long tsDel(String key2, long fromTimestamp, long toTimestamp) {
        return this.executeCommand(this.commandObjects.tsDel(key2, fromTimestamp, toTimestamp));
    }

    @Override
    public String tsAlter(String key2, TSAlterParams alterParams) {
        return this.executeCommand(this.commandObjects.tsAlter(key2, alterParams));
    }

    @Override
    public long tsAdd(String key2, double value2) {
        return this.executeCommand(this.commandObjects.tsAdd(key2, value2));
    }

    @Override
    public long tsAdd(String key2, long timestamp, double value2) {
        return this.executeCommand(this.commandObjects.tsAdd(key2, timestamp, value2));
    }

    @Override
    public long tsAdd(String key2, long timestamp, double value2, TSCreateParams createParams) {
        return this.executeCommand(this.commandObjects.tsAdd(key2, timestamp, value2, createParams));
    }

    @Override
    public long tsAdd(String key2, long timestamp, double value2, TSAddParams addParams) {
        return this.executeCommand(this.commandObjects.tsAdd(key2, timestamp, value2, addParams));
    }

    @Override
    public List<Long> tsMAdd(Map.Entry<String, TSElement> ... entries2) {
        return this.executeCommand(this.commandObjects.tsMAdd(entries2));
    }

    @Override
    public long tsIncrBy(String key2, double value2) {
        return this.executeCommand(this.commandObjects.tsIncrBy(key2, value2));
    }

    @Override
    public long tsIncrBy(String key2, double value2, long timestamp) {
        return this.executeCommand(this.commandObjects.tsIncrBy(key2, value2, timestamp));
    }

    @Override
    public long tsIncrBy(String key2, double addend, TSIncrByParams incrByParams) {
        return this.executeCommand(this.commandObjects.tsIncrBy(key2, addend, incrByParams));
    }

    @Override
    public long tsDecrBy(String key2, double value2) {
        return this.executeCommand(this.commandObjects.tsDecrBy(key2, value2));
    }

    @Override
    public long tsDecrBy(String key2, double value2, long timestamp) {
        return this.executeCommand(this.commandObjects.tsDecrBy(key2, value2, timestamp));
    }

    @Override
    public long tsDecrBy(String key2, double subtrahend, TSDecrByParams decrByParams) {
        return this.executeCommand(this.commandObjects.tsDecrBy(key2, subtrahend, decrByParams));
    }

    @Override
    public List<TSElement> tsRange(String key2, long fromTimestamp, long toTimestamp) {
        return this.executeCommand(this.commandObjects.tsRange(key2, fromTimestamp, toTimestamp));
    }

    @Override
    public List<TSElement> tsRange(String key2, TSRangeParams rangeParams) {
        return this.executeCommand(this.commandObjects.tsRange(key2, rangeParams));
    }

    @Override
    public List<TSElement> tsRevRange(String key2, long fromTimestamp, long toTimestamp) {
        return this.executeCommand(this.commandObjects.tsRevRange(key2, fromTimestamp, toTimestamp));
    }

    @Override
    public List<TSElement> tsRevRange(String key2, TSRangeParams rangeParams) {
        return this.executeCommand(this.commandObjects.tsRevRange(key2, rangeParams));
    }

    @Override
    public Map<String, TSMRangeElements> tsMRange(long fromTimestamp, long toTimestamp, String ... filters) {
        return this.executeCommand(this.commandObjects.tsMRange(fromTimestamp, toTimestamp, filters));
    }

    @Override
    public Map<String, TSMRangeElements> tsMRange(TSMRangeParams multiRangeParams) {
        return this.executeCommand(this.commandObjects.tsMRange(multiRangeParams));
    }

    @Override
    public Map<String, TSMRangeElements> tsMRevRange(long fromTimestamp, long toTimestamp, String ... filters) {
        return this.executeCommand(this.commandObjects.tsMRevRange(fromTimestamp, toTimestamp, filters));
    }

    @Override
    public Map<String, TSMRangeElements> tsMRevRange(TSMRangeParams multiRangeParams) {
        return this.executeCommand(this.commandObjects.tsMRevRange(multiRangeParams));
    }

    @Override
    public TSElement tsGet(String key2) {
        return this.executeCommand(this.commandObjects.tsGet(key2));
    }

    @Override
    public TSElement tsGet(String key2, TSGetParams getParams) {
        return this.executeCommand(this.commandObjects.tsGet(key2, getParams));
    }

    @Override
    public Map<String, TSMGetElement> tsMGet(TSMGetParams multiGetParams, String ... filters) {
        return this.executeCommand(this.commandObjects.tsMGet(multiGetParams, filters));
    }

    @Override
    public String tsCreateRule(String sourceKey, String destKey, AggregationType aggregationType, long timeBucket) {
        return this.executeCommand(this.commandObjects.tsCreateRule(sourceKey, destKey, aggregationType, timeBucket));
    }

    @Override
    public String tsCreateRule(String sourceKey, String destKey, AggregationType aggregationType, long bucketDuration, long alignTimestamp) {
        return this.executeCommand(this.commandObjects.tsCreateRule(sourceKey, destKey, aggregationType, bucketDuration, alignTimestamp));
    }

    @Override
    public String tsDeleteRule(String sourceKey, String destKey) {
        return this.executeCommand(this.commandObjects.tsDeleteRule(sourceKey, destKey));
    }

    @Override
    public List<String> tsQueryIndex(String ... filters) {
        return this.executeCommand(this.commandObjects.tsQueryIndex(filters));
    }

    @Override
    public TSInfo tsInfo(String key2) {
        return this.executeCommand(this.commandObjects.tsInfo(key2));
    }

    @Override
    public TSInfo tsInfoDebug(String key2) {
        return this.executeCommand(this.commandObjects.tsInfoDebug(key2));
    }

    @Override
    public String bfReserve(String key2, double errorRate, long capacity) {
        return this.executeCommand(this.commandObjects.bfReserve(key2, errorRate, capacity));
    }

    @Override
    public String bfReserve(String key2, double errorRate, long capacity, BFReserveParams reserveParams) {
        return this.executeCommand(this.commandObjects.bfReserve(key2, errorRate, capacity, reserveParams));
    }

    @Override
    public boolean bfAdd(String key2, String item) {
        return this.executeCommand(this.commandObjects.bfAdd(key2, item));
    }

    @Override
    public List<Boolean> bfMAdd(String key2, String ... items2) {
        return this.executeCommand(this.commandObjects.bfMAdd(key2, items2));
    }

    @Override
    public List<Boolean> bfInsert(String key2, String ... items2) {
        return this.executeCommand(this.commandObjects.bfInsert(key2, items2));
    }

    @Override
    public List<Boolean> bfInsert(String key2, BFInsertParams insertParams, String ... items2) {
        return this.executeCommand(this.commandObjects.bfInsert(key2, insertParams, items2));
    }

    @Override
    public boolean bfExists(String key2, String item) {
        return this.executeCommand(this.commandObjects.bfExists(key2, item));
    }

    @Override
    public List<Boolean> bfMExists(String key2, String ... items2) {
        return this.executeCommand(this.commandObjects.bfMExists(key2, items2));
    }

    @Override
    public Map.Entry<Long, byte[]> bfScanDump(String key2, long iterator2) {
        return this.executeCommand(this.commandObjects.bfScanDump(key2, iterator2));
    }

    @Override
    public String bfLoadChunk(String key2, long iterator2, byte[] data2) {
        return this.executeCommand(this.commandObjects.bfLoadChunk(key2, iterator2, data2));
    }

    @Override
    public long bfCard(String key2) {
        return this.executeCommand(this.commandObjects.bfCard(key2));
    }

    @Override
    public Map<String, Object> bfInfo(String key2) {
        return this.executeCommand(this.commandObjects.bfInfo(key2));
    }

    @Override
    public String cfReserve(String key2, long capacity) {
        return this.executeCommand(this.commandObjects.cfReserve(key2, capacity));
    }

    @Override
    public String cfReserve(String key2, long capacity, CFReserveParams reserveParams) {
        return this.executeCommand(this.commandObjects.cfReserve(key2, capacity, reserveParams));
    }

    @Override
    public boolean cfAdd(String key2, String item) {
        return this.executeCommand(this.commandObjects.cfAdd(key2, item));
    }

    @Override
    public boolean cfAddNx(String key2, String item) {
        return this.executeCommand(this.commandObjects.cfAddNx(key2, item));
    }

    @Override
    public List<Boolean> cfInsert(String key2, String ... items2) {
        return this.executeCommand(this.commandObjects.cfInsert(key2, items2));
    }

    @Override
    public List<Boolean> cfInsert(String key2, CFInsertParams insertParams, String ... items2) {
        return this.executeCommand(this.commandObjects.cfInsert(key2, insertParams, items2));
    }

    @Override
    public List<Boolean> cfInsertNx(String key2, String ... items2) {
        return this.executeCommand(this.commandObjects.cfInsertNx(key2, items2));
    }

    @Override
    public List<Boolean> cfInsertNx(String key2, CFInsertParams insertParams, String ... items2) {
        return this.executeCommand(this.commandObjects.cfInsertNx(key2, insertParams, items2));
    }

    @Override
    public boolean cfExists(String key2, String item) {
        return this.executeCommand(this.commandObjects.cfExists(key2, item));
    }

    @Override
    public List<Boolean> cfMExists(String key2, String ... items2) {
        return this.executeCommand(this.commandObjects.cfMExists(key2, items2));
    }

    @Override
    public boolean cfDel(String key2, String item) {
        return this.executeCommand(this.commandObjects.cfDel(key2, item));
    }

    @Override
    public long cfCount(String key2, String item) {
        return this.executeCommand(this.commandObjects.cfCount(key2, item));
    }

    @Override
    public Map.Entry<Long, byte[]> cfScanDump(String key2, long iterator2) {
        return this.executeCommand(this.commandObjects.cfScanDump(key2, iterator2));
    }

    @Override
    public String cfLoadChunk(String key2, long iterator2, byte[] data2) {
        return this.executeCommand(this.commandObjects.cfLoadChunk(key2, iterator2, data2));
    }

    @Override
    public Map<String, Object> cfInfo(String key2) {
        return this.executeCommand(this.commandObjects.cfInfo(key2));
    }

    @Override
    public String cmsInitByDim(String key2, long width, long depth) {
        return this.executeCommand(this.commandObjects.cmsInitByDim(key2, width, depth));
    }

    @Override
    public String cmsInitByProb(String key2, double error2, double probability) {
        return this.executeCommand(this.commandObjects.cmsInitByProb(key2, error2, probability));
    }

    @Override
    public List<Long> cmsIncrBy(String key2, Map<String, Long> itemIncrements) {
        return this.executeCommand(this.commandObjects.cmsIncrBy(key2, itemIncrements));
    }

    @Override
    public List<Long> cmsQuery(String key2, String ... items2) {
        return this.executeCommand(this.commandObjects.cmsQuery(key2, items2));
    }

    @Override
    public String cmsMerge(String destKey, String ... keys2) {
        return this.executeCommand(this.commandObjects.cmsMerge(destKey, keys2));
    }

    @Override
    public String cmsMerge(String destKey, Map<String, Long> keysAndWeights) {
        return this.executeCommand(this.commandObjects.cmsMerge(destKey, keysAndWeights));
    }

    @Override
    public Map<String, Object> cmsInfo(String key2) {
        return this.executeCommand(this.commandObjects.cmsInfo(key2));
    }

    @Override
    public String topkReserve(String key2, long topk) {
        return this.executeCommand(this.commandObjects.topkReserve(key2, topk));
    }

    @Override
    public String topkReserve(String key2, long topk, long width, long depth, double decay) {
        return this.executeCommand(this.commandObjects.topkReserve(key2, topk, width, depth, decay));
    }

    @Override
    public List<String> topkAdd(String key2, String ... items2) {
        return this.executeCommand(this.commandObjects.topkAdd(key2, items2));
    }

    @Override
    public List<String> topkIncrBy(String key2, Map<String, Long> itemIncrements) {
        return this.executeCommand(this.commandObjects.topkIncrBy(key2, itemIncrements));
    }

    @Override
    public List<Boolean> topkQuery(String key2, String ... items2) {
        return this.executeCommand(this.commandObjects.topkQuery(key2, items2));
    }

    @Override
    public List<String> topkList(String key2) {
        return this.executeCommand(this.commandObjects.topkList(key2));
    }

    @Override
    public Map<String, Long> topkListWithCount(String key2) {
        return this.executeCommand(this.commandObjects.topkListWithCount(key2));
    }

    @Override
    public Map<String, Object> topkInfo(String key2) {
        return this.executeCommand(this.commandObjects.topkInfo(key2));
    }

    @Override
    public String tdigestCreate(String key2) {
        return this.executeCommand(this.commandObjects.tdigestCreate(key2));
    }

    @Override
    public String tdigestCreate(String key2, int compression) {
        return this.executeCommand(this.commandObjects.tdigestCreate(key2, compression));
    }

    @Override
    public String tdigestReset(String key2) {
        return this.executeCommand(this.commandObjects.tdigestReset(key2));
    }

    @Override
    public String tdigestMerge(String destinationKey, String ... sourceKeys) {
        return this.executeCommand(this.commandObjects.tdigestMerge(destinationKey, sourceKeys));
    }

    @Override
    public String tdigestMerge(TDigestMergeParams mergeParams, String destinationKey, String ... sourceKeys) {
        return this.executeCommand(this.commandObjects.tdigestMerge(mergeParams, destinationKey, sourceKeys));
    }

    @Override
    public Map<String, Object> tdigestInfo(String key2) {
        return this.executeCommand(this.commandObjects.tdigestInfo(key2));
    }

    @Override
    public String tdigestAdd(String key2, double ... values2) {
        return this.executeCommand(this.commandObjects.tdigestAdd(key2, values2));
    }

    @Override
    public List<Double> tdigestCDF(String key2, double ... values2) {
        return this.executeCommand(this.commandObjects.tdigestCDF(key2, values2));
    }

    @Override
    public List<Double> tdigestQuantile(String key2, double ... quantiles) {
        return this.executeCommand(this.commandObjects.tdigestQuantile(key2, quantiles));
    }

    @Override
    public double tdigestMin(String key2) {
        return this.executeCommand(this.commandObjects.tdigestMin(key2));
    }

    @Override
    public double tdigestMax(String key2) {
        return this.executeCommand(this.commandObjects.tdigestMax(key2));
    }

    @Override
    public double tdigestTrimmedMean(String key2, double lowCutQuantile, double highCutQuantile) {
        return this.executeCommand(this.commandObjects.tdigestTrimmedMean(key2, lowCutQuantile, highCutQuantile));
    }

    @Override
    public List<Long> tdigestRank(String key2, double ... values2) {
        return this.executeCommand(this.commandObjects.tdigestRank(key2, values2));
    }

    @Override
    public List<Long> tdigestRevRank(String key2, double ... values2) {
        return this.executeCommand(this.commandObjects.tdigestRevRank(key2, values2));
    }

    @Override
    public List<Double> tdigestByRank(String key2, long ... ranks) {
        return this.executeCommand(this.commandObjects.tdigestByRank(key2, ranks));
    }

    @Override
    public List<Double> tdigestByRevRank(String key2, long ... ranks) {
        return this.executeCommand(this.commandObjects.tdigestByRevRank(key2, ranks));
    }

    @Override
    @Deprecated
    public ResultSet graphQuery(String name, String query2) {
        return this.executeCommand(this.graphCommandObjects.graphQuery(name, query2));
    }

    @Override
    @Deprecated
    public ResultSet graphReadonlyQuery(String name, String query2) {
        return this.executeCommand(this.graphCommandObjects.graphReadonlyQuery(name, query2));
    }

    @Override
    @Deprecated
    public ResultSet graphQuery(String name, String query2, long timeout2) {
        return this.executeCommand(this.graphCommandObjects.graphQuery(name, query2, timeout2));
    }

    @Override
    @Deprecated
    public ResultSet graphReadonlyQuery(String name, String query2, long timeout2) {
        return this.executeCommand(this.graphCommandObjects.graphReadonlyQuery(name, query2, timeout2));
    }

    @Override
    @Deprecated
    public ResultSet graphQuery(String name, String query2, Map<String, Object> params) {
        return this.executeCommand(this.graphCommandObjects.graphQuery(name, query2, params));
    }

    @Override
    @Deprecated
    public ResultSet graphReadonlyQuery(String name, String query2, Map<String, Object> params) {
        return this.executeCommand(this.graphCommandObjects.graphReadonlyQuery(name, query2, params));
    }

    @Override
    @Deprecated
    public ResultSet graphQuery(String name, String query2, Map<String, Object> params, long timeout2) {
        return this.executeCommand(this.graphCommandObjects.graphQuery(name, query2, params, timeout2));
    }

    @Override
    @Deprecated
    public ResultSet graphReadonlyQuery(String name, String query2, Map<String, Object> params, long timeout2) {
        return this.executeCommand(this.graphCommandObjects.graphReadonlyQuery(name, query2, params, timeout2));
    }

    @Override
    @Deprecated
    public String graphDelete(String name) {
        return this.executeCommand(this.graphCommandObjects.graphDelete(name));
    }

    @Override
    @Deprecated
    public List<String> graphList() {
        return this.executeCommand(this.commandObjects.graphList());
    }

    @Override
    @Deprecated
    public List<String> graphProfile(String graphName, String query2) {
        return this.executeCommand(this.commandObjects.graphProfile(graphName, query2));
    }

    @Override
    @Deprecated
    public List<String> graphExplain(String graphName, String query2) {
        return this.executeCommand(this.commandObjects.graphExplain(graphName, query2));
    }

    @Override
    @Deprecated
    public List<List<Object>> graphSlowlog(String graphName) {
        return this.executeCommand(this.commandObjects.graphSlowlog(graphName));
    }

    @Override
    @Deprecated
    public String graphConfigSet(String configName, Object value2) {
        return this.executeCommand(this.commandObjects.graphConfigSet(configName, value2));
    }

    @Override
    @Deprecated
    public Map<String, Object> graphConfigGet(String configName) {
        return this.executeCommand(this.commandObjects.graphConfigGet(configName));
    }

    @Override
    @Deprecated
    public String tFunctionLoad(String libraryCode, TFunctionLoadParams params) {
        return this.executeCommand(this.commandObjects.tFunctionLoad(libraryCode, params));
    }

    @Override
    @Deprecated
    public String tFunctionDelete(String libraryName) {
        return this.executeCommand(this.commandObjects.tFunctionDelete(libraryName));
    }

    @Override
    @Deprecated
    public List<GearsLibraryInfo> tFunctionList(TFunctionListParams params) {
        return this.executeCommand(this.commandObjects.tFunctionList(params));
    }

    @Override
    @Deprecated
    public Object tFunctionCall(String library, String function, List<String> keys2, List<String> args2) {
        return this.executeCommand(this.commandObjects.tFunctionCall(library, function, keys2, args2));
    }

    @Override
    @Deprecated
    public Object tFunctionCallAsync(String library, String function, List<String> keys2, List<String> args2) {
        return this.executeCommand(this.commandObjects.tFunctionCallAsync(library, function, keys2, args2));
    }

    public PipelineBase pipelined() {
        if (this.provider == null) {
            throw new IllegalStateException("It is not allowed to create Pipeline from this " + this.getClass());
        }
        if (this.provider instanceof MultiClusterPooledConnectionProvider) {
            return new MultiClusterPipeline((MultiClusterPooledConnectionProvider)this.provider, this.commandObjects);
        }
        return new Pipeline(this.provider.getConnection(), true, this.commandObjects);
    }

    public AbstractTransaction multi() {
        return this.transaction(true);
    }

    public AbstractTransaction transaction(boolean doMulti) {
        if (this.provider == null) {
            throw new IllegalStateException("It is not allowed to create Transaction from this " + this.getClass());
        }
        if (this.provider instanceof MultiClusterPooledConnectionProvider) {
            return new MultiClusterTransaction((MultiClusterPooledConnectionProvider)this.provider, doMulti, this.commandObjects);
        }
        return new Transaction(this.provider.getConnection(), doMulti, true, this.commandObjects);
    }

    public Object sendCommand(ProtocolCommand cmd) {
        return this.executeCommand(this.commandObjects.commandArguments(cmd));
    }

    public Object sendCommand(ProtocolCommand cmd, byte[] ... args2) {
        return this.executeCommand(this.commandObjects.commandArguments(cmd).addObjects((Object[])args2));
    }

    public Object sendBlockingCommand(ProtocolCommand cmd, byte[] ... args2) {
        return this.executeCommand(this.commandObjects.commandArguments(cmd).addObjects((Object[])args2).blocking());
    }

    public Object sendCommand(ProtocolCommand cmd, String ... args2) {
        return this.executeCommand(this.commandObjects.commandArguments(cmd).addObjects(args2));
    }

    public Object sendBlockingCommand(ProtocolCommand cmd, String ... args2) {
        return this.executeCommand(this.commandObjects.commandArguments(cmd).addObjects(args2).blocking());
    }

    public Object sendCommand(byte[] sampleKey, ProtocolCommand cmd, byte[] ... args2) {
        return this.executeCommand(this.commandObjects.commandArguments(cmd).addObjects((Object[])args2).processKey(sampleKey));
    }

    public Object sendBlockingCommand(byte[] sampleKey, ProtocolCommand cmd, byte[] ... args2) {
        return this.executeCommand(this.commandObjects.commandArguments(cmd).addObjects((Object[])args2).blocking().processKey(sampleKey));
    }

    public Object sendCommand(String sampleKey, ProtocolCommand cmd, String ... args2) {
        return this.executeCommand(this.commandObjects.commandArguments(cmd).addObjects(args2).processKey(sampleKey));
    }

    public Object sendBlockingCommand(String sampleKey, ProtocolCommand cmd, String ... args2) {
        return this.executeCommand(this.commandObjects.commandArguments(cmd).addObjects(args2).blocking().processKey(sampleKey));
    }

    public Object executeCommand(CommandArguments args2) {
        return this.executeCommand(new CommandObject<Object>(args2, BuilderFactory.RAW_OBJECT));
    }

    @Experimental
    public void setKeyArgumentPreProcessor(CommandKeyArgumentPreProcessor keyPreProcessor) {
        this.commandObjects.setKeyArgumentPreProcessor(keyPreProcessor);
    }

    public void setJsonObjectMapper(JsonObjectMapper jsonObjectMapper) {
        this.commandObjects.setJsonObjectMapper(jsonObjectMapper);
    }

    public void setDefaultSearchDialect(int dialect) {
        this.commandObjects.setDefaultSearchDialect(dialect);
    }
}

