/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.csc;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.csc.Cache;
import redis.clients.jedis.csc.CacheEntry;
import redis.clients.jedis.csc.CacheKey;
import redis.clients.jedis.csc.CacheStats;
import redis.clients.jedis.csc.Cacheable;
import redis.clients.jedis.csc.DefaultCacheable;
import redis.clients.jedis.csc.EvictionPolicy;
import redis.clients.jedis.util.SafeEncoder;

@Experimental
public abstract class AbstractCache
implements Cache {
    private Cacheable cacheable;
    private final Map<ByteBuffer, Set<CacheKey<?>>> redisKeysToCacheKeys = new ConcurrentHashMap();
    private final int maximumSize;
    private ReentrantLock lock = new ReentrantLock();
    private volatile CacheStats stats = new CacheStats();

    protected AbstractCache(int maximumSize) {
        this(maximumSize, DefaultCacheable.INSTANCE);
    }

    protected AbstractCache(int maximumSize, Cacheable cacheable) {
        this.maximumSize = maximumSize;
        this.cacheable = cacheable;
    }

    @Override
    public int getMaxSize() {
        return this.maximumSize;
    }

    @Override
    public abstract int getSize();

    @Override
    public abstract Collection<CacheEntry> getCacheEntries();

    @Override
    public CacheEntry get(CacheKey cacheKey) {
        CacheEntry entry = this.getFromStore(cacheKey);
        if (entry != null) {
            this.getEvictionPolicy().touch(cacheKey);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheEntry set(CacheKey cacheKey, CacheEntry entry) {
        this.lock.lock();
        try {
            entry = this.putIntoStore(cacheKey, entry);
            EvictionPolicy policy = this.getEvictionPolicy();
            policy.touch(cacheKey);
            CacheKey evictedKey = policy.evictNext();
            if (evictedKey != null) {
                this.delete(evictedKey);
                this.stats.evict();
            }
            for (Object redisKey : cacheKey.getRedisKeys()) {
                ByteBuffer mapKey = this.makeKeyForRedisKeysToCacheKeys(redisKey);
                if (this.redisKeysToCacheKeys.containsKey(mapKey)) {
                    this.redisKeysToCacheKeys.get(mapKey).add(cacheKey);
                    continue;
                }
                ConcurrentHashMap.KeySetView set2 = ConcurrentHashMap.newKeySet();
                set2.add(cacheKey);
                this.redisKeysToCacheKeys.put(mapKey, set2);
            }
            this.stats.load();
            CacheEntry cacheEntry = entry;
            return cacheEntry;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(CacheKey cacheKey) {
        this.lock.lock();
        try {
            boolean removed = this.removeFromStore(cacheKey);
            this.getEvictionPolicy().reset(cacheKey);
            for (Object redisKey : cacheKey.getRedisKeys()) {
                ByteBuffer mapKey = this.makeKeyForRedisKeysToCacheKeys(redisKey);
                Set<CacheKey<?>> cacheKeysRelatedtoRedisKey = this.redisKeysToCacheKeys.get(mapKey);
                if (cacheKeysRelatedtoRedisKey == null) continue;
                cacheKeysRelatedtoRedisKey.remove(cacheKey);
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<Boolean> delete(List<CacheKey> cacheKeys) {
        this.lock.lock();
        try {
            List<Boolean> list = cacheKeys.stream().map(this::delete).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CacheKey> deleteByRedisKey(Object key2) {
        this.lock.lock();
        try {
            ByteBuffer mapKey = this.makeKeyForRedisKeysToCacheKeys(key2);
            Set<CacheKey<?>> commands = this.redisKeysToCacheKeys.get(mapKey);
            ArrayList<CacheKey> cacheKeys = new ArrayList<CacheKey>();
            if (commands != null) {
                cacheKeys.addAll(commands.stream().filter(this::removeFromStore).collect(Collectors.toList()));
                this.stats.invalidationByServer(cacheKeys.size());
                this.redisKeysToCacheKeys.remove(mapKey);
            }
            this.stats.invalidationMessages();
            ArrayList<CacheKey> arrayList = cacheKeys;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<CacheKey> deleteByRedisKeys(List keys2) {
        if (keys2 == null) {
            this.flush();
            return null;
        }
        this.lock.lock();
        try {
            List<CacheKey> list = keys2.stream().map(this::deleteByRedisKey).flatMap(Collection::stream).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int flush() {
        this.lock.lock();
        try {
            int result2 = this.getSize();
            this.clearStore();
            this.redisKeysToCacheKeys.clear();
            this.getEvictionPolicy().resetAll();
            this.getStats().flush();
            int n = result2;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isCacheable(CacheKey cacheKey) {
        return this.cacheable.isCacheable(cacheKey.getRedisCommand(), cacheKey.getRedisKeys());
    }

    @Override
    public boolean hasCacheKey(CacheKey cacheKey) {
        return this.containsKeyInStore(cacheKey);
    }

    @Override
    public abstract EvictionPolicy getEvictionPolicy();

    @Override
    public CacheStats getStats() {
        return this.stats;
    }

    @Override
    public CacheStats getAndResetStats() {
        CacheStats result2 = this.stats;
        this.stats = new CacheStats();
        return result2;
    }

    @Override
    public boolean compatibilityMode() {
        return false;
    }

    protected abstract CacheEntry getFromStore(CacheKey var1);

    protected abstract CacheEntry putIntoStore(CacheKey var1, CacheEntry var2);

    protected abstract boolean removeFromStore(CacheKey var1);

    protected abstract void clearStore();

    protected abstract boolean containsKeyInStore(CacheKey var1);

    private ByteBuffer makeKeyForRedisKeysToCacheKeys(Object key2) {
        if (key2 instanceof byte[]) {
            return AbstractCache.makeKeyForRedisKeysToCacheKeys((byte[])key2);
        }
        if (key2 instanceof String) {
            return AbstractCache.makeKeyForRedisKeysToCacheKeys(SafeEncoder.encode((String)key2));
        }
        throw new IllegalArgumentException(key2.getClass().getSimpleName() + " is not supported. Value: \"" + String.valueOf(key2) + "\".");
    }

    private static ByteBuffer makeKeyForRedisKeysToCacheKeys(byte[] b2) {
        return ByteBuffer.wrap(b2);
    }
}

