/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.csc;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import redis.clients.jedis.csc.Cache;
import redis.clients.jedis.csc.CacheConfig;
import redis.clients.jedis.csc.Cacheable;
import redis.clients.jedis.csc.DefaultCache;
import redis.clients.jedis.csc.EvictionPolicy;
import redis.clients.jedis.csc.LRUEviction;
import redis.clients.jedis.exceptions.JedisCacheException;

public final class CacheFactory {
    public static Cache getCache(CacheConfig config2) {
        if (config2.getCacheClass() == null) {
            if (config2.getCacheable() == null) {
                throw new JedisCacheException("Cacheable is required to create the default cache!");
            }
            return new DefaultCache(config2.getMaxSize(), config2.getCacheable(), CacheFactory.getEvictionPolicy(config2));
        }
        return CacheFactory.instantiateCustomCache(config2);
    }

    private static Cache instantiateCustomCache(CacheConfig config2) {
        try {
            Constructor ctorWithCacheable;
            if (config2.getCacheable() != null && (ctorWithCacheable = CacheFactory.findConstructorWithCacheable(config2.getCacheClass())) != null) {
                return (Cache)ctorWithCacheable.newInstance(config2.getMaxSize(), CacheFactory.getEvictionPolicy(config2), config2.getCacheable());
            }
            Constructor ctor = CacheFactory.getConstructor(config2.getCacheClass());
            return (Cache)ctor.newInstance(config2.getMaxSize(), CacheFactory.getEvictionPolicy(config2));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e2) {
            throw new JedisCacheException("Failed to insantiate custom cache type!", e2);
        }
    }

    private static Constructor findConstructorWithCacheable(Class customCacheType) {
        return Arrays.stream(customCacheType.getConstructors()).filter(ctor -> Arrays.equals(ctor.getParameterTypes(), new Class[]{Integer.TYPE, EvictionPolicy.class, Cacheable.class})).findFirst().orElse(null);
    }

    private static Constructor getConstructor(Class customCacheType) {
        try {
            return customCacheType.getConstructor(Integer.TYPE, EvictionPolicy.class);
        }
        catch (NoSuchMethodException e2) {
            String className = customCacheType.getName();
            throw new JedisCacheException(String.format("Failed to find compatible constructor for custom cache type!  Provide one of these;\n - %s(int maxSize, EvictionPolicy evictionPolicy)\n - %s(int maxSize, EvictionPolicy evictionPolicy, Cacheable cacheable)", className, className), e2);
        }
    }

    private static EvictionPolicy getEvictionPolicy(CacheConfig config2) {
        if (config2.getEvictionPolicy() == null) {
            return new LRUEviction(config2.getMaxSize());
        }
        return config2.getEvictionPolicy();
    }
}

