/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.csc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import redis.clients.jedis.csc.AbstractCache;
import redis.clients.jedis.csc.CacheEntry;
import redis.clients.jedis.csc.CacheKey;
import redis.clients.jedis.csc.Cacheable;
import redis.clients.jedis.csc.DefaultCacheable;
import redis.clients.jedis.csc.EvictionPolicy;
import redis.clients.jedis.csc.LRUEviction;

public class DefaultCache
extends AbstractCache {
    protected final Map<CacheKey, CacheEntry> cache;
    private final EvictionPolicy evictionPolicy;

    protected DefaultCache(int maximumSize) {
        this(maximumSize, new HashMap<CacheKey, CacheEntry>());
    }

    protected DefaultCache(int maximumSize, Map<CacheKey, CacheEntry> map2) {
        this(maximumSize, map2, DefaultCacheable.INSTANCE, new LRUEviction(maximumSize));
    }

    protected DefaultCache(int maximumSize, Cacheable cacheable) {
        this(maximumSize, new HashMap<CacheKey, CacheEntry>(), cacheable, new LRUEviction(maximumSize));
    }

    protected DefaultCache(int maximumSize, Cacheable cacheable, EvictionPolicy evictionPolicy) {
        this(maximumSize, new HashMap<CacheKey, CacheEntry>(), cacheable, evictionPolicy);
    }

    protected DefaultCache(int maximumSize, Map<CacheKey, CacheEntry> map2, Cacheable cacheable, EvictionPolicy evictionPolicy) {
        super(maximumSize, cacheable);
        this.cache = map2;
        this.evictionPolicy = evictionPolicy;
        this.evictionPolicy.setCache(this);
    }

    @Override
    public int getSize() {
        return this.cache.size();
    }

    @Override
    public Collection<CacheEntry> getCacheEntries() {
        return this.cache.values();
    }

    @Override
    public EvictionPolicy getEvictionPolicy() {
        return this.evictionPolicy;
    }

    @Override
    public CacheEntry getFromStore(CacheKey key2) {
        return this.cache.get(key2);
    }

    @Override
    public CacheEntry putIntoStore(CacheKey key2, CacheEntry entry) {
        return this.cache.put(key2, entry);
    }

    @Override
    public boolean removeFromStore(CacheKey key2) {
        return this.cache.remove(key2) != null;
    }

    @Override
    protected final void clearStore() {
        this.cache.clear();
    }

    @Override
    protected boolean containsKeyInStore(CacheKey cacheKey) {
        return this.cache.containsKey(cacheKey);
    }
}

