/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.csc;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import redis.clients.jedis.csc.Cache;
import redis.clients.jedis.csc.CacheKey;
import redis.clients.jedis.csc.EvictionPolicy;

public class LRUEviction
implements EvictionPolicy {
    protected Cache cache;
    protected LinkedHashMap<CacheKey, Long> accessTimes;
    protected ArrayDeque<CacheKey> pendingEvictions = new ArrayDeque();
    protected ConcurrentLinkedQueue msg = new ConcurrentLinkedQueue();
    private int initialCapacity;

    public LRUEviction(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    @Override
    public void setCache(final Cache cache2) {
        this.cache = cache2;
        this.accessTimes = new LinkedHashMap<CacheKey, Long>(this.initialCapacity, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<CacheKey, Long> eldest) {
                boolean evictionRequired;
                boolean bl = evictionRequired = cache2.getSize() > cache2.getMaxSize() || LRUEviction.this.accessTimes.size() > cache2.getMaxSize();
                if (evictionRequired && cache2.hasCacheKey(eldest.getKey())) {
                    LRUEviction.this.pendingEvictions.addLast(eldest.getKey());
                }
                return evictionRequired;
            }
        };
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    @Override
    public EvictionPolicy.EvictionType getType() {
        return EvictionPolicy.EvictionType.AGE;
    }

    @Override
    public String getName() {
        return "Simple L(east) R(ecently) U(sed)";
    }

    @Override
    public synchronized CacheKey evictNext() {
        CacheKey cacheKey = this.pendingEvictions.pollFirst();
        while (cacheKey != null && !this.cache.hasCacheKey(cacheKey)) {
            cacheKey = this.pendingEvictions.pollFirst();
        }
        return cacheKey;
    }

    @Override
    public synchronized List<CacheKey> evictMany(int n) {
        ArrayList<CacheKey> result2 = new ArrayList<CacheKey>();
        for (int i2 = 0; i2 < n; ++i2) {
            result2.add(this.evictNext());
        }
        return result2;
    }

    @Override
    public synchronized void touch(CacheKey cacheKey) {
        this.accessTimes.put(cacheKey, new Date().getTime());
    }

    @Override
    public synchronized boolean reset(CacheKey cacheKey) {
        return this.accessTimes.remove(cacheKey) != null;
    }

    @Override
    public synchronized int resetAll() {
        int result2 = this.accessTimes.size();
        this.accessTimes.clear();
        return result2;
    }
}

