/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.csc;

import java.util.Arrays;

class RedisVersion
implements Comparable<RedisVersion> {
    private String version;
    private Integer[] numbers;

    public RedisVersion(String version2) {
        if (version2 == null) {
            throw new IllegalArgumentException("Version can not be null");
        }
        this.version = version2;
        this.numbers = (Integer[])Arrays.stream(version2.split("\\.")).map(n -> Integer.parseInt(n)).toArray(Integer[]::new);
    }

    @Override
    public int compareTo(RedisVersion other) {
        int max2 = Math.max(this.numbers.length, other.numbers.length);
        for (int i2 = 0; i2 < max2; ++i2) {
            int otherNumber;
            int thisNumber = this.numbers.length > i2 ? this.numbers[i2] : 0;
            int n = otherNumber = other.numbers.length > i2 ? other.numbers[i2] : 0;
            if (thisNumber < otherNumber) {
                return -1;
            }
            if (thisNumber <= otherNumber) continue;
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.version;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.compareTo((RedisVersion)that) == 0;
    }
}

