/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Connection;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.graph.GraphCache;
import redis.clients.jedis.graph.GraphProtocol;
import redis.clients.jedis.graph.GraphQueryParams;
import redis.clients.jedis.graph.Record;
import redis.clients.jedis.graph.RedisGraphCommands;
import redis.clients.jedis.graph.ResultSet;
import redis.clients.jedis.graph.ResultSetBuilder;
import redis.clients.jedis.providers.ConnectionProvider;

@Deprecated
public class GraphCommandObjects {
    private final RedisGraphCommands graph;
    private final Connection connection;
    private final ConnectionProvider provider;
    private Function<ProtocolCommand, CommandArguments> commArgs = comm -> new CommandArguments((ProtocolCommand)comm);
    private final ConcurrentHashMap<String, Builder<ResultSet>> builders = new ConcurrentHashMap();

    public GraphCommandObjects(RedisGraphCommands graphCommands) {
        this.graph = graphCommands;
        this.connection = null;
        this.provider = null;
    }

    public GraphCommandObjects(Connection connection) {
        this.graph = null;
        this.connection = connection;
        this.provider = null;
    }

    public GraphCommandObjects(ConnectionProvider provider2) {
        this.graph = null;
        this.connection = null;
        this.provider = provider2;
    }

    public void setBaseCommandArgumentsCreator(Function<ProtocolCommand, CommandArguments> commArgs) {
        this.commArgs = commArgs;
    }

    public final CommandObject<ResultSet> graphQuery(String name, String query2) {
        return new CommandObject<ResultSet>(this.commArgs.apply(GraphProtocol.GraphCommand.QUERY).key(name).add(query2).add(GraphProtocol.GraphKeyword.__COMPACT), this.getBuilder(name));
    }

    public final CommandObject<ResultSet> graphReadonlyQuery(String name, String query2) {
        return new CommandObject<ResultSet>(this.commArgs.apply(GraphProtocol.GraphCommand.RO_QUERY).key(name).add(query2).add(GraphProtocol.GraphKeyword.__COMPACT), this.getBuilder(name));
    }

    public final CommandObject<ResultSet> graphQuery(String name, String query2, long timeout2) {
        return this.graphQuery(name, GraphQueryParams.queryParams(query2).timeout(timeout2));
    }

    public final CommandObject<ResultSet> graphReadonlyQuery(String name, String query2, long timeout2) {
        return this.graphQuery(name, GraphQueryParams.queryParams().readonly().query(query2).timeout(timeout2));
    }

    public final CommandObject<ResultSet> graphQuery(String name, String query2, Map<String, Object> params) {
        return this.graphQuery(name, GraphQueryParams.queryParams(query2).params(params));
    }

    public final CommandObject<ResultSet> graphReadonlyQuery(String name, String query2, Map<String, Object> params) {
        return this.graphQuery(name, GraphQueryParams.queryParams().readonly().query(query2).params(params));
    }

    public final CommandObject<ResultSet> graphQuery(String name, String query2, Map<String, Object> params, long timeout2) {
        return this.graphQuery(name, GraphQueryParams.queryParams(query2).params(params).timeout(timeout2));
    }

    public final CommandObject<ResultSet> graphReadonlyQuery(String name, String query2, Map<String, Object> params, long timeout2) {
        return this.graphQuery(name, GraphQueryParams.queryParams().readonly().query(query2).params(params).timeout(timeout2));
    }

    private CommandObject<ResultSet> graphQuery(String name, GraphQueryParams params) {
        return new CommandObject<ResultSet>(this.commArgs.apply(!params.isReadonly() ? GraphProtocol.GraphCommand.QUERY : GraphProtocol.GraphCommand.RO_QUERY).key(name).addParams(params), this.getBuilder(name));
    }

    public final CommandObject<String> graphDelete(String name) {
        return new CommandObject<String>(this.commArgs.apply(GraphProtocol.GraphCommand.DELETE).key(name), BuilderFactory.STRING);
    }

    private Builder<ResultSet> getBuilder(String graphName) {
        if (!this.builders.containsKey(graphName)) {
            this.createBuilder(graphName);
        }
        return this.builders.get(graphName);
    }

    private void createBuilder(String graphName) {
        this.builders.computeIfAbsent(graphName, graphNameKey -> new ResultSetBuilder(new GraphCacheImpl((String)graphNameKey)));
    }

    private class GraphCacheList {
        private final String name;
        private final String query;
        private final List<String> data = new CopyOnWriteArrayList<String>();
        private final Lock dataLock = new ReentrantLock(true);

        public GraphCacheList(String name, String procedure) {
            this.name = name;
            this.query = "CALL " + procedure + "()";
        }

        public String getCachedData(int index) {
            if (index >= this.data.size()) {
                this.dataLock.lock();
                try {
                    if (index >= this.data.size()) {
                        this.getProcedureInfo();
                    }
                }
                finally {
                    this.dataLock.unlock();
                }
            }
            return this.data.get(index);
        }

        private void getProcedureInfo() {
            ResultSet resultSet = this.callProcedure();
            Iterator it = resultSet.iterator();
            ArrayList<String> newData = new ArrayList<String>();
            int i2 = 0;
            while (it.hasNext()) {
                Record record = (Record)it.next();
                if (i2 >= this.data.size()) {
                    newData.add(record.getString(0));
                }
                ++i2;
            }
            this.data.addAll(newData);
        }

        private ResultSet callProcedure() {
            if (GraphCommandObjects.this.graph != null) {
                return GraphCommandObjects.this.graph.graphQuery(this.name, this.query);
            }
            CommandObject commandObject = new CommandObject(new CommandArguments(GraphProtocol.GraphCommand.QUERY).key(this.name).add(this.query).add(GraphProtocol.GraphKeyword.__COMPACT), GraphCommandObjects.this.getBuilder(this.name));
            if (GraphCommandObjects.this.connection != null) {
                return (ResultSet)GraphCommandObjects.this.connection.executeCommand(commandObject);
            }
            try (Connection provided = GraphCommandObjects.this.provider.getConnection(commandObject.getArguments());){
                ResultSet resultSet = (ResultSet)provided.executeCommand(commandObject);
                return resultSet;
            }
        }
    }

    private class GraphCacheImpl
    implements GraphCache {
        private final GraphCacheList labels;
        private final GraphCacheList propertyNames;
        private final GraphCacheList relationshipTypes;

        public GraphCacheImpl(String graphName) {
            this.labels = new GraphCacheList(graphName, "db.labels");
            this.propertyNames = new GraphCacheList(graphName, "db.propertyKeys");
            this.relationshipTypes = new GraphCacheList(graphName, "db.relationshipTypes");
        }

        @Override
        public String getLabel(int index) {
            return this.labels.getCachedData(index);
        }

        @Override
        public String getRelationshipType(int index) {
            return this.relationshipTypes.getCachedData(index);
        }

        @Override
        public String getPropertyName(int index) {
            return this.propertyNames.getCachedData(index);
        }
    }
}

