/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.graph.GraphCache;
import redis.clients.jedis.graph.Header;
import redis.clients.jedis.graph.Record;
import redis.clients.jedis.graph.ResultSet;
import redis.clients.jedis.graph.Statistics;
import redis.clients.jedis.graph.entities.Edge;
import redis.clients.jedis.graph.entities.GraphEntity;
import redis.clients.jedis.graph.entities.Node;
import redis.clients.jedis.graph.entities.Path;
import redis.clients.jedis.graph.entities.Point;
import redis.clients.jedis.util.SafeEncoder;

@Deprecated
class ResultSetBuilder
extends Builder<ResultSet> {
    private final GraphCache graphCache;
    private static final ScalarType[] SCALAR_TYPES = ScalarType.values();
    private static final ResultSet.ColumnType[] COLUMN_TYPES = ResultSet.ColumnType.values();

    ResultSetBuilder(GraphCache cache2) {
        this.graphCache = cache2;
    }

    @Override
    public ResultSet build(Object data2) {
        Object statisticsObject;
        List<Object> recordsObject;
        List<Object> headerObject;
        List rawResponse = (List)data2;
        if (rawResponse.get(rawResponse.size() - 1) instanceof JedisDataException) {
            throw (JedisDataException)rawResponse.get(rawResponse.size() - 1);
        }
        if (rawResponse.size() == 1) {
            headerObject = Collections.emptyList();
            recordsObject = Collections.emptyList();
            statisticsObject = rawResponse.get(0);
        } else if (rawResponse.size() == 3) {
            headerObject = rawResponse.get(0);
            recordsObject = rawResponse.get(1);
            statisticsObject = rawResponse.get(2);
        } else {
            throw new JedisException("Unrecognized graph response format.");
        }
        HeaderImpl header = this.parseHeader(headerObject);
        List<Record> records = this.parseRecords(header, recordsObject);
        StatisticsImpl statistics = this.parseStatistics(statisticsObject);
        return new ResultSetImpl(header, records, statistics);
    }

    private List<Record> parseRecords(Header header, Object data2) {
        List rawResultSet = (List)data2;
        if (rawResultSet == null || rawResultSet.isEmpty()) {
            return new ArrayList<Record>(0);
        }
        ArrayList<Record> results2 = new ArrayList<Record>(rawResultSet.size());
        for (List row : rawResultSet) {
            ArrayList<Object> parsedRow = new ArrayList<Object>(row.size());
            block6: for (int i2 = 0; i2 < row.size(); ++i2) {
                List obj = (List)row.get(i2);
                ResultSet.ColumnType objType = header.getSchemaTypes().get(i2);
                switch (objType) {
                    case NODE: {
                        parsedRow.add(this.deserializeNode(obj));
                        continue block6;
                    }
                    case RELATION: {
                        parsedRow.add(this.deserializeEdge(obj));
                        continue block6;
                    }
                    case SCALAR: {
                        parsedRow.add(this.deserializeScalar(obj));
                        continue block6;
                    }
                    default: {
                        parsedRow.add(null);
                    }
                }
            }
            RecordImpl record = new RecordImpl(header.getSchemaNames(), parsedRow);
            results2.add(record);
        }
        return results2;
    }

    private Node deserializeNode(List<Object> rawNodeData) {
        List labelsIndices = (List)rawNodeData.get(1);
        List rawProperties = (List)rawNodeData.get(2);
        Node node = new Node(labelsIndices.size(), rawProperties.size());
        this.deserializeGraphEntityId(node, (Long)rawNodeData.get(0));
        for (Long labelIndex : labelsIndices) {
            String label = this.graphCache.getLabel(labelIndex.intValue());
            node.addLabel(label);
        }
        this.deserializeGraphEntityProperties(node, rawProperties);
        return node;
    }

    private void deserializeGraphEntityId(GraphEntity graphEntity, long id) {
        graphEntity.setId(id);
    }

    private Edge deserializeEdge(List<Object> rawEdgeData) {
        List rawProperties = (List)rawEdgeData.get(4);
        Edge edge = new Edge(rawProperties.size());
        this.deserializeGraphEntityId(edge, (Long)rawEdgeData.get(0));
        String relationshipType = this.graphCache.getRelationshipType(((Long)rawEdgeData.get(1)).intValue());
        edge.setRelationshipType(relationshipType);
        edge.setSource((Long)rawEdgeData.get(2));
        edge.setDestination((Long)rawEdgeData.get(3));
        this.deserializeGraphEntityProperties(edge, rawProperties);
        return edge;
    }

    private void deserializeGraphEntityProperties(GraphEntity entity, List<List<Object>> rawProperties) {
        for (List<Object> rawProperty : rawProperties) {
            String name = this.graphCache.getPropertyName(((Long)rawProperty.get(0)).intValue());
            List<Object> propertyScalar = rawProperty.subList(1, rawProperty.size());
            entity.addProperty(name, this.deserializeScalar(propertyScalar));
        }
    }

    private Object deserializeScalar(List<Object> rawScalarData) {
        ScalarType type2 = this.getValueTypeFromObject(rawScalarData.get(0));
        Object obj = rawScalarData.get(1);
        switch (type2) {
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(SafeEncoder.encode((byte[])obj));
            }
            case DOUBLE: {
                return BuilderFactory.DOUBLE.build(obj);
            }
            case INTEGER: {
                return (Long)obj;
            }
            case STRING: {
                return SafeEncoder.encode((byte[])obj);
            }
            case ARRAY: {
                return this.deserializeArray(obj);
            }
            case NODE: {
                return this.deserializeNode((List)obj);
            }
            case EDGE: {
                return this.deserializeEdge((List)obj);
            }
            case PATH: {
                return this.deserializePath(obj);
            }
            case MAP: {
                return this.deserializeMap(obj);
            }
            case POINT: {
                return this.deserializePoint(obj);
            }
        }
        return obj;
    }

    private Object deserializePoint(Object rawScalarData) {
        return new Point(BuilderFactory.DOUBLE_LIST.build(rawScalarData));
    }

    private Map<String, Object> deserializeMap(Object rawScalarData) {
        List keyTypeValueEntries = (List)rawScalarData;
        int size2 = keyTypeValueEntries.size();
        HashMap<String, Object> map2 = new HashMap<String, Object>(size2 >> 1);
        for (int i2 = 0; i2 < size2; i2 += 2) {
            String key2 = SafeEncoder.encode((byte[])keyTypeValueEntries.get(i2));
            Object value2 = this.deserializeScalar((List)keyTypeValueEntries.get(i2 + 1));
            map2.put(key2, value2);
        }
        return map2;
    }

    private Path deserializePath(Object rawScalarData) {
        List array = (List)rawScalarData;
        List nodes2 = (List)this.deserializeScalar((List)array.get(0));
        List edges = (List)this.deserializeScalar((List)array.get(1));
        return new Path(nodes2, edges);
    }

    private List<Object> deserializeArray(Object rawScalarData) {
        List array = (List)rawScalarData;
        ArrayList<Object> res = new ArrayList<Object>(array.size());
        for (List arrayValue : array) {
            res.add(this.deserializeScalar(arrayValue));
        }
        return res;
    }

    private ScalarType getValueTypeFromObject(Object rawScalarType) {
        return ResultSetBuilder.getScalarType(((Long)rawScalarType).intValue());
    }

    private static ScalarType getScalarType(int index) {
        try {
            return SCALAR_TYPES[index];
        }
        catch (IndexOutOfBoundsException e2) {
            throw new JedisException("Unrecognized response type");
        }
    }

    private HeaderImpl parseHeader(Object data2) {
        if (data2 == null) {
            return new HeaderImpl();
        }
        List list = (List)data2;
        ArrayList<ResultSet.ColumnType> types = new ArrayList<ResultSet.ColumnType>(list.size());
        ArrayList<String> texts = new ArrayList<String>(list.size());
        for (List tuple : list) {
            types.add(COLUMN_TYPES[((Long)tuple.get(0)).intValue()]);
            texts.add(SafeEncoder.encode((byte[])tuple.get(1)));
        }
        return new HeaderImpl(types, texts);
    }

    private StatisticsImpl parseStatistics(Object data2) {
        Map<String, String> map2 = ((List)data2).stream().map(SafeEncoder::encode).map(s2 -> s2.split(": ")).collect(Collectors.toMap(sa -> sa[0], sa -> sa[1]));
        return new StatisticsImpl(map2);
    }

    private class StatisticsImpl
    implements Statistics {
        private final Map<String, String> statistics;

        private StatisticsImpl(Map<String, String> statistics) {
            this.statistics = statistics;
        }

        public String getStringValue(String label) {
            return this.statistics.get(label);
        }

        private int getIntValue(String label) {
            String value2 = this.getStringValue(label);
            return value2 == null ? 0 : Integer.parseInt(value2);
        }

        @Override
        public int nodesCreated() {
            return this.getIntValue("Nodes created");
        }

        @Override
        public int nodesDeleted() {
            return this.getIntValue("Nodes deleted");
        }

        @Override
        public int indicesCreated() {
            return this.getIntValue("Indices created");
        }

        @Override
        public int indicesDeleted() {
            return this.getIntValue("Indices deleted");
        }

        @Override
        public int labelsAdded() {
            return this.getIntValue("Labels added");
        }

        @Override
        public int relationshipsDeleted() {
            return this.getIntValue("Relationships deleted");
        }

        @Override
        public int relationshipsCreated() {
            return this.getIntValue("Relationships created");
        }

        @Override
        public int propertiesSet() {
            return this.getIntValue("Properties set");
        }

        @Override
        public boolean cachedExecution() {
            return "1".equals(this.getStringValue("Cached execution"));
        }

        @Override
        public String queryIntervalExecutionTime() {
            return this.getStringValue("Query internal execution time");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StatisticsImpl)) {
                return false;
            }
            StatisticsImpl that = (StatisticsImpl)o;
            return Objects.equals(this.statistics, that.statistics);
        }

        public int hashCode() {
            return Objects.hash(this.statistics);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Statistics{");
            sb.append(this.statistics);
            sb.append('}');
            return sb.toString();
        }
    }

    private class HeaderImpl
    implements Header {
        private final List<ResultSet.ColumnType> schemaTypes;
        private final List<String> schemaNames;

        private HeaderImpl() {
            this.schemaTypes = Collections.emptyList();
            this.schemaNames = Collections.emptyList();
        }

        private HeaderImpl(List<ResultSet.ColumnType> schemaTypes, List<String> schemaNames) {
            this.schemaTypes = schemaTypes;
            this.schemaNames = schemaNames;
        }

        @Override
        public List<String> getSchemaNames() {
            return this.schemaNames;
        }

        @Override
        public List<ResultSet.ColumnType> getSchemaTypes() {
            return this.schemaTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HeaderImpl)) {
                return false;
            }
            HeaderImpl header = (HeaderImpl)o;
            return Objects.equals(this.getSchemaTypes(), header.getSchemaTypes()) && Objects.equals(this.getSchemaNames(), header.getSchemaNames());
        }

        public int hashCode() {
            return Objects.hash(this.getSchemaTypes(), this.getSchemaNames());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("HeaderImpl{");
            sb.append("schemaTypes=").append(this.schemaTypes);
            sb.append(", schemaNames=").append(this.schemaNames);
            sb.append('}');
            return sb.toString();
        }
    }

    private class RecordImpl
    implements Record {
        private final List<String> header;
        private final List<Object> values;

        public RecordImpl(List<String> header, List<Object> values2) {
            this.header = header;
            this.values = values2;
        }

        @Override
        public <T> T getValue(int index) {
            return (T)this.values.get(index);
        }

        @Override
        public <T> T getValue(String key2) {
            return this.getValue(this.header.indexOf(key2));
        }

        @Override
        public String getString(int index) {
            return this.values.get(index).toString();
        }

        @Override
        public String getString(String key2) {
            return this.getString(this.header.indexOf(key2));
        }

        @Override
        public List<String> keys() {
            return this.header;
        }

        @Override
        public List<Object> values() {
            return this.values;
        }

        @Override
        public boolean containsKey(String key2) {
            return this.header.contains(key2);
        }

        @Override
        public int size() {
            return this.header.size();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RecordImpl)) {
                return false;
            }
            RecordImpl record = (RecordImpl)o;
            return Objects.equals(this.header, record.header) && Objects.equals(this.values, record.values);
        }

        public int hashCode() {
            return Objects.hash(this.header, this.values);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Record{");
            sb.append("values=").append(this.values);
            sb.append('}');
            return sb.toString();
        }
    }

    private static enum ScalarType {
        UNKNOWN,
        NULL,
        STRING,
        INTEGER,
        BOOLEAN,
        DOUBLE,
        ARRAY,
        EDGE,
        NODE,
        PATH,
        MAP,
        POINT;

    }

    private class ResultSetImpl
    implements ResultSet {
        private final Header header;
        private final List<Record> results;
        private final Statistics statistics;

        private ResultSetImpl(Header header, List<Record> results2, Statistics statistics) {
            this.header = header;
            this.results = results2;
            this.statistics = statistics;
        }

        @Override
        public Header getHeader() {
            return this.header;
        }

        @Override
        public Statistics getStatistics() {
            return this.statistics;
        }

        @Override
        public int size() {
            return this.results.size();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ResultSetImpl)) {
                return false;
            }
            ResultSetImpl resultSet = (ResultSetImpl)o;
            return Objects.equals(this.getHeader(), resultSet.getHeader()) && Objects.equals(this.getStatistics(), resultSet.getStatistics()) && Objects.equals(this.results, resultSet.results);
        }

        public int hashCode() {
            return Objects.hash(this.getHeader(), this.getStatistics(), this.results);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ResultSetImpl{");
            sb.append("header=").append(this.header);
            sb.append(", statistics=").append(this.statistics);
            sb.append(", results=").append(this.results);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public Iterator<Record> iterator() {
            return this.results.iterator();
        }
    }
}

