/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.mcf;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.decorators.Decorators;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Connection;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.executors.CommandExecutor;
import redis.clients.jedis.mcf.CircuitBreakerFailoverBase;
import redis.clients.jedis.providers.MultiClusterPooledConnectionProvider;

@Experimental
public class CircuitBreakerCommandExecutor
extends CircuitBreakerFailoverBase
implements CommandExecutor {
    public CircuitBreakerCommandExecutor(MultiClusterPooledConnectionProvider provider2) {
        super(provider2);
    }

    @Override
    public <T> T executeCommand(CommandObject<T> commandObject) {
        MultiClusterPooledConnectionProvider.Cluster cluster = this.provider.getCluster();
        Decorators.DecorateSupplier supplier = Decorators.ofSupplier(() -> this.handleExecuteCommand(commandObject, cluster));
        supplier.withRetry(cluster.getRetry());
        supplier.withCircuitBreaker(cluster.getCircuitBreaker());
        supplier.withFallback(this.provider.getFallbackExceptionList(), e2 -> this.handleClusterFailover(commandObject, cluster.getCircuitBreaker()));
        return supplier.decorate().get();
    }

    private <T> T handleExecuteCommand(CommandObject<T> commandObject, MultiClusterPooledConnectionProvider.Cluster cluster) {
        try (Connection connection = cluster.getConnection();){
            T t2 = connection.executeCommand(commandObject);
            return t2;
        }
    }

    private <T> T handleClusterFailover(CommandObject<T> commandObject, CircuitBreaker circuitBreaker) {
        this.clusterFailover(circuitBreaker);
        return this.executeCommand(commandObject);
    }
}

