/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.args.ClientType;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.util.KeyValue;

public class ClientKillParams
implements IParams {
    private final ArrayList<KeyValue<Protocol.Keyword, Object>> params = new ArrayList();

    public static ClientKillParams clientKillParams() {
        return new ClientKillParams();
    }

    private ClientKillParams addParam(Protocol.Keyword key2, Object value2) {
        this.params.add(KeyValue.of(key2, value2));
        return this;
    }

    public ClientKillParams id(String clientId) {
        return this.addParam(Protocol.Keyword.ID, clientId);
    }

    public ClientKillParams id(byte[] clientId) {
        return this.addParam(Protocol.Keyword.ID, clientId);
    }

    public ClientKillParams type(ClientType type2) {
        return this.addParam(Protocol.Keyword.TYPE, type2);
    }

    public ClientKillParams addr(String ipPort) {
        return this.addParam(Protocol.Keyword.ADDR, ipPort);
    }

    public ClientKillParams addr(byte[] ipPort) {
        return this.addParam(Protocol.Keyword.ADDR, ipPort);
    }

    public ClientKillParams addr(String ip, int port2) {
        return this.addParam(Protocol.Keyword.ADDR, ip + ':' + port2);
    }

    public ClientKillParams skipMe(SkipMe skipMe) {
        return this.addParam(Protocol.Keyword.SKIPME, (Object)skipMe);
    }

    public ClientKillParams user(String username) {
        return this.addParam(Protocol.Keyword.USER, username);
    }

    public ClientKillParams laddr(String ipPort) {
        return this.addParam(Protocol.Keyword.LADDR, ipPort);
    }

    public ClientKillParams laddr(String ip, int port2) {
        return this.addParam(Protocol.Keyword.LADDR, ip + ':' + port2);
    }

    public ClientKillParams maxAge(long maxAge) {
        return this.addParam(Protocol.Keyword.MAXAGE, maxAge);
    }

    @Override
    public void addParams(CommandArguments args2) {
        this.params.forEach((Consumer<KeyValue<Protocol.Keyword, Object>>)((Consumer<KeyValue>)kv -> args2.add((Rawable)kv.getKey()).add(kv.getValue())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientKillParams that = (ClientKillParams)o;
        return Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hash(this.params);
    }

    public static enum SkipMe {
        YES,
        NO;

    }
}

