/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.Objects;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;

public class CommandListFilterByParams
implements IParams {
    private String moduleName;
    private String category;
    private String pattern;

    public static CommandListFilterByParams commandListFilterByParams() {
        return new CommandListFilterByParams();
    }

    public CommandListFilterByParams filterByModule(String moduleName) {
        this.moduleName = moduleName;
        return this;
    }

    public CommandListFilterByParams filterByAclCat(String category) {
        this.category = category;
        return this;
    }

    public CommandListFilterByParams filterByPattern(String pattern2) {
        this.pattern = pattern2;
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        args2.add(Protocol.Keyword.FILTERBY);
        if (this.moduleName != null && this.category == null && this.pattern == null) {
            args2.add(Protocol.Keyword.MODULE);
            args2.add(this.moduleName);
        } else if (this.moduleName == null && this.category != null && this.pattern == null) {
            args2.add(Protocol.Keyword.ACLCAT);
            args2.add(this.category);
        } else if (this.moduleName == null && this.category == null && this.pattern != null) {
            args2.add(Protocol.Keyword.PATTERN);
            args2.add(this.pattern);
        } else {
            throw new IllegalArgumentException("Must choose exactly one filter in " + this.getClass().getSimpleName());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandListFilterByParams that = (CommandListFilterByParams)o;
        return Objects.equals(this.moduleName, that.moduleName) && Objects.equals(this.category, that.category) && Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.moduleName, this.category, this.pattern);
    }
}

