/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.Objects;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;

public class GetExParams
implements IParams {
    private Protocol.Keyword expiration;
    private Long expirationValue;
    private boolean persist;

    public static GetExParams getExParams() {
        return new GetExParams();
    }

    private GetExParams expiration(Protocol.Keyword type2, Long value2) {
        this.expiration = type2;
        this.expirationValue = value2;
        return this;
    }

    public GetExParams ex(long secondsToExpire) {
        return this.expiration(Protocol.Keyword.EX, secondsToExpire);
    }

    public GetExParams px(long millisecondsToExpire) {
        return this.expiration(Protocol.Keyword.PX, millisecondsToExpire);
    }

    public GetExParams exAt(long seconds) {
        return this.expiration(Protocol.Keyword.EXAT, seconds);
    }

    public GetExParams pxAt(long milliseconds) {
        return this.expiration(Protocol.Keyword.PXAT, milliseconds);
    }

    public GetExParams persist() {
        return this.expiration(Protocol.Keyword.PERSIST, null);
    }

    @Override
    public void addParams(CommandArguments args2) {
        if (this.expiration != null) {
            args2.add(this.expiration);
            if (this.expirationValue != null) {
                args2.add(this.expirationValue);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetExParams that = (GetExParams)o;
        return this.persist == that.persist && this.expiration == that.expiration && Objects.equals(this.expirationValue, that.expirationValue);
    }

    public int hashCode() {
        return Objects.hash(this.expiration, this.expirationValue, this.persist);
    }
}

