/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.args.SortingOrder;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.util.SafeEncoder;

public class SortingParams
implements IParams {
    private final List<Object> params = new ArrayList<Object>();

    public SortingParams by(String pattern2) {
        return this.by(SafeEncoder.encode(pattern2));
    }

    public SortingParams by(byte[] pattern2) {
        this.params.add(Protocol.Keyword.BY);
        this.params.add(pattern2);
        return this;
    }

    public SortingParams nosort() {
        this.params.add(Protocol.Keyword.BY);
        this.params.add(Protocol.Keyword.NOSORT);
        return this;
    }

    public SortingParams desc() {
        return this.sortingOrder(SortingOrder.DESC);
    }

    public SortingParams asc() {
        return this.sortingOrder(SortingOrder.ASC);
    }

    public SortingParams sortingOrder(SortingOrder order) {
        this.params.add(order.getRaw());
        return this;
    }

    public SortingParams limit(int start2, int count2) {
        this.params.add(Protocol.Keyword.LIMIT);
        this.params.add(start2);
        this.params.add(count2);
        return this;
    }

    public SortingParams alpha() {
        this.params.add(Protocol.Keyword.ALPHA);
        return this;
    }

    public SortingParams get(String ... patterns2) {
        for (String pattern2 : patterns2) {
            this.params.add(Protocol.Keyword.GET);
            this.params.add(pattern2);
        }
        return this;
    }

    public SortingParams get(byte[] ... patterns2) {
        for (byte[] pattern2 : patterns2) {
            this.params.add(Protocol.Keyword.GET);
            this.params.add(pattern2);
        }
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        args2.addObjects(this.params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortingParams that = (SortingParams)o;
        return Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hash(this.params);
    }
}

