/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.Objects;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.args.RawableFactory;
import redis.clients.jedis.params.IParams;

public class XPendingParams
implements IParams {
    private Long idle;
    private Rawable start;
    private Rawable end;
    private Integer count;
    private Rawable consumer;

    public XPendingParams(StreamEntryID start2, StreamEntryID end2, int count2) {
        this(start2.toString(), end2.toString(), count2);
    }

    public XPendingParams(String start2, String end2, int count2) {
        this(RawableFactory.from(start2), RawableFactory.from(end2), (Integer)count2);
    }

    public XPendingParams(byte[] start2, byte[] end2, int count2) {
        this(RawableFactory.from(start2), RawableFactory.from(end2), (Integer)count2);
    }

    private XPendingParams(Rawable start2, Rawable end2, Integer count2) {
        this.start = start2;
        this.end = end2;
        this.count = count2;
    }

    public XPendingParams() {
        this.start = null;
        this.end = null;
        this.count = null;
    }

    public static XPendingParams xPendingParams(StreamEntryID start2, StreamEntryID end2, int count2) {
        return new XPendingParams(start2, end2, count2);
    }

    public static XPendingParams xPendingParams(String start2, String end2, int count2) {
        return new XPendingParams(start2, end2, count2);
    }

    public static XPendingParams xPendingParams(byte[] start2, byte[] end2, int count2) {
        return new XPendingParams(start2, end2, count2);
    }

    public static XPendingParams xPendingParams() {
        return new XPendingParams();
    }

    public XPendingParams idle(long idle) {
        this.idle = idle;
        return this;
    }

    public XPendingParams start(StreamEntryID start2) {
        this.start = RawableFactory.from(start2.toString());
        return this;
    }

    public XPendingParams end(StreamEntryID end2) {
        this.end = RawableFactory.from(end2.toString());
        return this;
    }

    public XPendingParams count(int count2) {
        this.count = count2;
        return this;
    }

    public XPendingParams consumer(String consumer2) {
        this.consumer = RawableFactory.from(consumer2);
        return this;
    }

    public XPendingParams consumer(byte[] consumer2) {
        this.consumer = RawableFactory.from(consumer2);
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        if (this.count == null) {
            throw new IllegalArgumentException("start, end and count must be set.");
        }
        if (this.start == null) {
            this.start = RawableFactory.from("-");
        }
        if (this.end == null) {
            this.end = RawableFactory.from("+");
        }
        if (this.idle != null) {
            args2.add(Protocol.Keyword.IDLE).add(this.idle);
        }
        args2.add(this.start).add(this.end).add(this.count);
        if (this.consumer != null) {
            args2.add(this.consumer);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XPendingParams that = (XPendingParams)o;
        return Objects.equals(this.idle, that.idle) && Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end) && Objects.equals(this.count, that.count) && Objects.equals(this.consumer, that.consumer);
    }

    public int hashCode() {
        return Objects.hash(this.idle, this.start, this.end, this.count, this.consumer);
    }
}

