/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.util.SafeEncoder;

public class ZParams
implements IParams {
    private final List<Object> params = new ArrayList<Object>();

    public ZParams weights(double ... weights) {
        this.params.add(Protocol.Keyword.WEIGHTS);
        for (double weight : weights) {
            this.params.add(weight);
        }
        return this;
    }

    public ZParams aggregate(Aggregate aggregate) {
        this.params.add(Protocol.Keyword.AGGREGATE);
        this.params.add(aggregate);
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        args2.addObjects(this.params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZParams zParams = (ZParams)o;
        return Objects.equals(this.params, zParams.params);
    }

    public int hashCode() {
        return Objects.hash(this.params);
    }

    public static enum Aggregate implements Rawable
    {
        SUM,
        MIN,
        MAX;

        private final byte[] raw = SafeEncoder.encode(this.name());

        @Override
        public byte[] getRaw() {
            return this.raw;
        }
    }
}

