/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.Objects;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.args.RawableFactory;
import redis.clients.jedis.params.IParams;

public class ZRangeParams
implements IParams {
    private final Protocol.Keyword by;
    private final Rawable min;
    private final Rawable max;
    private boolean rev = false;
    private boolean limit = false;
    private int offset;
    private int count;

    private ZRangeParams() {
        throw new InstantiationError("Empty constructor must not be called.");
    }

    public ZRangeParams(int min2, int max2) {
        this.by = null;
        this.min = RawableFactory.from(min2);
        this.max = RawableFactory.from(max2);
    }

    public static ZRangeParams zrangeParams(int min2, int max2) {
        return new ZRangeParams(min2, max2);
    }

    public ZRangeParams(double min2, double max2) {
        this.by = Protocol.Keyword.BYSCORE;
        this.min = RawableFactory.from(min2);
        this.max = RawableFactory.from(max2);
    }

    public static ZRangeParams zrangeByScoreParams(double min2, double max2) {
        return new ZRangeParams(min2, max2);
    }

    private ZRangeParams(Protocol.Keyword by, Rawable min2, Rawable max2) {
        if (by != null && by != Protocol.Keyword.BYSCORE && by != Protocol.Keyword.BYLEX) {
            throw new IllegalArgumentException(by.name() + " is not a valid ZRANGE type argument.");
        }
        this.by = by;
        this.min = min2;
        this.max = max2;
    }

    public ZRangeParams(Protocol.Keyword by, String min2, String max2) {
        this(by, RawableFactory.from(min2), RawableFactory.from(max2));
    }

    public ZRangeParams(Protocol.Keyword by, byte[] min2, byte[] max2) {
        this(by, RawableFactory.from(min2), RawableFactory.from(max2));
    }

    public static ZRangeParams zrangeByLexParams(String min2, String max2) {
        return new ZRangeParams(Protocol.Keyword.BYLEX, min2, max2);
    }

    public static ZRangeParams zrangeByLexParams(byte[] min2, byte[] max2) {
        return new ZRangeParams(Protocol.Keyword.BYLEX, min2, max2);
    }

    public ZRangeParams rev() {
        this.rev = true;
        return this;
    }

    public ZRangeParams limit(int offset, int count2) {
        this.limit = true;
        this.offset = offset;
        this.count = count2;
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        args2.add(this.min).add(this.max);
        if (this.by != null) {
            args2.add(this.by);
        }
        if (this.rev) {
            args2.add(Protocol.Keyword.REV);
        }
        if (this.limit) {
            args2.add(Protocol.Keyword.LIMIT).add(this.offset).add(this.count);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZRangeParams that = (ZRangeParams)o;
        return this.rev == that.rev && this.limit == that.limit && this.offset == that.offset && this.count == that.count && this.by == that.by && Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }

    public int hashCode() {
        return Objects.hash(this.by, this.min, this.max, this.rev, this.limit, this.offset, this.count);
    }
}

