/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.resps;

import java.util.Collections;
import java.util.List;

public class LCSMatchResult {
    private String matchString;
    private List<MatchedPosition> matches;
    private long len;

    public LCSMatchResult(String matchString) {
        this.matchString = matchString;
    }

    public LCSMatchResult(long len2) {
        this.len = len2;
    }

    public LCSMatchResult(List<MatchedPosition> matches2, long len2) {
        this.matches = matches2;
        this.len = len2;
    }

    public LCSMatchResult(String matchString, List<MatchedPosition> matches2, long len2) {
        this.matchString = matchString;
        this.matches = Collections.unmodifiableList(matches2);
        this.len = len2;
    }

    public String getMatchString() {
        return this.matchString;
    }

    public List<MatchedPosition> getMatches() {
        return this.matches;
    }

    public long getLen() {
        return this.len;
    }

    public static class Position {
        private final long start;
        private final long end;

        public Position(long start2, long end2) {
            this.start = start2;
            this.end = end2;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }
    }

    public static class MatchedPosition {
        private final Position a;
        private final Position b;
        private final long matchLen;

        public MatchedPosition(Position a2, Position b2, long matchLen) {
            this.a = a2;
            this.b = b2;
            this.matchLen = matchLen;
        }

        public Position getA() {
            return this.a;
        }

        public Position getB() {
            return this.b;
        }

        public long getMatchLen() {
            return this.matchLen;
        }
    }
}

