/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.resps;

import java.util.List;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.util.SafeEncoder;

public class ScanResult<T> {
    private byte[] cursor;
    private List<T> results;

    public ScanResult(String cursor, List<T> results2) {
        this(SafeEncoder.encode(cursor), results2);
    }

    public ScanResult(byte[] cursor, List<T> results2) {
        this.cursor = cursor;
        this.results = results2;
    }

    public String getCursor() {
        return SafeEncoder.encode(this.cursor);
    }

    public boolean isCompleteIteration() {
        return ScanParams.SCAN_POINTER_START.equals(this.getCursor());
    }

    public byte[] getCursorAsBytes() {
        return this.cursor;
    }

    public List<T> getResult() {
        return this.results;
    }
}

