/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.resps;

import java.util.Collections;
import java.util.List;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.util.KeyValue;

public class TrackingInfo {
    private final List<String> flags;
    private final long redirect;
    private final List<String> prefixes;
    public static final Builder<TrackingInfo> TRACKING_INFO_BUILDER = new Builder<TrackingInfo>(){

        @Override
        public TrackingInfo build(Object data2) {
            List commandData = (List)data2;
            if (commandData.get(0) instanceof KeyValue) {
                List<String> flags = Collections.emptyList();
                long redirect = -1L;
                List<String> prefixes2 = Collections.emptyList();
                for (KeyValue kv : commandData) {
                    switch (BuilderFactory.STRING.build(kv.getKey())) {
                        case "flags": {
                            flags = BuilderFactory.STRING_LIST.build(kv.getValue());
                            break;
                        }
                        case "redirect": {
                            redirect = BuilderFactory.LONG.build(kv.getValue());
                            break;
                        }
                        case "prefixes": {
                            prefixes2 = BuilderFactory.STRING_LIST.build(kv.getValue());
                        }
                    }
                }
                return new TrackingInfo(flags, redirect, prefixes2);
            }
            List<String> flags = BuilderFactory.STRING_LIST.build(commandData.get(1));
            long redirect = BuilderFactory.LONG.build(commandData.get(3));
            List<String> prefixes3 = BuilderFactory.STRING_LIST.build(commandData.get(5));
            return new TrackingInfo(flags, redirect, prefixes3);
        }
    };

    public TrackingInfo(List<String> flags, long redirect, List<String> prefixes2) {
        this.flags = flags;
        this.redirect = redirect;
        this.prefixes = prefixes2;
    }

    public List<String> getFlags() {
        return this.flags;
    }

    public long getRedirect() {
        return this.redirect;
    }

    public List<String> getPrefixes() {
        return this.prefixes;
    }
}

