/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.util.KeyValue;
import redis.clients.jedis.util.SafeEncoder;

public class Document
implements Serializable {
    private static final long serialVersionUID = 4884173545291367373L;
    private final String id;
    private Double score;
    private final Map<String, Object> fields;
    static Builder<Document> SEARCH_DOCUMENT = new PerFieldDecoderDocumentBuilder(null);

    public Document(String id) {
        this(id, 1.0);
    }

    public Document(String id, double score) {
        this(id, new HashMap<String, Object>(), score);
    }

    public Document(String id, Map<String, Object> fields2) {
        this(id, fields2, 1.0);
    }

    public Document(String id, Map<String, Object> fields2, double score) {
        this.id = id;
        this.fields = fields2;
        this.score = score;
    }

    private Document(String id, Double score, Map<String, Object> fields2) {
        this.id = id;
        this.score = score;
        this.fields = fields2;
    }

    public Iterable<Map.Entry<String, Object>> getProperties() {
        return this.fields.entrySet();
    }

    public String getId() {
        return this.id;
    }

    public Double getScore() {
        return this.score;
    }

    public Object get(String key2) {
        return this.fields.get(key2);
    }

    public String getString(String key2) {
        Object value2 = this.fields.get(key2);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof String) {
            return (String)value2;
        }
        if (value2 instanceof byte[]) {
            return SafeEncoder.encode((byte[])value2);
        }
        return String.valueOf(value2);
    }

    public boolean hasProperty(String key2) {
        return this.fields.containsKey(key2);
    }

    public Document set(String key2, Object value2) {
        this.fields.put(key2, value2);
        return this;
    }

    @Deprecated
    public Document setScore(float score) {
        this.score = score;
        return this;
    }

    public String toString() {
        return "id:" + this.getId() + ", score: " + this.getScore() + ", properties:" + this.getProperties();
    }

    public static Document load(String id, double score, byte[] payload, List<byte[]> fields2) {
        return Document.load(id, score, fields2, true);
    }

    public static Document load(String id, double score, List<byte[]> fields2, boolean decode) {
        return Document.load(id, score, fields2, decode, null);
    }

    public static Document load(String id, double score, List<byte[]> fields2, boolean decode, Map<String, Boolean> isFieldDecode) {
        Document ret = new Document(id, score);
        if (fields2 != null) {
            for (int i2 = 0; i2 < fields2.size(); i2 += 2) {
                byte[] rawKey = fields2.get(i2);
                byte[] rawValue = fields2.get(i2 + 1);
                String key2 = SafeEncoder.encode(rawKey);
                byte[] value2 = rawValue == null ? null : (decode && (isFieldDecode == null || !Boolean.FALSE.equals(isFieldDecode.get(key2))) ? (Object)SafeEncoder.encode(rawValue) : rawValue);
                ret.set(key2, value2);
            }
        }
        return ret;
    }

    private static Map<String, Object> makeFieldsMap(Map<String, Boolean> isDecode, Object data2) {
        if (data2 == null) {
            return null;
        }
        List list = (List)data2;
        HashMap<String, Object> map2 = new HashMap<String, Object>(list.size(), 1.0f);
        list.stream().filter(kv -> kv != null && kv.getKey() != null && kv.getValue() != null).forEach(kv -> {
            String key2;
            map2.put(key2, (Boolean.FALSE.equals(isDecode.get(key2 = BuilderFactory.STRING.build(kv.getKey()))) ? BuilderFactory.RAW_OBJECT : BuilderFactory.AGGRESSIVE_ENCODED_OBJECT).build(kv.getValue()));
        });
        return map2;
    }

    static final class PerFieldDecoderDocumentBuilder
    extends Builder<Document> {
        private static final String ID_STR = "id";
        private static final String SCORE_STR = "score";
        private static final String FIELDS_STR = "extra_attributes";
        private final Map<String, Boolean> isFieldDecode;

        public PerFieldDecoderDocumentBuilder(Map<String, Boolean> isFieldDecode) {
            this.isFieldDecode = isFieldDecode != null ? isFieldDecode : Collections.emptyMap();
        }

        @Override
        public Document build(Object data2) {
            List list = (List)data2;
            String id = null;
            Double score = null;
            Map fields2 = null;
            for (KeyValue kv : list) {
                String key2;
                switch (key2 = BuilderFactory.STRING.build(kv.getKey())) {
                    case "id": {
                        id = BuilderFactory.STRING.build(kv.getValue());
                        break;
                    }
                    case "score": {
                        score = BuilderFactory.DOUBLE.build(kv.getValue());
                        break;
                    }
                    case "extra_attributes": {
                        fields2 = Document.makeFieldsMap(this.isFieldDecode, kv.getValue());
                    }
                }
            }
            return new Document(id, score, fields2);
        }
    }
}

