/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.annots.Internal;
import redis.clients.jedis.args.GeoUnit;
import redis.clients.jedis.args.SortingOrder;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.search.FieldName;
import redis.clients.jedis.search.SearchProtocol;
import redis.clients.jedis.util.LazyRawable;

public class FTSearchParams
implements IParams {
    private boolean noContent = false;
    private boolean verbatim = false;
    private boolean noStopwords = false;
    private boolean withScores = false;
    private final List<IParams> filters = new LinkedList<IParams>();
    private Collection<String> inKeys;
    private Collection<String> inFields;
    private Collection<FieldName> returnFieldsNames;
    private boolean summarize;
    private SummarizeParams summarizeParams;
    private boolean highlight;
    private HighlightParams highlightParams;
    private Integer slop;
    private Long timeout;
    private boolean inOrder;
    private String language;
    private String expander;
    private String scorer;
    private String sortBy;
    private SortingOrder sortOrder;
    private int[] limit;
    private Map<String, Object> params;
    private Integer dialect;
    private Map<String, Boolean> returnFieldDecodeMap = null;

    public static FTSearchParams searchParams() {
        return new FTSearchParams();
    }

    @Override
    public void addParams(CommandArguments args2) {
        if (this.noContent) {
            args2.add(SearchProtocol.SearchKeyword.NOCONTENT);
        }
        if (this.verbatim) {
            args2.add(SearchProtocol.SearchKeyword.VERBATIM);
        }
        if (this.noStopwords) {
            args2.add(SearchProtocol.SearchKeyword.NOSTOPWORDS);
        }
        if (this.withScores) {
            args2.add(SearchProtocol.SearchKeyword.WITHSCORES);
        }
        if (!this.filters.isEmpty()) {
            this.filters.forEach(filter2 -> filter2.addParams(args2));
        }
        if (this.inKeys != null && !this.inKeys.isEmpty()) {
            args2.add(SearchProtocol.SearchKeyword.INKEYS).add(this.inKeys.size()).addObjects(this.inKeys);
        }
        if (this.inFields != null && !this.inFields.isEmpty()) {
            args2.add(SearchProtocol.SearchKeyword.INFIELDS).add(this.inFields.size()).addObjects(this.inFields);
        }
        if (this.returnFieldsNames != null && !this.returnFieldsNames.isEmpty()) {
            args2.add(SearchProtocol.SearchKeyword.RETURN);
            LazyRawable returnCountObject = new LazyRawable();
            args2.add(returnCountObject);
            int returnCount = 0;
            for (FieldName fn : this.returnFieldsNames) {
                returnCount += fn.addCommandArguments(args2);
            }
            returnCountObject.setRaw(Protocol.toByteArray(returnCount));
        }
        if (this.summarizeParams != null) {
            args2.addParams(this.summarizeParams);
        } else if (this.summarize) {
            args2.add(SearchProtocol.SearchKeyword.SUMMARIZE);
        }
        if (this.highlightParams != null) {
            args2.addParams(this.highlightParams);
        } else if (this.highlight) {
            args2.add(SearchProtocol.SearchKeyword.HIGHLIGHT);
        }
        if (this.slop != null) {
            args2.add(SearchProtocol.SearchKeyword.SLOP).add(this.slop);
        }
        if (this.timeout != null) {
            args2.add(SearchProtocol.SearchKeyword.TIMEOUT).add(this.timeout);
        }
        if (this.inOrder) {
            args2.add(SearchProtocol.SearchKeyword.INORDER);
        }
        if (this.language != null) {
            args2.add(SearchProtocol.SearchKeyword.LANGUAGE).add(this.language);
        }
        if (this.expander != null) {
            args2.add(SearchProtocol.SearchKeyword.EXPANDER).add(this.expander);
        }
        if (this.scorer != null) {
            args2.add(SearchProtocol.SearchKeyword.SCORER).add(this.scorer);
        }
        if (this.sortBy != null) {
            args2.add(SearchProtocol.SearchKeyword.SORTBY).add(this.sortBy);
            if (this.sortOrder != null) {
                args2.add(this.sortOrder);
            }
        }
        if (this.limit != null) {
            args2.add(SearchProtocol.SearchKeyword.LIMIT).add(this.limit[0]).add(this.limit[1]);
        }
        if (this.params != null && !this.params.isEmpty()) {
            args2.add(SearchProtocol.SearchKeyword.PARAMS).add(this.params.size() << 1);
            this.params.entrySet().forEach(entry -> args2.add((String)entry.getKey()).add(entry.getValue()));
        }
        if (this.dialect != null) {
            args2.add(SearchProtocol.SearchKeyword.DIALECT).add(this.dialect);
        }
    }

    public FTSearchParams noContent() {
        this.noContent = true;
        return this;
    }

    public FTSearchParams verbatim() {
        this.verbatim = true;
        return this;
    }

    public FTSearchParams noStopwords() {
        this.noStopwords = true;
        return this;
    }

    public FTSearchParams withScores() {
        this.withScores = true;
        return this;
    }

    public FTSearchParams filter(String field, double min2, double max2) {
        return this.filter(new NumericFilter(field, min2, max2));
    }

    public FTSearchParams filter(String field, double min2, boolean exclusiveMin, double max2, boolean exclusiveMax) {
        return this.filter(new NumericFilter(field, min2, exclusiveMin, max2, exclusiveMax));
    }

    public FTSearchParams filter(NumericFilter numericFilter) {
        this.filters.add(numericFilter);
        return this;
    }

    public FTSearchParams geoFilter(String field, double lon, double lat, double radius, GeoUnit unit) {
        return this.geoFilter(new GeoFilter(field, lon, lat, radius, unit));
    }

    public FTSearchParams geoFilter(GeoFilter geoFilter) {
        this.filters.add(geoFilter);
        return this;
    }

    public FTSearchParams inKeys(String ... keys2) {
        return this.inKeys(Arrays.asList(keys2));
    }

    public FTSearchParams inKeys(Collection<String> keys2) {
        this.inKeys = keys2;
        return this;
    }

    public FTSearchParams inFields(String ... fields2) {
        return this.inFields(Arrays.asList(fields2));
    }

    public FTSearchParams inFields(Collection<String> fields2) {
        if (this.inFields == null) {
            this.inFields = new ArrayList<String>(fields2);
        } else {
            this.inFields.addAll(fields2);
        }
        return this;
    }

    public FTSearchParams returnFields(String ... fields2) {
        if (this.returnFieldsNames == null) {
            this.returnFieldsNames = new ArrayList<FieldName>();
        }
        Arrays.stream(fields2).forEach(f2 -> this.returnFieldsNames.add(FieldName.of(f2)));
        return this;
    }

    public FTSearchParams returnField(FieldName field) {
        return this.returnFields(Collections.singleton(field));
    }

    public FTSearchParams returnFields(FieldName ... fields2) {
        return this.returnFields(Arrays.asList(fields2));
    }

    public FTSearchParams returnFields(Collection<FieldName> fields2) {
        if (this.returnFieldsNames == null) {
            this.returnFieldsNames = new ArrayList<FieldName>();
        }
        this.returnFieldsNames.addAll(fields2);
        return this;
    }

    public FTSearchParams returnField(String field, boolean decode) {
        this.returnFields(field);
        this.addReturnFieldDecode(field, decode);
        return this;
    }

    public FTSearchParams returnField(FieldName field, boolean decode) {
        this.returnFields(field);
        this.addReturnFieldDecode(field.getAttribute() != null ? field.getAttribute() : field.getName(), decode);
        return this;
    }

    private void addReturnFieldDecode(String returnName, boolean decode) {
        if (this.returnFieldDecodeMap == null) {
            this.returnFieldDecodeMap = new HashMap<String, Boolean>();
        }
        this.returnFieldDecodeMap.put(returnName, decode);
    }

    public FTSearchParams summarize() {
        this.summarize = true;
        return this;
    }

    public FTSearchParams summarize(SummarizeParams summarizeParams) {
        this.summarizeParams = summarizeParams;
        return this;
    }

    public FTSearchParams highlight() {
        this.highlight = true;
        return this;
    }

    public FTSearchParams highlight(HighlightParams highlightParams) {
        this.highlightParams = highlightParams;
        return this;
    }

    public FTSearchParams scorer(String scorer) {
        this.scorer = scorer;
        return this;
    }

    public FTSearchParams slop(int slop) {
        this.slop = slop;
        return this;
    }

    public FTSearchParams timeout(long timeout2) {
        this.timeout = timeout2;
        return this;
    }

    public FTSearchParams inOrder() {
        this.inOrder = true;
        return this;
    }

    public FTSearchParams language(String language) {
        this.language = language;
        return this;
    }

    public FTSearchParams sortBy(String sortBy2, SortingOrder order) {
        this.sortBy = sortBy2;
        this.sortOrder = order;
        return this;
    }

    public FTSearchParams limit(int offset, int num) {
        this.limit = new int[]{offset, num};
        return this;
    }

    public FTSearchParams addParam(String name, Object value2) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(name, value2);
        return this;
    }

    public FTSearchParams params(Map<String, Object> paramValues) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>(paramValues);
        } else {
            this.params.putAll(this.params);
        }
        return this;
    }

    public FTSearchParams dialect(int dialect) {
        this.dialect = dialect;
        return this;
    }

    @Internal
    public FTSearchParams dialectOptional(int dialect) {
        if (dialect != 0 && this.dialect == null) {
            this.dialect = dialect;
        }
        return this;
    }

    @Internal
    public boolean getNoContent() {
        return this.noContent;
    }

    @Internal
    public boolean getWithScores() {
        return this.withScores;
    }

    @Internal
    public Map<String, Boolean> getReturnFieldDecodeMap() {
        return this.returnFieldDecodeMap;
    }

    public static SummarizeParams summarizeParams() {
        return new SummarizeParams();
    }

    public static HighlightParams highlightParams() {
        return new HighlightParams();
    }

    public static class HighlightParams
    implements IParams {
        private Collection<String> fields;
        private String[] tags;

        public HighlightParams fields(String fields2) {
            return this.fields(Arrays.asList(fields2));
        }

        public HighlightParams fields(Collection<String> fields2) {
            this.fields = fields2;
            return this;
        }

        public HighlightParams tags(String open, String close2) {
            this.tags = new String[]{open, close2};
            return this;
        }

        @Override
        public void addParams(CommandArguments args2) {
            args2.add(SearchProtocol.SearchKeyword.HIGHLIGHT);
            if (this.fields != null) {
                args2.add(SearchProtocol.SearchKeyword.FIELDS).add(this.fields.size()).addObjects(this.fields);
            }
            if (this.tags != null) {
                args2.add(SearchProtocol.SearchKeyword.TAGS).add(this.tags[0]).add(this.tags[1]);
            }
        }
    }

    public static class SummarizeParams
    implements IParams {
        private Collection<String> fields;
        private Integer fragsNum;
        private Integer fragSize;
        private String separator;

        public SummarizeParams fields(String ... fields2) {
            return this.fields(Arrays.asList(fields2));
        }

        public SummarizeParams fields(Collection<String> fields2) {
            this.fields = fields2;
            return this;
        }

        public SummarizeParams fragsNum(int num) {
            this.fragsNum = num;
            return this;
        }

        public SummarizeParams fragSize(int size2) {
            this.fragSize = size2;
            return this;
        }

        public SummarizeParams separator(String separator) {
            this.separator = separator;
            return this;
        }

        @Override
        public void addParams(CommandArguments args2) {
            args2.add(SearchProtocol.SearchKeyword.SUMMARIZE);
            if (this.fields != null) {
                args2.add(SearchProtocol.SearchKeyword.FIELDS).add(this.fields.size()).addObjects(this.fields);
            }
            if (this.fragsNum != null) {
                args2.add(SearchProtocol.SearchKeyword.FRAGS).add(this.fragsNum);
            }
            if (this.fragSize != null) {
                args2.add(SearchProtocol.SearchKeyword.LEN).add(this.fragSize);
            }
            if (this.separator != null) {
                args2.add(SearchProtocol.SearchKeyword.SEPARATOR).add(this.separator);
            }
        }
    }

    public static class GeoFilter
    implements IParams {
        private final String field;
        private final double lon;
        private final double lat;
        private final double radius;
        private final GeoUnit unit;

        public GeoFilter(String field, double lon, double lat, double radius, GeoUnit unit) {
            this.field = field;
            this.lon = lon;
            this.lat = lat;
            this.radius = radius;
            this.unit = unit;
        }

        @Override
        public void addParams(CommandArguments args2) {
            args2.add(SearchProtocol.SearchKeyword.GEOFILTER).add(this.field).add(this.lon).add(this.lat).add(this.radius).add(this.unit);
        }
    }

    public static class NumericFilter
    implements IParams {
        private final String field;
        private final double min;
        private final boolean exclusiveMin;
        private final double max;
        private final boolean exclusiveMax;

        public NumericFilter(String field, double min2, double max2) {
            this(field, min2, false, max2, false);
        }

        public NumericFilter(String field, double min2, boolean exclusiveMin, double max2, boolean exclusiveMax) {
            this.field = field;
            this.min = min2;
            this.max = max2;
            this.exclusiveMax = exclusiveMax;
            this.exclusiveMin = exclusiveMin;
        }

        @Override
        public void addParams(CommandArguments args2) {
            args2.add(SearchProtocol.SearchKeyword.FILTER).add(this.field).add(this.formatNum(this.min, this.exclusiveMin)).add(this.formatNum(this.max, this.exclusiveMax));
        }

        private Object formatNum(double num, boolean exclude2) {
            return exclude2 ? (Object)("(" + num) : Protocol.toByteArray(num);
        }
    }
}

