/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import java.util.List;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.search.SearchProtocol;

public class FieldName
implements IParams {
    private final String name;
    private String attribute;

    public FieldName(String name) {
        this.name = name;
    }

    public FieldName(String name, String attribute) {
        this.name = name;
        this.attribute = attribute;
    }

    public FieldName as(String attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("Setting null as field attribute is not allowed.");
        }
        if (this.attribute != null) {
            throw new IllegalStateException("Attribute for this field is already set.");
        }
        this.attribute = attribute;
        return this;
    }

    public final String getName() {
        return this.name;
    }

    public final String getAttribute() {
        return this.attribute;
    }

    public int addCommandArguments(List<Object> args2) {
        args2.add(this.name);
        if (this.attribute == null) {
            return 1;
        }
        args2.add(SearchProtocol.SearchKeyword.AS);
        args2.add(this.attribute);
        return 3;
    }

    public int addCommandArguments(CommandArguments args2) {
        args2.add(this.name);
        if (this.attribute == null) {
            return 1;
        }
        args2.add(SearchProtocol.SearchKeyword.AS);
        args2.add(this.attribute);
        return 3;
    }

    @Override
    public void addParams(CommandArguments args2) {
        this.addCommandArguments(args2);
    }

    public String toString() {
        return this.attribute == null ? this.name : this.name + " AS " + this.attribute;
    }

    public static FieldName of(String name) {
        return new FieldName(name);
    }

    public static FieldName[] convert(String ... names2) {
        if (names2 == null) {
            return null;
        }
        FieldName[] fields2 = new FieldName[names2.length];
        for (int i2 = 0; i2 < names2.length; ++i2) {
            fields2[i2] = FieldName.of(names2[i2]);
        }
        return fields2;
    }
}

