/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.search.SearchProtocol;

public class IndexDefinition
implements IParams {
    private final Type type;
    private String[] prefixes;
    private String filter;
    private String languageField;
    private String language;
    private String scoreFiled;
    private double score = 1.0;

    public IndexDefinition() {
        this(null);
    }

    public IndexDefinition(Type type2) {
        this.type = type2;
    }

    public Type getType() {
        return this.type;
    }

    public String[] getPrefixes() {
        return this.prefixes;
    }

    public IndexDefinition setPrefixes(String ... prefixes2) {
        this.prefixes = prefixes2;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public IndexDefinition setFilter(String filter2) {
        this.filter = filter2;
        return this;
    }

    public String getLanguageField() {
        return this.languageField;
    }

    public IndexDefinition setLanguageField(String languageField) {
        this.languageField = languageField;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public IndexDefinition setLanguage(String language) {
        this.language = language;
        return this;
    }

    public String getScoreFiled() {
        return this.scoreFiled;
    }

    public IndexDefinition setScoreFiled(String scoreFiled) {
        this.scoreFiled = scoreFiled;
        return this;
    }

    public double getScore() {
        return this.score;
    }

    public IndexDefinition setScore(double score) {
        this.score = score;
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        if (this.type != null) {
            args2.add(SearchProtocol.SearchKeyword.ON.name());
            args2.add(this.type.name());
        }
        if (this.prefixes != null && this.prefixes.length > 0) {
            args2.add(SearchProtocol.SearchKeyword.PREFIX.name());
            args2.add(Integer.toString(this.prefixes.length));
            args2.addObjects(this.prefixes);
        }
        if (this.filter != null) {
            args2.add(SearchProtocol.SearchKeyword.FILTER.name());
            args2.add(this.filter);
        }
        if (this.languageField != null) {
            args2.add(SearchProtocol.SearchKeyword.LANGUAGE_FIELD.name());
            args2.add(this.languageField);
        }
        if (this.language != null) {
            args2.add(SearchProtocol.SearchKeyword.LANGUAGE.name());
            args2.add(this.language);
        }
        if (this.scoreFiled != null) {
            args2.add(SearchProtocol.SearchKeyword.SCORE_FIELD.name());
            args2.add(this.scoreFiled);
        }
        if (this.score != 1.0) {
            args2.add(SearchProtocol.SearchKeyword.SCORE.name());
            args2.add(Double.toString(this.score));
        }
    }

    public static enum Type {
        HASH,
        JSON;

    }
}

