/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.util.DoublePrecision;
import redis.clients.jedis.util.KeyValue;
import redis.clients.jedis.util.SafeEncoder;

public final class SearchBuilderFactory {
    public static final Builder<Map<String, Object>> SEARCH_PROFILE_PROFILE = new Builder<Map<String, Object>>(){
        private final String ITERATORS_PROFILE_STR = "Iterators profile";
        private final String CHILD_ITERATORS_STR = "Child iterators";
        private final String RESULT_PROCESSORS_PROFILE_STR = "Result processors profile";

        @Override
        public Map<String, Object> build(Object data2) {
            List list = (List)SafeEncoder.encodeObject(data2);
            HashMap<String, Object> profileMap = new HashMap<String, Object>(list.size(), 1.0f);
            for (Object listObject : list) {
                Object attributeValue;
                List attributeList = (List)listObject;
                String attributeName = (String)attributeList.get(0);
                if (attributeList.size() == 2) {
                    Object value2 = attributeList.get(1);
                    attributeValue = attributeName.equals("Iterators profile") ? this.parseIterators(value2) : (attributeName.endsWith(" time") ? DoublePrecision.parseEncodedFloatingPointNumber(value2) : value2);
                } else if (attributeList.size() > 2) {
                    if (attributeName.equals("Result processors profile")) {
                        ArrayList<Map<String, Object>> resultProcessorsProfileList = new ArrayList<Map<String, Object>>(attributeList.size() - 1);
                        for (int i2 = 1; i2 < attributeList.size(); ++i2) {
                            resultProcessorsProfileList.add(this.parseResultProcessors(attributeList.get(i2)));
                        }
                        attributeValue = resultProcessorsProfileList;
                    } else {
                        attributeValue = attributeList.subList(1, attributeList.size());
                    }
                } else {
                    attributeValue = null;
                }
                profileMap.put(attributeName, attributeValue);
            }
            return profileMap;
        }

        private Map<String, Object> parseResultProcessors(Object data2) {
            List list = (List)data2;
            HashMap<String, Object> map2 = new HashMap<String, Object>(list.size() / 2, 1.0f);
            for (int i2 = 0; i2 < list.size(); i2 += 2) {
                String key2 = (String)list.get(i2);
                Object value2 = list.get(i2 + 1);
                if (key2.equals("Time")) {
                    value2 = DoublePrecision.parseEncodedFloatingPointNumber(value2);
                }
                map2.put(key2, value2);
            }
            return map2;
        }

        private Object parseIterators(Object data2) {
            HashMap<String, Object> iteratorsProfile;
            if (!(data2 instanceof List)) {
                return data2;
            }
            List iteratorsAttributeList = (List)data2;
            int childIteratorsIndex = iteratorsAttributeList.indexOf("Child iterators");
            if (childIteratorsIndex < 0) {
                childIteratorsIndex = iteratorsAttributeList.indexOf("Child iterator");
            }
            if (childIteratorsIndex < 0) {
                childIteratorsIndex = iteratorsAttributeList.size();
                iteratorsProfile = new HashMap(childIteratorsIndex / 2, 1.0f);
            } else {
                iteratorsProfile = new HashMap<String, Object>(1 + childIteratorsIndex / 2, 1.0f);
            }
            for (int i2 = 0; i2 < childIteratorsIndex; i2 += 2) {
                String key2 = (String)iteratorsAttributeList.get(i2);
                Object value2 = iteratorsAttributeList.get(i2 + 1);
                if (key2.equals("Time")) {
                    value2 = DoublePrecision.parseEncodedFloatingPointNumber(value2);
                }
                iteratorsProfile.put(key2, value2);
            }
            if (childIteratorsIndex + 1 < iteratorsAttributeList.size()) {
                ArrayList<Object> childIteratorsList = new ArrayList<Object>(iteratorsAttributeList.size() - childIteratorsIndex - 1);
                for (int i3 = childIteratorsIndex + 1; i3 < iteratorsAttributeList.size(); ++i3) {
                    childIteratorsList.add(this.parseIterators(iteratorsAttributeList.get(i3)));
                }
                iteratorsProfile.put("Child iterators", childIteratorsList);
            }
            return iteratorsProfile;
        }
    };
    public static final Builder<Map<String, List<String>>> SEARCH_SYNONYM_GROUPS = new Builder<Map<String, List<String>>>(){

        @Override
        public Map<String, List<String>> build(Object data2) {
            List list = (List)data2;
            if (list.isEmpty()) {
                return Collections.emptyMap();
            }
            if (list.get(0) instanceof KeyValue) {
                return ((List)data2).stream().collect(Collectors.toMap(kv -> BuilderFactory.STRING.build(kv.getKey()), kv -> BuilderFactory.STRING_LIST.build(kv.getValue())));
            }
            HashMap<String, List<String>> dump2 = new HashMap<String, List<String>>(list.size() / 2, 1.0f);
            for (int i2 = 0; i2 < list.size(); i2 += 2) {
                dump2.put(BuilderFactory.STRING.build(list.get(i2)), BuilderFactory.STRING_LIST.build(list.get(i2 + 1)));
            }
            return dump2;
        }
    };
    public static final Builder<Map<String, Map<String, Double>>> SEARCH_SPELLCHECK_RESPONSE = new Builder<Map<String, Map<String, Double>>>(){
        private static final String TERM = "TERM";
        private static final String RESULTS = "results";

        @Override
        public Map<String, Map<String, Double>> build(Object data2) {
            List rawDataList = (List)data2;
            if (rawDataList.isEmpty()) {
                return Collections.emptyMap();
            }
            if (rawDataList.get(0) instanceof KeyValue) {
                KeyValue rawData = (KeyValue)rawDataList.get(0);
                String header = BuilderFactory.STRING.build(rawData.getKey());
                if (!RESULTS.equals(header)) {
                    throw new IllegalStateException("Unrecognized header: " + header);
                }
                return ((List)rawData.getValue()).stream().collect(Collectors.toMap(rawTerm -> BuilderFactory.STRING.build(rawTerm.getKey()), rawTerm -> ((List)rawTerm.getValue()).stream().collect(Collectors.toMap(entry -> BuilderFactory.STRING.build(((KeyValue)entry.get(0)).getKey()), entry -> BuilderFactory.DOUBLE.build(((KeyValue)entry.get(0)).getValue()))), (x, y) -> x, LinkedHashMap::new));
            }
            LinkedHashMap<String, Map<String, Double>> returnTerms = new LinkedHashMap<String, Map<String, Double>>(rawDataList.size());
            for (Object rawData : rawDataList) {
                List rawElements = (List)rawData;
                String header = BuilderFactory.STRING.build(rawElements.get(0));
                if (!TERM.equals(header)) {
                    throw new IllegalStateException("Unrecognized header: " + header);
                }
                String term = BuilderFactory.STRING.build(rawElements.get(1));
                List list = (List)rawElements.get(2);
                LinkedHashMap entries2 = new LinkedHashMap(list.size());
                list.forEach(entry -> entries2.put(BuilderFactory.STRING.build(entry.get(1)), BuilderFactory.DOUBLE.build(entry.get(0))));
                returnTerms.put(term, entries2);
            }
            return returnTerms;
        }
    };

    private SearchBuilderFactory() {
        throw new InstantiationError("Must not instantiate this class");
    }
}

