/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.annots.Internal;
import redis.clients.jedis.search.Document;
import redis.clients.jedis.util.KeyValue;

public class SearchResult {
    private final long totalResults;
    private final List<Document> documents;
    public static Builder<SearchResult> SEARCH_RESULT_BUILDER = new PerFieldDecoderSearchResultBuilder(Document.SEARCH_DOCUMENT);

    private SearchResult(long totalResults, List<Document> documents) {
        this.totalResults = totalResults;
        this.documents = documents;
    }

    public long getTotalResults() {
        return this.totalResults;
    }

    public List<Document> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{Total results:" + this.totalResults + ", Documents:" + this.documents + "}";
    }

    @Internal
    public static final class PerFieldDecoderSearchResultBuilder
    extends Builder<SearchResult> {
        private static final String TOTAL_RESULTS_STR = "total_results";
        private static final String RESULTS_STR = "results";
        private final Builder<Document> documentBuilder;

        public PerFieldDecoderSearchResultBuilder(Map<String, Boolean> isFieldDecode) {
            this(new Document.PerFieldDecoderDocumentBuilder(isFieldDecode));
        }

        private PerFieldDecoderSearchResultBuilder(Builder<Document> builder) {
            this.documentBuilder = Objects.requireNonNull(builder);
        }

        @Override
        public SearchResult build(Object data2) {
            List list = (List)data2;
            long totalResults = -1L;
            List results2 = null;
            for (KeyValue kv : list) {
                String key2;
                switch (key2 = BuilderFactory.STRING.build(kv.getKey())) {
                    case "total_results": {
                        totalResults = BuilderFactory.LONG.build(kv.getValue());
                        break;
                    }
                    case "results": {
                        results2 = ((List)kv.getValue()).stream().map(this.documentBuilder::build).collect(Collectors.toList());
                    }
                }
            }
            return new SearchResult(totalResults, results2);
        }
    }

    public static class SearchResultBuilder
    extends Builder<SearchResult> {
        private final boolean hasContent;
        private final boolean hasScores;
        private final boolean decode;
        private final Map<String, Boolean> isFieldDecode;

        public SearchResultBuilder(boolean hasContent, boolean hasScores, boolean decode) {
            this(hasContent, hasScores, decode, null);
        }

        public SearchResultBuilder(boolean hasContent, boolean hasScores, boolean decode, Map<String, Boolean> isFieldDecode) {
            this.hasContent = hasContent;
            this.hasScores = hasScores;
            this.decode = decode;
            this.isFieldDecode = isFieldDecode;
        }

        @Override
        public SearchResult build(Object data2) {
            List resp = (List)data2;
            int step = 1;
            int scoreOffset = 0;
            int contentOffset = 1;
            if (this.hasScores) {
                ++step;
                scoreOffset = 1;
                ++contentOffset;
            }
            if (this.hasContent) {
                ++step;
            }
            long totalResults = (Long)resp.get(0);
            ArrayList<Document> documents = new ArrayList<Document>(resp.size() - 1);
            for (int i2 = 1; i2 < resp.size(); i2 += step) {
                String id = BuilderFactory.STRING.build(resp.get(i2));
                double score = this.hasScores ? BuilderFactory.DOUBLE.build(resp.get(i2 + scoreOffset)) : 1.0;
                List fields2 = this.hasContent ? (List)resp.get(i2 + contentOffset) : null;
                documents.add(Document.load(id, score, fields2, this.decode, this.isFieldDecode));
            }
            return new SearchResult(totalResults, documents);
        }
    }
}

