/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search.aggr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.search.aggr.Row;
import redis.clients.jedis.util.KeyValue;
import redis.clients.jedis.util.SafeEncoder;

public class AggregationResult {
    private final long totalResults;
    private final List<Map<String, Object>> results;
    private Long cursorId = -1L;
    public static final Builder<AggregationResult> SEARCH_AGGREGATION_RESULT = new Builder<AggregationResult>(){
        private static final String TOTAL_RESULTS_STR = "total_results";
        private static final String RESULTS_STR = "results";
        private static final String FIELDS_STR = "extra_attributes";

        @Override
        public AggregationResult build(Object data2) {
            List list = (List)data2;
            if (list.get(0) instanceof KeyValue) {
                List kvList = (List)data2;
                long totalResults = -1L;
                ArrayList<Map<String, Object>> results2 = null;
                for (KeyValue kv : kvList) {
                    String key2;
                    switch (key2 = BuilderFactory.STRING.build(kv.getKey())) {
                        case "total_results": {
                            totalResults = BuilderFactory.LONG.build(kv.getValue());
                            break;
                        }
                        case "results": {
                            List resList = (List)kv.getValue();
                            results2 = new ArrayList<Map<String, Object>>(resList.size());
                            block9: for (List rikv : resList) {
                                for (KeyValue ikv : rikv) {
                                    if (!FIELDS_STR.equals(BuilderFactory.STRING.build(ikv.getKey()))) continue;
                                    results2.add(BuilderFactory.ENCODED_OBJECT_MAP.build(ikv.getValue()));
                                    continue block9;
                                }
                            }
                            break;
                        }
                    }
                }
                return new AggregationResult(totalResults, results2);
            }
            list = (List)SafeEncoder.encodeObject(data2);
            long totalResults = (Long)list.get(0);
            ArrayList results3 = new ArrayList(list.size() - 1);
            for (int i2 = 1; i2 < list.size(); ++i2) {
                List mapList = (List)list.get(i2);
                HashMap map2 = new HashMap(mapList.size() / 2, 1.0f);
                for (int j2 = 0; j2 < mapList.size(); j2 += 2) {
                    Object r = mapList.get(j2);
                    if (r instanceof JedisDataException) {
                        throw (JedisDataException)r;
                    }
                    map2.put((String)r, mapList.get(j2 + 1));
                }
                results3.add(map2);
            }
            return new AggregationResult(totalResults, results3);
        }
    };
    public static final Builder<AggregationResult> SEARCH_AGGREGATION_RESULT_WITH_CURSOR = new Builder<AggregationResult>(){

        @Override
        public AggregationResult build(Object data2) {
            List list = (List)data2;
            AggregationResult r = SEARCH_AGGREGATION_RESULT.build(list.get(0));
            r.setCursorId((Long)list.get(1));
            return r;
        }
    };

    private AggregationResult(Object resp, long cursorId) {
        this(resp);
        this.cursorId = cursorId;
    }

    private AggregationResult(Object resp) {
        List list = (List)SafeEncoder.encodeObject(resp);
        this.totalResults = (Long)list.get(0);
        this.results = new ArrayList<Map<String, Object>>(list.size() - 1);
        for (int i2 = 1; i2 < list.size(); ++i2) {
            List mapList = (List)list.get(i2);
            HashMap map2 = new HashMap(mapList.size() / 2, 1.0f);
            for (int j2 = 0; j2 < mapList.size(); j2 += 2) {
                Object r = mapList.get(j2);
                if (r instanceof JedisDataException) {
                    throw (JedisDataException)r;
                }
                map2.put((String)r, mapList.get(j2 + 1));
            }
            this.results.add(map2);
        }
    }

    private AggregationResult(long totalResults, List<Map<String, Object>> results2) {
        this.totalResults = totalResults;
        this.results = results2;
    }

    private void setCursorId(Long cursorId) {
        this.cursorId = cursorId;
    }

    public Long getCursorId() {
        return this.cursorId;
    }

    public long getTotalResults() {
        return this.totalResults;
    }

    public List<Map<String, Object>> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public List<Row> getRows() {
        return this.results.stream().map(Row::new).collect(Collectors.toList());
    }

    public Row getRow(int index) {
        return new Row(this.results.get(index));
    }
}

