/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search.querybuilder;

import java.util.StringJoiner;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.args.GeoUnit;
import redis.clients.jedis.search.querybuilder.DoubleRangeValue;
import redis.clients.jedis.search.querybuilder.GeoValue;
import redis.clients.jedis.search.querybuilder.LongRangeValue;
import redis.clients.jedis.search.querybuilder.RangeValue;
import redis.clients.jedis.search.querybuilder.Value;

public class Values {
    private Values() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static Value value(final String s2) {
        return new ScalableValue(){

            @Override
            public String toString() {
                return s2;
            }
        };
    }

    public static GeoValue geo(GeoCoordinate coord, double radius, GeoUnit unit) {
        return new GeoValue(coord.getLongitude(), coord.getLatitude(), radius, unit);
    }

    public static RangeValue between(double from2, double to) {
        return new DoubleRangeValue(from2, to);
    }

    public static RangeValue between(int from2, int to) {
        return new LongRangeValue(from2, to);
    }

    public static RangeValue eq(double d2) {
        return new DoubleRangeValue(d2, d2);
    }

    public static RangeValue eq(int i2) {
        return new LongRangeValue(i2, i2);
    }

    public static RangeValue lt(double d2) {
        return new DoubleRangeValue(Double.NEGATIVE_INFINITY, d2).inclusiveMax(false);
    }

    public static RangeValue lt(int d2) {
        return new LongRangeValue(Long.MIN_VALUE, d2).inclusiveMax(false);
    }

    public static RangeValue gt(double d2) {
        return new DoubleRangeValue(d2, Double.POSITIVE_INFINITY).inclusiveMin(false);
    }

    public static RangeValue gt(int d2) {
        return new LongRangeValue(d2, Long.MAX_VALUE).inclusiveMin(false);
    }

    public static RangeValue le(double d2) {
        return Values.lt(d2).inclusiveMax(true);
    }

    public static RangeValue le(int d2) {
        return Values.lt(d2).inclusiveMax(true);
    }

    public static RangeValue ge(double d2) {
        return Values.gt(d2).inclusiveMin(true);
    }

    public static RangeValue ge(int d2) {
        return Values.gt(d2).inclusiveMin(true);
    }

    public static Value tags(String ... tags) {
        if (tags.length == 0) {
            throw new IllegalArgumentException("Must have at least one tag");
        }
        final StringJoiner sj = new StringJoiner(" | ");
        for (String s2 : tags) {
            sj.add(s2);
        }
        return new Value(){

            @Override
            public String toString() {
                return "{" + sj.toString() + "}";
            }
        };
    }

    private static abstract class ScalableValue
    extends Value {
        private ScalableValue() {
        }

        @Override
        public boolean isCombinable() {
            return true;
        }
    }
}

