/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search.schemafields;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.search.FieldName;
import redis.clients.jedis.search.SearchProtocol;
import redis.clients.jedis.search.schemafields.SchemaField;

public class GeoField
extends SchemaField {
    private boolean indexMissing;
    private boolean sortable;
    private boolean noIndex;

    public GeoField(String fieldName) {
        super(fieldName);
    }

    public GeoField(FieldName fieldName) {
        super(fieldName);
    }

    public static GeoField of(String fieldName) {
        return new GeoField(fieldName);
    }

    public static GeoField of(FieldName fieldName) {
        return new GeoField(fieldName);
    }

    @Override
    public GeoField as(String attribute) {
        super.as(attribute);
        return this;
    }

    public GeoField indexMissing() {
        this.indexMissing = true;
        return this;
    }

    public GeoField sortable() {
        this.sortable = true;
        return this;
    }

    public GeoField noIndex() {
        this.noIndex = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        args2.addParams(this.fieldName);
        args2.add(SearchProtocol.SearchKeyword.GEO);
        if (this.indexMissing) {
            args2.add(SearchProtocol.SearchKeyword.INDEXMISSING);
        }
        if (this.sortable) {
            args2.add(SearchProtocol.SearchKeyword.SORTABLE);
        }
        if (this.noIndex) {
            args2.add(SearchProtocol.SearchKeyword.NOINDEX);
        }
    }
}

