/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.timeseries;

import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.timeseries.AggregationType;
import redis.clients.jedis.timeseries.TSElement;
import redis.clients.jedis.timeseries.TSMGetElement;
import redis.clients.jedis.timeseries.TSMRangeElements;
import redis.clients.jedis.util.KeyValue;

public final class TimeSeriesBuilderFactory {
    public static final Builder<TSElement> TIMESERIES_ELEMENT = new Builder<TSElement>(){

        @Override
        public TSElement build(Object data2) {
            List list = (List)data2;
            if (list == null || list.isEmpty()) {
                return null;
            }
            return new TSElement(BuilderFactory.LONG.build(list.get(0)), BuilderFactory.DOUBLE.build(list.get(1)));
        }
    };
    public static final Builder<List<TSElement>> TIMESERIES_ELEMENT_LIST = new Builder<List<TSElement>>(){

        @Override
        public List<TSElement> build(Object data2) {
            return ((List)data2).stream().map(pairObject -> (List)pairObject).map(pairList -> new TSElement(BuilderFactory.LONG.build(pairList.get(0)), BuilderFactory.DOUBLE.build(pairList.get(1)))).collect(Collectors.toList());
        }
    };
    public static final Builder<Map<String, TSMRangeElements>> TIMESERIES_MRANGE_RESPONSE = new Builder<Map<String, TSMRangeElements>>(){

        @Override
        public Map<String, TSMRangeElements> build(Object data2) {
            return ((List)data2).stream().map(tsObject -> (List)tsObject).map(tsList -> new TSMRangeElements(BuilderFactory.STRING.build(tsList.get(0)), BuilderFactory.STRING_MAP_FROM_PAIRS.build(tsList.get(1)), TIMESERIES_ELEMENT_LIST.build(tsList.get(2)))).collect(Collectors.toMap(AbstractMap.SimpleImmutableEntry::getKey, Function.identity(), (x, y) -> x, LinkedHashMap::new));
        }
    };
    public static final Builder<Map<String, TSMRangeElements>> TIMESERIES_MRANGE_RESPONSE_RESP3 = new Builder<Map<String, TSMRangeElements>>(){

        @Override
        public Map<String, TSMRangeElements> build(Object data2) {
            List dataList = (List)data2;
            LinkedHashMap<String, TSMRangeElements> map2 = new LinkedHashMap<String, TSMRangeElements>(dataList.size() / 2, 1.0f);
            for (KeyValue kv : dataList) {
                TSMRangeElements elements;
                String key2 = BuilderFactory.STRING.build(kv.getKey());
                List valueList = (List)kv.getValue();
                switch (valueList.size()) {
                    case 3: {
                        List aggrMapObj = (List)valueList.get(1);
                        KeyValue aggKV = (KeyValue)aggrMapObj.get(0);
                        assert ("aggregators".equalsIgnoreCase(BuilderFactory.STRING.build(aggKV.getKey())));
                        elements = new TSMRangeElements(key2, BuilderFactory.STRING_MAP.build(valueList.get(0)), ((List)aggKV.getValue()).stream().map(BuilderFactory.STRING::build).map(AggregationType::safeValueOf).collect(Collectors.toList()), TIMESERIES_ELEMENT_LIST.build(valueList.get(2)));
                        break;
                    }
                    case 4: {
                        List rdcMapObj = (List)valueList.get(1);
                        assert ("reducers".equalsIgnoreCase(BuilderFactory.STRING.build(((KeyValue)rdcMapObj.get(0)).getKey())));
                        List srcMapObj = (List)valueList.get(2);
                        assert ("sources".equalsIgnoreCase(BuilderFactory.STRING.build(((KeyValue)srcMapObj.get(0)).getKey())));
                        elements = new TSMRangeElements(key2, BuilderFactory.STRING_MAP.build(valueList.get(0)), BuilderFactory.STRING_LIST.build(((KeyValue)rdcMapObj.get(0)).getValue()), BuilderFactory.STRING_LIST.build(((KeyValue)srcMapObj.get(0)).getValue()), TIMESERIES_ELEMENT_LIST.build(valueList.get(3)));
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                map2.put(key2, elements);
            }
            return map2;
        }
    };
    public static final Builder<Map<String, TSMGetElement>> TIMESERIES_MGET_RESPONSE = new Builder<Map<String, TSMGetElement>>(){

        @Override
        public Map<String, TSMGetElement> build(Object data2) {
            return ((List)data2).stream().map(tsObject -> (List)tsObject).map(tsList -> new TSMGetElement(BuilderFactory.STRING.build(tsList.get(0)), BuilderFactory.STRING_MAP_FROM_PAIRS.build(tsList.get(1)), TIMESERIES_ELEMENT.build(tsList.get(2)))).collect(Collectors.toMap(AbstractMap.SimpleImmutableEntry::getKey, Function.identity()));
        }
    };
    public static final Builder<Map<String, TSMGetElement>> TIMESERIES_MGET_RESPONSE_RESP3 = new Builder<Map<String, TSMGetElement>>(){

        @Override
        public Map<String, TSMGetElement> build(Object data2) {
            List dataList = (List)data2;
            LinkedHashMap<String, TSMGetElement> map2 = new LinkedHashMap<String, TSMGetElement>(dataList.size());
            for (KeyValue kv : dataList) {
                String key2 = BuilderFactory.STRING.build(kv.getKey());
                List valueList = (List)kv.getValue();
                TSMGetElement value2 = new TSMGetElement(key2, BuilderFactory.STRING_MAP.build(valueList.get(0)), TIMESERIES_ELEMENT.build(valueList.get(1)));
                map2.put(key2, value2);
            }
            return map2;
        }
    };

    private TimeSeriesBuilderFactory() {
        throw new InstantiationError("Must not instantiate this class");
    }
}

