/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JedisByteHashMap
implements Map<byte[], byte[]>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6971431362627219416L;
    private final Map<ByteArrayWrapper, byte[]> internalMap = new HashMap<ByteArrayWrapper, byte[]>();

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public boolean containsKey(Object key2) {
        if (key2 instanceof byte[]) {
            return this.internalMap.containsKey(new ByteArrayWrapper((byte[])key2));
        }
        return this.internalMap.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.internalMap.containsValue(value2);
    }

    @Override
    public Set<Map.Entry<byte[], byte[]>> entrySet() {
        Iterator<Map.Entry<ByteArrayWrapper, byte[]>> iterator2 = this.internalMap.entrySet().iterator();
        HashSet<Map.Entry<byte[], byte[]>> hashSet = new HashSet<Map.Entry<byte[], byte[]>>();
        while (iterator2.hasNext()) {
            Map.Entry<ByteArrayWrapper, byte[]> entry = iterator2.next();
            hashSet.add(new JedisByteEntry(entry.getKey().data, entry.getValue()));
        }
        return hashSet;
    }

    @Override
    public byte[] get(Object key2) {
        if (key2 instanceof byte[]) {
            return this.internalMap.get(new ByteArrayWrapper((byte[])key2));
        }
        return this.internalMap.get(key2);
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public Set<byte[]> keySet() {
        HashSet<byte[]> keySet = new HashSet<byte[]>();
        Iterator<ByteArrayWrapper> iterator2 = this.internalMap.keySet().iterator();
        while (iterator2.hasNext()) {
            keySet.add(iterator2.next().data);
        }
        return keySet;
    }

    @Override
    public byte[] put(byte[] key2, byte[] value2) {
        return this.internalMap.put(new ByteArrayWrapper(key2), value2);
    }

    @Override
    public void putAll(Map<? extends byte[], ? extends byte[]> m4) {
        for (Map.Entry<? extends byte[], ? extends byte[]> next2 : m4.entrySet()) {
            this.internalMap.put(new ByteArrayWrapper(next2.getKey()), next2.getValue());
        }
    }

    @Override
    public byte[] remove(Object key2) {
        if (key2 instanceof byte[]) {
            return this.internalMap.remove(new ByteArrayWrapper((byte[])key2));
        }
        return this.internalMap.remove(key2);
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public Collection<byte[]> values() {
        return this.internalMap.values();
    }

    private static final class JedisByteEntry
    implements Map.Entry<byte[], byte[]> {
        private byte[] value;
        private byte[] key;

        public JedisByteEntry(byte[] key2, byte[] value2) {
            this.key = key2;
            this.value = value2;
        }

        @Override
        public byte[] getKey() {
            return this.key;
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public byte[] setValue(byte[] value2) {
            this.value = value2;
            return value2;
        }
    }

    private static final class ByteArrayWrapper
    implements Serializable {
        private final byte[] data;

        public ByteArrayWrapper(byte[] data2) {
            if (data2 == null) {
                throw new NullPointerException();
            }
            this.data = data2;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof ByteArrayWrapper)) {
                return false;
            }
            return Arrays.equals(this.data, ((ByteArrayWrapper)other).data);
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }
}

