/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import redis.clients.jedis.util.SafeEncoder;

public final class JedisClusterHashTag {
    private JedisClusterHashTag() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static String getHashTag(String key2) {
        return JedisClusterHashTag.extractHashTag(key2, true);
    }

    public static boolean isClusterCompliantMatchPattern(byte[] matchPattern) {
        return JedisClusterHashTag.isClusterCompliantMatchPattern(SafeEncoder.encode(matchPattern));
    }

    public static boolean isClusterCompliantMatchPattern(String matchPattern) {
        String tag = JedisClusterHashTag.extractHashTag(matchPattern, false);
        return tag != null && !tag.isEmpty();
    }

    private static String extractHashTag(String key2, boolean returnKeyOnAbsence) {
        int e2;
        int s2 = key2.indexOf("{");
        if (s2 > -1 && (e2 = key2.indexOf("}", s2 + 1)) > -1 && e2 != s2 + 1) {
            return key2.substring(s2 + 1, e2);
        }
        return returnKeyOnAbsence ? key2 : null;
    }
}

