/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import java.net.URI;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.RedisProtocol;

public final class JedisURIHelper {
    private static final String REDIS = "redis";
    private static final String REDISS = "rediss";

    private JedisURIHelper() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static HostAndPort getHostAndPort(URI uri2) {
        return new HostAndPort(uri2.getHost(), uri2.getPort());
    }

    public static String getUser(URI uri2) {
        String userInfo = uri2.getUserInfo();
        if (userInfo != null) {
            String user = userInfo.split(":", 2)[0];
            if (user.isEmpty()) {
                user = null;
            }
            return user;
        }
        return null;
    }

    public static String getPassword(URI uri2) {
        String userInfo = uri2.getUserInfo();
        if (userInfo != null) {
            return userInfo.split(":", 2)[1];
        }
        return null;
    }

    public static int getDBIndex(URI uri2) {
        String[] pathSplit = uri2.getPath().split("/", 2);
        if (pathSplit.length > 1) {
            String dbIndexStr = pathSplit[1];
            if (dbIndexStr.isEmpty()) {
                return 0;
            }
            return Integer.parseInt(dbIndexStr);
        }
        return 0;
    }

    public static RedisProtocol getRedisProtocol(URI uri2) {
        String[] params;
        if (uri2.getQuery() == null) {
            return null;
        }
        for (String param : params = uri2.getQuery().split("&")) {
            int idx = param.indexOf("=");
            if (idx < 0 || !"protocol".equals(param.substring(0, idx))) continue;
            String ver = param.substring(idx + 1);
            for (RedisProtocol proto : RedisProtocol.values()) {
                if (!proto.version().equals(ver)) continue;
                return proto;
            }
            throw new IllegalArgumentException("Unknown protocol " + ver);
        }
        return null;
    }

    public static boolean isValid(URI uri2) {
        return !JedisURIHelper.isEmpty(uri2.getScheme()) && !JedisURIHelper.isEmpty(uri2.getHost()) && uri2.getPort() != -1;
    }

    private static boolean isEmpty(String value2) {
        return value2 == null || value2.trim().length() == 0;
    }

    public static boolean isRedisScheme(URI uri2) {
        return REDIS.equals(uri2.getScheme());
    }

    public static boolean isRedisSSLScheme(URI uri2) {
        return REDISS.equals(uri2.getScheme());
    }
}

