/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.exceptions.JedisException;

public class Pool<T>
extends GenericObjectPool<T> {
    public Pool(GenericObjectPoolConfig<T> poolConfig, PooledObjectFactory<T> factory2) {
        this(factory2, poolConfig);
    }

    public Pool(PooledObjectFactory<T> factory2, GenericObjectPoolConfig<T> poolConfig) {
        super(factory2, poolConfig);
    }

    public Pool(PooledObjectFactory<T> factory2) {
        super(factory2);
    }

    @Override
    public void close() {
        this.destroy();
    }

    public void destroy() {
        try {
            super.close();
        }
        catch (RuntimeException e2) {
            throw new JedisException("Could not destroy the pool", e2);
        }
    }

    public T getResource() {
        try {
            return super.borrowObject();
        }
        catch (JedisException je) {
            throw je;
        }
        catch (Exception e2) {
            throw new JedisException("Could not get a resource from the pool", e2);
        }
    }

    public void returnResource(T resource2) {
        if (resource2 == null) {
            return;
        }
        try {
            super.returnObject(resource2);
        }
        catch (RuntimeException e2) {
            throw new JedisException("Could not return the resource to the pool", e2);
        }
    }

    public void returnBrokenResource(T resource2) {
        if (resource2 == null) {
            return;
        }
        try {
            super.invalidateObject(resource2);
        }
        catch (Exception e2) {
            throw new JedisException("Could not return the broken resource to the pool", e2);
        }
    }

    @Override
    public void addObjects(int count2) {
        try {
            for (int i2 = 0; i2 < count2; ++i2) {
                this.addObject();
            }
        }
        catch (Exception e2) {
            throw new JedisException("Error trying to add idle objects", e2);
        }
    }
}

