/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import redis.clients.jedis.CommandKeyArgumentPreProcessor;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.args.RawableFactory;
import redis.clients.jedis.util.SafeEncoder;

@Experimental
public class PrefixedKeyArgumentPreProcessor
implements CommandKeyArgumentPreProcessor {
    private final byte[] prefixBytes;
    private final String prefixString;

    public PrefixedKeyArgumentPreProcessor(String prefix2) {
        this(prefix2, SafeEncoder.encode(prefix2));
    }

    public PrefixedKeyArgumentPreProcessor(String prefixString, byte[] prefixBytes) {
        this.prefixString = prefixString;
        this.prefixBytes = prefixBytes;
    }

    @Override
    public Object actualKey(Object paramKey) {
        return PrefixedKeyArgumentPreProcessor.prefixKey(paramKey, this.prefixString, this.prefixBytes);
    }

    private static Object prefixKey(Object key2, String prefixString, byte[] prefixBytes) {
        if (key2 instanceof Rawable) {
            byte[] raw = ((Rawable)key2).getRaw();
            return RawableFactory.from(PrefixedKeyArgumentPreProcessor.prefixKeyWithBytes(raw, prefixBytes));
        }
        if (key2 instanceof byte[]) {
            return PrefixedKeyArgumentPreProcessor.prefixKeyWithBytes((byte[])key2, prefixBytes);
        }
        if (key2 instanceof String) {
            String raw = (String)key2;
            return prefixString + raw;
        }
        throw new IllegalArgumentException("\"" + key2.toString() + "\" is not a valid argument.");
    }

    private static byte[] prefixKeyWithBytes(byte[] key2, byte[] prefixBytes) {
        byte[] namespaced = new byte[prefixBytes.length + key2.length];
        System.arraycopy(prefixBytes, 0, namespaced, 0, prefixBytes.length);
        System.arraycopy(key2, 0, namespaced, prefixBytes.length, key2.length);
        return namespaced;
    }
}

