/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.util.DoublePrecision;

public class RedisInputStream
extends FilterInputStream {
    private static final int INPUT_BUFFER_SIZE = Integer.parseInt(System.getProperty("jedis.bufferSize.input", System.getProperty("jedis.bufferSize", "8192")));
    protected final byte[] buf;
    protected int count;
    protected int limit;

    public RedisInputStream(InputStream in, int size2) {
        super(in);
        if (size2 <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size2];
    }

    public RedisInputStream(InputStream in) {
        this(in, INPUT_BUFFER_SIZE);
    }

    @Experimental
    public boolean peek(byte b2) throws JedisConnectionException {
        this.ensureFill();
        return this.buf[this.count] == b2;
    }

    public byte readByte() throws JedisConnectionException {
        this.ensureFill();
        return this.buf[this.count++];
    }

    private void ensureCrLf() {
        byte[] buf = this.buf;
        this.ensureFill();
        if (buf[this.count++] == 13) {
            this.ensureFill();
            if (buf[this.count++] == 10) {
                return;
            }
        }
        throw new JedisConnectionException("Unexpected character!");
    }

    public String readLine() {
        StringBuilder sb = new StringBuilder();
        while (true) {
            this.ensureFill();
            byte b2 = this.buf[this.count++];
            if (b2 == 13) {
                this.ensureFill();
                byte c2 = this.buf[this.count++];
                if (c2 == 10) break;
                sb.append((char)b2);
                sb.append((char)c2);
                continue;
            }
            sb.append((char)b2);
        }
        String reply = sb.toString();
        if (reply.isEmpty()) {
            throw new JedisConnectionException("It seems like server has closed the connection.");
        }
        return reply;
    }

    public byte[] readLineBytes() {
        this.ensureFill();
        int pos = this.count;
        byte[] buf = this.buf;
        while (true) {
            if (pos == this.limit) {
                return this.readLineBytesSlowly();
            }
            if (buf[pos++] != 13) continue;
            if (pos == this.limit) {
                return this.readLineBytesSlowly();
            }
            if (buf[pos++] == 10) break;
        }
        int N2 = pos - this.count - 2;
        byte[] line = new byte[N2];
        System.arraycopy(buf, this.count, line, 0, N2);
        this.count = pos;
        return line;
    }

    private byte[] readLineBytesSlowly() {
        ByteArrayOutputStream bout = null;
        while (true) {
            this.ensureFill();
            byte b2 = this.buf[this.count++];
            if (b2 == 13) {
                this.ensureFill();
                byte c2 = this.buf[this.count++];
                if (c2 == 10) break;
                if (bout == null) {
                    bout = new ByteArrayOutputStream(16);
                }
                bout.write(b2);
                bout.write(c2);
                continue;
            }
            if (bout == null) {
                bout = new ByteArrayOutputStream(16);
            }
            bout.write(b2);
        }
        return bout == null ? new byte[]{} : bout.toByteArray();
    }

    public Object readNullCrLf() {
        this.ensureCrLf();
        return null;
    }

    public boolean readBooleanCrLf() {
        byte[] buf = this.buf;
        this.ensureFill();
        byte b2 = buf[this.count++];
        this.ensureCrLf();
        switch (b2) {
            case 116: {
                return true;
            }
            case 102: {
                return false;
            }
        }
        throw new JedisConnectionException("Unexpected character!");
    }

    public int readIntCrLf() {
        return (int)this.readLongCrLf();
    }

    public long readLongCrLf() {
        boolean isNeg;
        byte[] buf = this.buf;
        this.ensureFill();
        boolean bl = isNeg = buf[this.count] == 45;
        if (isNeg) {
            ++this.count;
        }
        long value2 = 0L;
        while (true) {
            this.ensureFill();
            byte b2 = buf[this.count++];
            if (b2 == 13) {
                this.ensureFill();
                if (buf[this.count++] == 10) break;
                throw new JedisConnectionException("Unexpected character!");
            }
            value2 = value2 * 10L + (long)b2 - 48L;
        }
        return isNeg ? -value2 : value2;
    }

    public double readDoubleCrLf() {
        return DoublePrecision.parseFloatingPointNumber(this.readLine());
    }

    public BigInteger readBigIntegerCrLf() {
        return new BigInteger(this.readLine());
    }

    @Override
    public int read(byte[] b2, int off, int len2) throws JedisConnectionException {
        this.ensureFill();
        int length = Math.min(this.limit - this.count, len2);
        System.arraycopy(this.buf, this.count, b2, off, length);
        this.count += length;
        return length;
    }

    private void ensureFill() throws JedisConnectionException {
        if (this.count >= this.limit) {
            try {
                this.limit = this.in.read(this.buf);
                this.count = 0;
                if (this.limit == -1) {
                    throw new JedisConnectionException("Unexpected end of stream.");
                }
            }
            catch (IOException e2) {
                throw new JedisConnectionException(e2);
            }
        }
    }

    @Override
    public int available() throws IOException {
        int availableInBuf = this.limit - this.count;
        int availableInSocket = this.in.available();
        return availableInBuf > availableInSocket ? availableInBuf : availableInSocket;
    }
}

