const leftSidebar = document.getElementById('left-sidebar');
const leftSidebarToggle = document.getElementById('left-sidebar-toggle');

function expandSidebar() {
  leftSidebar.setAttribute('aria-expanded', 'true');
}

function collapseSidebar() {
  leftSidebar.setAttribute('aria-expanded', 'false');
}

// Open on toggle hover
leftSidebarToggle.addEventListener('mouseenter', () => {
  expandSidebar();
});

// Toggle click pins/unpins
leftSidebarToggle.addEventListener('click', (e) => {
  e.stopPropagation();
  const isExpanded = leftSidebar.getAttribute('aria-expanded') === 'true';
  if (isExpanded) {
    collapseSidebar();
  } else {
    expandSidebar();
  }
});

// Prevent clicks inside sidebar from closing it
leftSidebar.addEventListener('click', (e) => {
  e.stopPropagation();
});

document.addEventListener("DOMContentLoaded", collapseSidebar);
