const workflowScreen = document.getElementById('workflow');
const workflowButtons = document.querySelectorAll(".workflow-btn");
const workflowMiniBtn = document.querySelector("#workflowMiniBtn")
const specList = document.querySelector("#spec-list");
const editor = document.querySelector("workflow-editor");

function addStylesToEditor(editor) {
    const style = document.createElement("style");
    style.innerHTML = "@import './static/libs/workflow_editor/workflow_editor.css';";
    editor.shadowRoot.appendChild(style);
}

const tooltip = new bootstrap.Tooltip(workflowMiniBtn);

workflowButtons.forEach(workflowBtn => {
    workflowBtn?.addEventListener("click", async () => {
        if (tooltip && workflowBtn === workflowMiniBtn) tooltip.hide();
        workflowBtn.blur();
        await Workspace.switchTo(Workspace.WORKFLOW_SCREEN_ID)
    });
});

document.addEventListener("DOMContentLoaded", () => addStylesToEditor(editor));
const workflowEditor = document.querySelector('workflow-editor');
editor.onWorkflowExported = (data) => {
    const specFilePath = data.specFilePath;
    waitForPath({ path: specFilePath }).then(switchNode => {
        if (switchNode) {
            highlightAndSwitchTo({ node: switchNode });
        } else {
            console.warn("Node not found for path:", specFilePath);
        }
    });
};

/* INPUT EDITOR */
async function initInputsEditor(screen) {
    const { data, error } = await makeHttpCall("/workflow/input", { method: "GET", queryParams: { specPath: screen.id } });
    if (error) {
        createAlert({ title: "Failed to get inputs content", message: error, type: "error" });
        throw new Error(error);
    }

    const inputsTab = screen.querySelector("div.example");
    const loader = inputsTab.querySelector('#example-tab-loader');
    const specContainer = inputsTab.querySelector(".container");
    await initSpecEditorInternal(data, loader, specContainer);
}

async function loadMermaidDiagram(container, mermaidContainer) {
    const isInSpecTab = mermaidContainer.closest(".spec");
    if (!isInSpecTab) return;

    const nearestScreen = container.closest(".screen");
    if (!nearestScreen) return;

    const fileType = nearestScreen.getAttribute('data-file-type');
    if (fileType !== "arazzo") return;

    const specPath = nearestScreen.getAttribute('id');
    const { data, error } = await makeHttpCall("/workflow/diagram", { method: "GET", queryParams: { specPath } });
    if (error) {
        createAlert({ title: "Failed to get workflow diagram", message: error, type: "error" });
        throw new Error(error);
    }

    const diagramContainer = mermaidContainer.querySelector('.mermaid');
    await renderMermaidDiagram(diagramContainer, data);
}
