const leftSidebar = document.getElementById('left-sidebar');
const leftSidebarToggle = document.getElementById('left-sidebar-toggle');

function expandSidebar() {
  leftSidebar.setAttribute('aria-expanded', 'true');
}

function collapseSidebar() {
  leftSidebar.setAttribute('aria-expanded', 'false');
}

function handleExit() {
  const shouldAutoClose = checkIfShouldAutoClose();
  if (shouldAutoClose) collapseSidebar();
}

function checkIfShouldAutoClose() {
  const isWorkflowActive = !workflowScreen.hasAttribute("inert");
  return !isWorkflowActive;
}

leftSidebarToggle.addEventListener('mouseenter', () => {
  expandSidebar();
});

leftSidebarToggle.addEventListener('click', (e) => {
  e.stopPropagation();
  const isExpanded = leftSidebar.getAttribute('aria-expanded') === 'true';
  if (isExpanded) {
    collapseSidebar();
  } else {
    expandSidebar();
  }
});

leftSidebarToggle.addEventListener('mouseleave', (e) => {
  setTimeout(() => {
    if (!leftSidebar.matches(':hover')) handleExit();
  }, 200);
});

leftSidebar.addEventListener('mouseleave', () => {
  handleExit();
});

leftSidebar.addEventListener('click', (e) => {
  e.stopPropagation();
});

document.addEventListener("DOMContentLoaded", collapseSidebar);
