const rightSidebar = document.getElementById("right-sidebar");
const rightSidebarToggle = document.getElementById("right-sidebar-toggle");

if (rightSidebar && rightSidebarToggle) {
    rightSidebarToggle.addEventListener("click", (e) => {
        e.stopPropagation();
        const expanded = rightSidebar.getAttribute("aria-expanded") === "true";
        rightSidebar.setAttribute("aria-expanded", expanded ? "false" : "true");
    });


    document.addEventListener("click", (e) => {

        // Clean up class after animation so DOM stays tidy
        (function initRightSidebarPulseCleanup(){
            const toggle = document.getElementById('right-sidebar-toggle');
            if(!toggle) return;
            toggle.addEventListener('animationend', (e) => {
                if(e.animationName === 'sidebar-pulse' || e.animationName === 'sidebar-outline') {
                    toggle.classList.remove('attention-pulse');
                }
            });
        })();


        if (
            rightSidebar.getAttribute("aria-expanded") === "true" &&
            !rightSidebar.contains(e.target) &&
            !rightSidebarToggle.contains(e.target)
        ) {
            rightSidebar.setAttribute("aria-expanded", "false");
        }
    });

    rightSidebar.addEventListener('mouseenter', () => {
        rightSidebarToggle.style.right = '-2%';
        rightSidebarToggle.style.transition = 'right 0.3s ease';
    });

    rightSidebar.addEventListener('mouseleave', () => {
        rightSidebarToggle.style.right = '0';
        rightSidebarToggle.style.transition = 'right 0.3s ease';
    });
}

// --- Attention Pulse Utility ---
function triggerRightSidebarPulse() {
    const toggle = document.getElementById('right-sidebar-toggle');
    if (!toggle) return;
    // Remove to allow retrigger
    toggle.classList.remove('attention-pulse');
    // Force reflow to restart animation even if class was present
    void toggle.offsetWidth;
    toggle.classList.add('attention-pulse');
}

function updateBadge(count) {
    if(count <= 0) return;
    const badge = document.getElementById("activity-badge");
    badge.textContent = count;
    badge.style.display = "inline";
}

function animateBadgeTemporarily() {
    if(rightSidebarToggle) triggerRightSidebarPulse();
    const badge = document.getElementById("activity-badge");
    if (!badge) return;
    badge.classList.remove("pulse-animation");

    badge.classList.add("pulse-animation");

    setTimeout(() => {
        badge.classList.remove("pulse-animation");
    }, 5000);
}

